/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.AssetsResult;
import org.apache.nifi.web.api.entity.AssetsEntity;

public class ListAssets
extends AbstractNiFiCommand<AssetsResult> {
    public ListAssets() {
        super("list-assets", AssetsResult.class);
    }

    @Override
    public String getDescription() {
        return "Lists the assets in the given parameter context.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
    }

    @Override
    public AssetsResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        ParamContextClient paramContextClient = client.getParamContextClient();
        AssetsEntity assetsEntity = paramContextClient.getAssets(paramContextId);
        return new AssetsResult(this.getResultType(properties), assetsEntity);
    }
}

