/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.FileUtils;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.Packager;

public abstract class AbstractPackagerTask
implements Packager.Task {
    private final ExecutionContext context;

    protected AbstractPackagerTask(ExecutionContext context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public final void validateCreateImage() throws Exception {
        this.checkImageRequirements();
    }

    @Override
    public final void validateCreatePackage() throws Exception {
        this.checkPackageRequirements();
    }

    @Override
    public final Path createImage(Path input) throws Exception {
        Path mergeSource;
        String imageName = this.calculateImageName(input);
        Path image = this.context.destination().resolve(imageName);
        Files.createDirectory(image, new FileAttribute[0]);
        Path appDir = this.calculateAppPath(image);
        Files.createDirectories(appDir, new FileAttribute[0]);
        if (Files.isDirectory(input, new LinkOption[0])) {
            this.copyAppFromDirectory(input, appDir);
        } else if (Files.isRegularFile(input, new LinkOption[0])) {
            this.extractAppFromArchive(input, appDir);
        } else {
            throw new IllegalArgumentException(input.toString());
        }
        Path runtime = this.context.getValue(NBPackage.PACKAGE_RUNTIME).map(Path::toAbsolutePath).orElse(null);
        if (runtime != null) {
            Path runtimeDir = this.calculateRuntimePath(image, appDir);
            Files.createDirectories(runtimeDir, new FileAttribute[0]);
            if (Files.isDirectory(runtime, new LinkOption[0])) {
                this.copyRuntimeFromDirectory(runtime, runtimeDir);
            } else if (Files.isRegularFile(runtime, new LinkOption[0])) {
                this.extractRuntimeFromArchive(runtime, runtimeDir);
            } else {
                throw new IllegalArgumentException(runtime.toString());
            }
            if (runtimeDir.startsWith(appDir)) {
                String jdkhome = appDir.relativize(runtimeDir).toString();
                try (DirectoryStream<Path> confs = Files.newDirectoryStream(appDir.resolve("etc"), "*.conf");){
                    for (Path conf : confs) {
                        this.addRuntimeToConf(conf, jdkhome);
                    }
                }
            }
        }
        this.customizeImage(image);
        String filterPattern = this.context.getValue(NBPackage.PACKAGE_REMOVE).orElse(null);
        if (filterPattern != null) {
            this.removeFromImage(image, filterPattern);
        }
        if ((mergeSource = (Path)this.context.getValue(NBPackage.PACKAGE_MERGE).map(Path::toAbsolutePath).orElse(null)) != null) {
            Path rootDir = this.calculateRootPath(image);
            if (Files.isDirectory(mergeSource, new LinkOption[0])) {
                this.processMergeFromDirectory(mergeSource, image, rootDir);
            } else if (Files.isRegularFile(mergeSource, new LinkOption[0])) {
                this.processMergeFromArchive(mergeSource, image, rootDir);
            } else {
                throw new IllegalArgumentException(mergeSource.toString());
            }
        }
        this.finalizeImage(image);
        return image;
    }

    @Override
    public final Path createPackage(Path image) throws Exception {
        return this.buildPackage(image);
    }

    protected void checkImageRequirements() throws Exception {
    }

    protected void checkPackageRequirements() throws Exception {
    }

    protected abstract void customizeImage(Path var1) throws Exception;

    protected void finalizeImage(Path image) throws Exception {
    }

    protected abstract Path buildPackage(Path var1) throws Exception;

    protected final ExecutionContext context() {
        return this.context;
    }

    protected String calculateImageName(Path input) throws Exception {
        String appName = this.context.getValue(NBPackage.PACKAGE_NAME).orElseThrow();
        String appVersion = this.context.getValue(NBPackage.PACKAGE_VERSION).orElseThrow();
        return this.sanitize(appName) + "-" + this.sanitize(appVersion);
    }

    protected Path calculateAppPath(Path image) throws Exception {
        return image;
    }

    protected Path calculateRuntimePath(Path image, Path application) throws Exception {
        return application.resolve("jdk");
    }

    protected Path calculateRootPath(Path image) throws Exception {
        return image;
    }

    private void extractAppFromArchive(Path input, Path destDir) throws IOException {
        Path tmp = Files.createTempDirectory("nbpackageImageExtract", new FileAttribute[0]);
        FileUtils.extractArchive(input, tmp);
        List<Path> images = FileUtils.findDirs(tmp, 5, "bin/*", "etc/*.conf");
        if (images.size() != 1) {
            throw new IOException(input.toString());
        }
        Path image = images.get(0);
        FileUtils.moveFiles(image, destDir);
        FileUtils.deleteFiles(tmp);
    }

    private void copyAppFromDirectory(Path input, Path destDir) throws IOException {
        List<Path> images = FileUtils.findDirs(input, 5, "bin/*", "etc/*.conf");
        if (images.size() != 1) {
            throw new IOException(input.toString());
        }
        Path image = images.get(0);
        FileUtils.copyFiles(image, destDir);
    }

    private String sanitize(String name) {
        return name.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    private void extractRuntimeFromArchive(Path runtime, Path destDir) throws IOException {
        Path tmp = Files.createTempDirectory("nbpackageRuntimeExtract", new FileAttribute[0]);
        FileUtils.extractArchive(runtime, tmp);
        List<Path> runtimes = FileUtils.findDirs(tmp, 5, "bin/java*");
        if (runtimes.size() != 1) {
            throw new IOException(runtime.toString());
        }
        Path java = runtimes.get(0);
        FileUtils.moveFiles(java, destDir);
        FileUtils.deleteFiles(tmp);
    }

    private void copyRuntimeFromDirectory(Path runtime, Path destDir) throws IOException {
        List<Path> runtimes = FileUtils.findDirs(runtime, 5, "bin/java*");
        if (runtimes.size() != 1) {
            throw new IOException(runtime.toString());
        }
        Path java = runtimes.get(0);
        FileUtils.copyFiles(java, destDir);
    }

    private void addRuntimeToConf(Path conf, String jdkhome) throws IOException {
        String contents = Files.readString(conf);
        contents = contents.replace("#jdkhome=\"/path/to/jdk\"", "jdkhome=\"" + jdkhome + "\"");
        Files.writeString(conf, (CharSequence)contents, new OpenOption[0]);
    }

    private void removeFromImage(Path image, String pattern) throws IOException {
        List<Path> filesToRemove = FileUtils.find(image, pattern);
        String message = this.context().isVerbose() ? NBPackage.MESSAGES.getString("message.removing") : null;
        for (Path file : filesToRemove) {
            if (message != null) {
                this.context().infoHandler().accept(MessageFormat.format(message, image.getParent().relativize(file)));
            }
            FileUtils.deleteFiles(file);
        }
    }

    private void processMergeFromArchive(Path archive, Path image, Path rootDir) throws IOException {
        Path tmp = Files.createTempDirectory("nbpackageMergeExtract", new FileAttribute[0]);
        FileUtils.extractArchive(archive, tmp);
        this.processMergeFromDirectory(tmp, image, rootDir);
        FileUtils.deleteFiles(tmp);
    }

    private void processMergeFromDirectory(Path sourceDir, Path imageDir, Path rootDir) throws IOException {
        String messageFile = this.context().isVerbose() ? NBPackage.MESSAGES.getString("message.mergingfile") : null;
        String messageDir = this.context().isVerbose() ? NBPackage.MESSAGES.getString("message.mergingdir") : null;
        try (Stream<Path> stream = Files.list(sourceDir);){
            List files = stream.sorted().collect(Collectors.toList());
            for (Path file : files) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    Path dest;
                    String name = file.getFileName().toString();
                    if ("__ROOT".equals(name)) {
                        dest = rootDir;
                    } else {
                        dest = imageDir.resolve(name);
                        Files.createDirectories(dest, new FileAttribute[0]);
                    }
                    if (messageDir != null) {
                        this.context().infoHandler().accept(MessageFormat.format(messageDir, sourceDir.relativize(file), imageDir.getParent().relativize(dest)));
                    }
                    FileUtils.copyFiles(file, dest);
                    continue;
                }
                Path dest = imageDir.resolve(file.getFileName());
                if (messageFile != null) {
                    this.context().infoHandler().accept(MessageFormat.format(messageFile, sourceDir.relativize(file), imageDir.getParent().relativize(dest)));
                }
                Files.copy(file, dest, StandardCopyOption.COPY_ATTRIBUTES);
                FileUtils.ensureWritable(dest);
            }
        }
    }
}

