/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.netbeans.spi.java.platform.support.ForwardingJavaPlatform;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class ProjectPlatform {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private static final Map<Project, JavaPlatform> platformsByProject = new WeakHashMap<Project, JavaPlatform>();
    private static final Map<Project, FileObject> homesByProject = new WeakHashMap<Project, FileObject>();
    private static final Map<FileObject, JavaPlatform> platformsByHome = new WeakHashMap<FileObject, JavaPlatform>();

    private ProjectPlatform() {
        throw new IllegalStateException("No instance allowed");
    }

    @CheckForNull
    public static JavaPlatform forProject(@NonNull Project owner, @NonNull PropertyEvaluator eval, @NonNull String platformType) {
        Parameters.notNull("owner", owner);
        Parameters.notNull("eval", eval);
        Parameters.notNull("platformType", platformType);
        String platformName = eval.getProperty(PLATFORM_ACTIVE);
        FileObject jdkHome = ProjectPlatform.resolvePlatformHome(platformName, owner.getProjectDirectory(), eval);
        if (jdkHome == null) {
            return null;
        }
        return ProjectPlatform.forProject(owner, jdkHome, platformName, platformType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static JavaPlatform forProject(@NonNull Project owner, @NonNull FileObject platformHome, final @NonNull String platformName, @NonNull String platformType) {
        JavaPlatform delegate;
        JavaPlatform res;
        Parameters.notNull("owner", owner);
        Parameters.notNull("platformHome", platformHome);
        Parameters.notNull("platformName", platformName);
        Parameters.notNull("platformType", platformType);
        Map<Project, JavaPlatform> map = platformsByProject;
        synchronized (map) {
            res = platformsByProject.get(platformHome);
            delegate = res == null ? platformsByHome.get(platformHome) : null;
        }
        if (res == null) {
            boolean newDelegate = false;
            if (delegate == null) {
                delegate = Optional.ofNullable(ProjectPlatform.findJavaPlatform(platformHome, platformType)).orElseGet(() -> ProjectPlatform.createJavaPlatform(platformHome, platformType));
                newDelegate = true;
            }
            if (delegate != null) {
                res = new ForwardingJavaPlatform(delegate){
                    private AtomicReference<Map<String, String>> propsCache;
                    {
                        super(delegate);
                        this.propsCache = new AtomicReference();
                    }

                    @Override
                    public Map<String, String> getProperties() {
                        Map<String, String> props = this.propsCache.get();
                        if (props == null) {
                            props = new HashMap<String, String>(super.getProperties());
                            props.put("platform.ant.name", platformName);
                            props = Collections.unmodifiableMap(props);
                            this.propsCache.set(props);
                        }
                        return props;
                    }

                    @Override
                    public String getDisplayName() {
                        return platformName;
                    }
                };
            }
            if (res != null) {
                Map<Project, JavaPlatform> map2 = platformsByProject;
                synchronized (map2) {
                    platformsByProject.put(owner, res);
                    assert (delegate != null);
                    if (newDelegate) {
                        homesByProject.put(owner, platformHome);
                        platformsByHome.put(platformHome, delegate);
                    }
                }
            }
        }
        return res;
    }

    @CheckForNull
    private static FileObject resolvePlatformHome(@NullAllowed String platformName, @NonNull FileObject projectDir, @NonNull PropertyEvaluator eval) {
        File basedir;
        String homeProp;
        String path;
        if (platformName != null && (path = eval.getProperty(homeProp = String.format("platforms.%s.home", platformName))) != null && !path.isEmpty() && (basedir = FileUtil.toFile(projectDir)) != null) {
            return FileUtil.toFileObject(PropertyUtils.resolveFile(basedir, path));
        }
        return null;
    }

    @CheckForNull
    private static JavaPlatform findJavaPlatform(@NonNull FileObject jdkHome, @NonNull String platformType) {
        return Arrays.stream(JavaPlatformManager.getDefault().getPlatforms(null, new Specification(platformType, null))).filter(jp -> jp.getInstallFolders().contains(jdkHome)).findFirst().orElse(null);
    }

    @CheckForNull
    private static JavaPlatform createJavaPlatform(@NonNull FileObject jdkHome, @NonNull String platformType) {
        try {
            for (JavaPlatformFactory.Provider p : Lookup.getDefault().lookupAll(JavaPlatformFactory.Provider.class)) {
                JavaPlatformFactory f = p.forType(platformType);
                if (f == null) continue;
                return f.create(jdkHome, FileUtil.getFileDisplayName(jdkHome), false);
            }
            return null;
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }
}

