/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjavac.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.tools.javac.code.Attribute;
import jpt.sun.tools.javac.code.Kinds;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Types;
import jpt.sun.tools.javac.jvm.ClassWriter;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.ListBuffer;
import org.netbeans.lib.nbjavac.services.NBNames;

public class NBClassWriter
extends ClassWriter {
    private static final Logger LOG = Logger.getLogger(NBClassWriter.class.getName());
    private final NBNames nbNames;
    private final Types types;

    public static void preRegister(Context context) {
        context.put(classWriterKey, new Context.Factory<ClassWriter>(){

            @Override
            public ClassWriter make(Context c) {
                return new NBClassWriter(c);
            }
        });
    }

    protected NBClassWriter(Context context) {
        super(context);
        this.nbNames = NBNames.instance(context);
        this.types = Types.instance(context);
    }

    @Override
    protected int writeExtraAttributes(Symbol sym) {
        int attrs = super.writeExtraAttributes(sym);
        if (sym.kind == Kinds.Kind.MTH) {
            attrs += this.writeExtraParameterAttributes((Symbol.MethodSymbol)sym);
        }
        attrs += this.writeExtraJavaAnnotations(sym.getRawAttributes());
        return attrs += this.writeExtraTypeAnnotations(sym.getRawTypeAttributes());
    }

    protected int writeExtraParameterAttributes(Symbol.MethodSymbol m) {
        boolean hasSourceLevel = false;
        if (m.params != null) {
            block0: for (Symbol.VarSymbol s : m.params) {
                for (Attribute.Compound a : s.getRawAttributes()) {
                    if (this.types.getRetention(a) != Attribute.RetentionPolicy.SOURCE) continue;
                    hasSourceLevel = true;
                    continue block0;
                }
            }
        }
        int attrCount = 0;
        if (hasSourceLevel) {
            int attrIndex = this.writeAttr(this.nbNames._org_netbeans_SourceLevelParameterAnnotations);
            this.databuf.appendByte(m.params.length());
            for (Symbol.VarSymbol s : m.params) {
                ListBuffer<Attribute.Compound> buf = new ListBuffer<Attribute.Compound>();
                for (Attribute.Compound a : s.getRawAttributes()) {
                    if (this.types.getRetention(a) != Attribute.RetentionPolicy.SOURCE) continue;
                    buf.append(a);
                }
                this.databuf.appendChar(buf.length());
                for (Attribute.Compound a : buf) {
                    this.writeCompoundAttribute(a);
                }
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    protected int writeExtraJavaAnnotations(List<Attribute.Compound> attrs) {
        ListBuffer<Attribute.Compound> sourceLevel = new ListBuffer<Attribute.Compound>();
        for (Attribute.Compound a : attrs) {
            if (this.types.getRetention(a) != Attribute.RetentionPolicy.SOURCE) continue;
            sourceLevel.append(a);
        }
        int attrCount = 0;
        if (sourceLevel.nonEmpty()) {
            int attrIndex = this.writeAttr(this.nbNames._org_netbeans_SourceLevelAnnotations);
            this.databuf.appendChar(sourceLevel.length());
            for (Attribute.Compound a : sourceLevel) {
                this.writeCompoundAttribute(a);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    protected int writeExtraTypeAnnotations(List<Attribute.TypeCompound> attrs) {
        ListBuffer<Attribute.TypeCompound> sourceLevel = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound tc : attrs) {
            boolean fixed;
            if (tc.hasUnknownPosition() && !(fixed = tc.tryFixPosition()) || tc.position.type.isLocal() || !tc.position.emitToClassfile() || this.types.getRetention(tc) != Attribute.RetentionPolicy.SOURCE) continue;
            sourceLevel.append(tc);
        }
        int attrCount = 0;
        if (sourceLevel.nonEmpty()) {
            int attrIndex = this.writeAttr(this.nbNames._org_netbeans_SourceLevelTypeAnnotations);
            this.databuf.appendChar(sourceLevel.length());
            for (Attribute.TypeCompound p : sourceLevel) {
                this.writeTypeAnnotation(p);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    private void writeCompoundAttribute(Attribute.Compound a) {
        try {
            Method m = ClassWriter.class.getDeclaredMethod("writeCompoundAttribute", Attribute.Compound.class);
            m.setAccessible(true);
            m.invoke((Object)this, a);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void writeTypeAnnotation(Attribute.TypeCompound p) {
        try {
            Method m = ClassWriter.class.getDeclaredMethod("writeTypeAnnotation", Attribute.TypeCompound.class);
            m.setAccessible(true);
            m.invoke((Object)this, p);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

