/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.navigation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.navigation.PreViewConfigNavigateEvent;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.Page;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PageParameter;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.PageParameterContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.JsfUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewConfigAwareNavigationHandler
extends NavigationHandler {
    private Set<String> otherOutcomes = new CopyOnWriteArraySet<String>();
    private Map<String, ViewConfigDescriptor> viewConfigs = new ConcurrentHashMap<String, ViewConfigDescriptor>();
    private NavigationHandler navigationHandler;
    private boolean implicitNavigationSupported;
    private BeanManager beanManager;
    private PageParameterContext pageParameterContext;

    public ViewConfigAwareNavigationHandler(NavigationHandler navigationHandler, boolean implicitNavigationSupported) {
        this.navigationHandler = navigationHandler;
        this.implicitNavigationSupported = implicitNavigationSupported;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        this.initBeanManager();
        if (outcome != null && outcome.contains(".")) {
            String originalOutcome = outcome;
            if (!this.otherOutcomes.contains(outcome)) {
                ViewConfigDescriptor entry;
                if (outcome.startsWith("class ")) {
                    outcome = outcome.substring(6);
                }
                if ((entry = this.viewConfigs.get(outcome)) == null && DefaultErrorView.class.getName().equals(originalOutcome)) {
                    entry = ViewConfigCache.getDefaultErrorViewConfigDescriptor();
                }
                boolean allowCaching = true;
                if (entry == null) {
                    Class loadedClass = ClassUtils.tryToLoadClassForName((String)outcome);
                    if (loadedClass == null) {
                        this.otherOutcomes.add(originalOutcome);
                    } else if (ViewConfig.class.isAssignableFrom(loadedClass)) {
                        if (loadedClass.getAnnotation(Page.class) == null && loadedClass.getSuperclass().getAnnotation(Page.class) != null) {
                            allowCaching = false;
                            this.addConfiguredViewParameters(loadedClass);
                            loadedClass = loadedClass.getSuperclass();
                        }
                        entry = ViewConfigCache.getViewConfigDescriptor(loadedClass);
                    }
                }
                if (entry != null) {
                    PreViewConfigNavigateEvent navigateEvent;
                    if (allowCaching) {
                        this.viewConfigs.put(outcome, entry);
                        this.addConfiguredViewParameters(entry.getViewConfig());
                    }
                    String oldViewId = null;
                    if (facesContext.getViewRoot() != null) {
                        oldViewId = facesContext.getViewRoot().getViewId();
                    }
                    if ((entry = this.tryToUpdateEntry(entry, navigateEvent = this.firePreViewConfigNavigateEvent(oldViewId, entry))) != null && !this.implicitNavigationSupported) {
                        this.processViewDefinitionEntry(facesContext, entry);
                        this.navigationHandler.handleNavigation(facesContext, null, null);
                        return;
                    }
                    if (entry != null) {
                        outcome = this.convertEntryToOutcome(facesContext.getExternalContext(), entry);
                    }
                }
            }
        }
        this.navigationHandler.handleNavigation(facesContext, fromAction, outcome);
    }

    private void addConfiguredViewParameters(Class<?> viewConfigClass) {
        if (this.pageParameterContext != null) {
            PageParameter pageParameter = viewConfigClass.getAnnotation(PageParameter.class);
            if (pageParameter != null) {
                this.addConfiguredPageParameter(pageParameter);
            } else {
                PageParameter.List pageParameterList = viewConfigClass.getAnnotation(PageParameter.List.class);
                if (pageParameterList != null) {
                    for (PageParameter currentPageParameter : pageParameterList.value()) {
                        this.addConfiguredPageParameter(currentPageParameter);
                    }
                }
            }
        }
    }

    private void addConfiguredPageParameter(PageParameter viewParameter) {
        this.pageParameterContext.addPageParameter(viewParameter.key(), viewParameter.value());
    }

    private String convertEntryToOutcome(ExternalContext externalContext, ViewConfigDescriptor entry) {
        boolean performRedirect = Page.NavigationMode.REDIRECT.equals((Object)entry.getNavigationMode());
        boolean includeViewParameters = false;
        if (entry instanceof EditableViewConfigDescriptor) {
            includeViewParameters = Page.ViewParameterMode.INCLUDE.equals((Object)((EditableViewConfigDescriptor)entry).getViewParameterMode());
        }
        StringBuilder result = new StringBuilder(entry.getViewId());
        if (performRedirect) {
            result.append("?faces-redirect=true");
        }
        if (includeViewParameters) {
            if (performRedirect) {
                result.append("&");
            } else {
                result.append("?");
            }
            result.append("includeViewParams=true");
            return JsfUtils.addParameters(externalContext, result.toString(), true, true, false);
        }
        return JsfUtils.addParameters(externalContext, result.toString(), false, performRedirect, false);
    }

    private ViewConfigDescriptor tryToUpdateEntry(ViewConfigDescriptor viewConfigDescriptor, PreViewConfigNavigateEvent navigateEvent) {
        if (navigateEvent == null) {
            return viewConfigDescriptor;
        }
        if (navigateEvent.getToView() == null) {
            return null;
        }
        if (navigateEvent.getToView().equals(viewConfigDescriptor.getViewConfig())) {
            return viewConfigDescriptor;
        }
        return ViewConfigCache.getViewConfigDescriptor(navigateEvent.getToView());
    }

    private PreViewConfigNavigateEvent firePreViewConfigNavigateEvent(String oldViewId, ViewConfigDescriptor newViewConfigDescriptor) {
        ViewConfigDescriptor oldViewConfigDescriptor = ViewConfigCache.getViewConfigDescriptor(oldViewId);
        if (oldViewConfigDescriptor != null) {
            PreViewConfigNavigateEvent navigateEvent = new PreViewConfigNavigateEvent(oldViewConfigDescriptor.getViewConfig(), newViewConfigDescriptor.getViewConfig());
            this.beanManager.fireEvent((Object)navigateEvent, new Annotation[0]);
            return navigateEvent;
        }
        return null;
    }

    private void initBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
            this.pageParameterContext = (PageParameterContext)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, PageParameterContext.class, (boolean)true, (Annotation[])new Annotation[0]);
        }
    }

    private void processViewDefinitionEntry(FacesContext facesContext, ViewConfigDescriptor entry) {
        String targetViewId = entry.getViewId();
        Page.NavigationMode currentNavigationMode = entry.getNavigationMode();
        if (Page.NavigationMode.DEFAULT.equals((Object)currentNavigationMode)) {
            currentNavigationMode = Page.NavigationMode.FORWARD;
        }
        if (Page.NavigationMode.REDIRECT.equals((Object)currentNavigationMode)) {
            ExternalContext externalContext = facesContext.getExternalContext();
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            String redirectPath = viewHandler.getActionURL(facesContext, targetViewId);
            try {
                redirectPath = JsfUtils.addParameters(externalContext, redirectPath, false, true, true);
                externalContext.redirect(externalContext.encodeActionURL(redirectPath));
            }
            catch (IOException e) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
        } else {
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            UIViewRoot viewRoot = viewHandler.createView(facesContext, targetViewId);
            facesContext.setViewRoot(viewRoot);
            facesContext.renderResponse();
        }
    }
}

