/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlSelectManyMenu;
import jakarta.faces.component.html.HtmlSelectOneMenu;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlSelectableRendererBase;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlMenuRendererBase
extends HtmlSelectableRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        Map<String, List<ClientBehavior>> behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)component)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if (component instanceof UISelectMany) {
            this.renderMenu(facesContext, (UISelectMany)component, this.isDisabled(facesContext, component), this.getConverter(facesContext, component));
        } else if (component instanceof UISelectOne) {
            this.renderMenu(facesContext, (UISelectOne)component, this.isDisabled(facesContext, component), this.getConverter(facesContext, component));
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderMenu(FacesContext facesContext, UISelectOne selectOne, boolean disabled, Converter converter) throws IOException {
        this.internalRenderSelect(facesContext, selectOne, disabled, 1, false, converter);
    }

    protected void renderMenu(FacesContext facesContext, UISelectMany selectMany, boolean disabled, Converter converter) throws IOException {
        this.internalRenderSelect(facesContext, selectMany, disabled, 1, true, converter);
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectManyMenu) {
            return ((HtmlSelectManyMenu)uiComponent).isDisabled();
        }
        if (uiComponent instanceof HtmlSelectOneMenu) {
            return ((HtmlSelectOneMenu)uiComponent).isDisabled();
        }
        return AttributeUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, uiComponent);
        } else if (uiComponent instanceof UISelectOne) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
        if (uiComponent instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(uiComponent)) {
            ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)uiComponent, submittedValue);
        }
        if (uiComponent instanceof UISelectOne) {
            return RendererUtils.getConvertedUISelectOneValue(facesContext, (UISelectOne)uiComponent, submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
    }

    protected Converter getConverter(FacesContext facesContext, UIComponent component) {
        if (component instanceof UISelectMany) {
            return HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, (UISelectMany)component);
        }
        if (component instanceof UISelectOne) {
            return HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, component);
        }
        return null;
    }
}

