/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitContextFactory;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PreRemoveFromViewEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.StateManagementStrategy;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import jakarta.faces.view.ViewMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.application.StateManagerImpl;
import org.apache.myfaces.application.viewstate.StateCacheUtils;
import org.apache.myfaces.component.visit.MyFacesVisitHints;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.HashMapUtils;
import org.apache.myfaces.view.facelets.AttachedFullStateWrapper;
import org.apache.myfaces.view.facelets.ComponentState;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;
import org.apache.myfaces.view.facelets.compiler.CheckDuplicateIdFaceletUtils;
import org.apache.myfaces.view.facelets.pool.ViewEntry;
import org.apache.myfaces.view.facelets.pool.ViewPool;
import org.apache.myfaces.view.facelets.pool.ViewStructureMetadata;
import org.apache.myfaces.view.facelets.tag.faces.FaceletState;

public class PartialStateManagementStrategy
extends StateManagementStrategy {
    public static final String CLIENTIDS_ADDED = "oam.CLIENTIDS_ADDED";
    public static final String CLIENTIDS_REMOVED = "oam.CLIENTIDS_REMOVED";
    public static final String COMPONENT_ADDED_AFTER_BUILD_VIEW = "oam.COMPONENT_ADDED_AFTER_BUILD_VIEW";
    private static final Object[] EMPTY_STATES = new Object[]{null, null};
    private static final String UNIQUE_ID_COUNTER_KEY = "oam.view.uniqueIdCounter";
    private ViewDeclarationLanguageFactory _vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"jakarta.faces.view.ViewDeclarationLanguageFactory");
    private RenderKitFactory _renderKitFactory = null;
    private VisitContextFactory _visitContextFactory = null;
    private String checkIdsProductionMode;
    private ViewPoolProcessor _viewPoolProcessor;

    public PartialStateManagementStrategy() {
        this(FacesContext.getCurrentInstance());
    }

    public PartialStateManagementStrategy(FacesContext context) {
        this._viewPoolProcessor = ViewPoolProcessor.getInstance(context);
        this.checkIdsProductionMode = MyfacesConfig.getCurrentInstance(context).getCheckIdProductionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot view = null;
        ResponseStateManager manager = this.getRenderKitFactory().getRenderKit(context, renderKitId).getResponseStateManager();
        boolean oldContextEventState = context.isProcessingEvents();
        Object[] state = (Object[])manager.getState(context, viewId);
        if (state == null) {
            return null;
        }
        if (state[1] instanceof Object[]) {
            Object[] fullState = (Object[])state[1];
            view = (UIViewRoot)PartialStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)fullState[0]);
            if (view != null) {
                context.setViewRoot(view);
                view.processRestoreState(context, fullState[1]);
                RequestViewContext.getCurrentInstance(context).refreshRequestViewContext(context, view);
                if (fullState.length == 3 && fullState[2] != null) {
                    context.setResourceLibraryContracts((List)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)fullState[2]));
                }
            }
        } else {
            Map states;
            Object faceletViewState;
            block41: {
                ViewDeclarationLanguage vdl = this._vdlFactory.getViewDeclarationLanguage(viewId);
                faceletViewState = null;
                try {
                    ViewMetadata metadata = vdl.getViewMetadata(context, viewId);
                    if (metadata != null && (view = metadata.createMetadataView(context)) == null && context.getResponseComplete()) {
                        return null;
                    }
                    if (view == null) {
                        view = context.getApplication().getViewHandler().createView(context, viewId);
                    }
                    context.setViewRoot(view);
                    boolean skipBuildView = false;
                    if (state[1] != null) {
                        Object viewRootState;
                        ViewEntry entry;
                        ViewStructureMetadata viewMetadata;
                        ViewPool viewPool;
                        states = (Map)state[1];
                        faceletViewState = UIComponentBase.restoreAttachedState((FacesContext)context, states.get("oam.FACELET_STATE_INSTANCE"));
                        if (faceletViewState != null && this._viewPoolProcessor != null && (viewPool = this._viewPoolProcessor.getViewPool(context, view)) != null && (viewMetadata = viewPool.retrieveDynamicViewStructureMetadata(context, view, (FaceletState)faceletViewState)) != null && (entry = viewPool.popDynamicStructureView(context, view, (FaceletState)faceletViewState)) != null) {
                            skipBuildView = true;
                            this._viewPoolProcessor.cloneAndRestoreView(context, view, entry, viewMetadata);
                        }
                        if (view.getId() == null) {
                            view.setId(view.createUniqueId(context, null));
                        }
                        if (faceletViewState != null) {
                            FaceletState newFaceletState = (FaceletState)view.getAttributes().get("oam.FACELET_STATE_INSTANCE");
                            if (newFaceletState != null) {
                                newFaceletState.restoreState(context, ((FaceletState)faceletViewState).saveState(context));
                                faceletViewState = newFaceletState;
                            } else {
                                view.getAttributes().put("oam.FACELET_STATE_INSTANCE", faceletViewState);
                            }
                        }
                        if (state.length == 3) {
                            view.getAttributes().put(UNIQUE_ID_COUNTER_KEY, state[2]);
                        }
                        if ((viewRootState = states.get(view.getClientId(context))) != null) {
                            try {
                                view.pushComponentToEL(context, (UIComponent)view);
                                view.restoreViewScopeState(context, viewRootState);
                            }
                            finally {
                                view.popComponentFromEL(context);
                            }
                        }
                    }
                    if (skipBuildView) break block41;
                    try {
                        context.setProcessingEvents(true);
                        vdl.buildView(context, view);
                        this.suscribeListeners(view);
                    }
                    finally {
                        context.setProcessingEvents(oldContextEventState);
                    }
                }
                catch (Throwable e) {
                    throw new FacesException("unable to create view \"" + viewId + "\"", e);
                }
            }
            boolean statelessMode = manager.isStateless(context, viewId);
            if (statelessMode && !view.isTransient()) {
                throw new IllegalStateException("View is not transient");
            }
            if (!statelessMode && view.isTransient()) {
                throw new IllegalStateException("Cannot apply state over stateless view");
            }
            if (state[1] != null) {
                Integer newUniqueIdCounter;
                states = (Map)state[1];
                Integer lastUniqueIdCounter = (Integer)view.getAttributes().get(UNIQUE_ID_COUNTER_KEY);
                FaceletState oldFaceletState = (FaceletState)view.getAttributes().get("oam.FACELET_STATE_INSTANCE");
                boolean emptyState = false;
                boolean containsFaceletState = states.containsKey("oam.FACELET_STATE_INSTANCE");
                if (states.isEmpty()) {
                    emptyState = true;
                } else if (states.size() == 1 && containsFaceletState) {
                    emptyState = true;
                }
                if (!emptyState) {
                    if (states.size() == 1 && !containsFaceletState || states.size() == 2 && containsFaceletState) {
                        Object viewState = states.get(view.getClientId(context));
                        if (viewState != null) {
                            this.restoreViewRootOnlyFromMap(context, viewState, (UIComponent)view);
                        } else {
                            this.restoreStateFromMap(context, states, (UIComponent)view);
                        }
                    } else {
                        this.restoreStateFromMap(context, states, (UIComponent)view);
                    }
                }
                if (faceletViewState != null) {
                    if (oldFaceletState != null && oldFaceletState.getBindings() != null && !oldFaceletState.getBindings().isEmpty()) {
                        FaceletState newFaceletState = (FaceletState)faceletViewState;
                        for (Map.Entry<String, Map<String, ValueExpression>> entry : oldFaceletState.getBindings().entrySet()) {
                            for (Map.Entry<String, ValueExpression> entry2 : entry.getValue().entrySet()) {
                                ValueExpression expr = newFaceletState.getBinding(entry.getKey(), entry2.getKey());
                                if (expr != null) continue;
                                newFaceletState.putBinding(entry.getKey(), entry2.getKey(), entry2.getValue());
                            }
                        }
                        view.getAttributes().put("oam.FACELET_STATE_INSTANCE", newFaceletState);
                    } else {
                        view.getAttributes().put("oam.FACELET_STATE_INSTANCE", faceletViewState);
                    }
                }
                if (lastUniqueIdCounter != null && (newUniqueIdCounter = (Integer)view.getAttributes().get(UNIQUE_ID_COUNTER_KEY)) != null && lastUniqueIdCounter > newUniqueIdCounter) {
                    view.getAttributes().put(UNIQUE_ID_COUNTER_KEY, lastUniqueIdCounter);
                }
                this.handleDynamicAddedRemovedComponents(context, view, states);
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDynamicAddedRemovedComponents(FacesContext context, UIViewRoot view, Map<String, Object> states) {
        List<String> clientIdsAdded;
        List<String> clientIdsRemoved = PartialStateManagementStrategy.getClientIdsRemoved(view);
        if (clientIdsRemoved != null) {
            HashSet<String> idsRemovedSet = new HashSet<String>(HashMapUtils.calcCapacity(clientIdsRemoved.size()));
            context.getAttributes().put("org.apache.myfaces.REMOVING_COMPONENTS_BUILD", Boolean.TRUE);
            try {
                RemoveComponentCallback removeCallback = null;
                int size = clientIdsRemoved.size();
                for (int i = 0; i < size; ++i) {
                    String clientId = clientIdsRemoved.get(i);
                    if (idsRemovedSet.contains(clientId)) continue;
                    if (removeCallback == null) {
                        removeCallback = new RemoveComponentCallback();
                    }
                    removeCallback.setComponentFound(false);
                    view.invokeOnComponent(context, clientId, (ContextCallback)removeCallback);
                    if (!removeCallback.isComponentFound()) continue;
                    idsRemovedSet.add(clientId);
                }
                clientIdsRemoved.clear();
                clientIdsRemoved.addAll(idsRemovedSet);
            }
            finally {
                context.getAttributes().remove("org.apache.myfaces.REMOVING_COMPONENTS_BUILD");
            }
        }
        if ((clientIdsAdded = PartialStateManagementStrategy.getClientIdsAdded(view)) != null) {
            if (!clientIdsAdded.isEmpty()) {
                HashSet<String> idsAddedSet = new HashSet<String>(HashMapUtils.calcCapacity(clientIdsAdded.size()));
                AddComponentCallback addCallback = null;
                int size = clientIdsAdded.size();
                for (int i = 0; i < size; ++i) {
                    Object[] addedState;
                    String clientId = clientIdsAdded.get(i);
                    if (idsAddedSet.contains(clientId)) continue;
                    AttachedFullStateWrapper wrapper = (AttachedFullStateWrapper)states.get(clientId);
                    if (wrapper != null && (addedState = (Object[])wrapper.getWrappedStateObject()) != null) {
                        if (addedState.length == 2) {
                            view = (UIViewRoot)PartialStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)addedState[0]);
                            view.processRestoreState(context, addedState[1]);
                            break;
                        }
                        if (addCallback == null) {
                            addCallback = new AddComponentCallback();
                        }
                        addCallback.setAddedState(addedState);
                        String parentClientId = (String)addedState[0];
                        view.invokeOnComponent(context, parentClientId, (ContextCallback)addCallback);
                    }
                    idsAddedSet.add(clientId);
                }
            }
            clientIdsAdded.clear();
            RequestViewContext.getCurrentInstance(context).refreshRequestViewContext(context, view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        if (view == null) {
            return null;
        }
        ResponseStateManager responseStateManager = context.getRenderKit().getResponseStateManager();
        Object serializedView = context.getAttributes().get(StateManagerImpl.SERIALIZED_VIEW_REQUEST_ATTR);
        if (serializedView == null) {
            try {
                Object[] states;
                context.getAttributes().put("jakarta.faces.IS_SAVING_STATE", Boolean.TRUE);
                if (context.isProjectStage(ProjectStage.Production)) {
                    if ("auto".equals(this.checkIdsProductionMode)) {
                        CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, (UIComponent)view);
                    } else if ("true".equals(this.checkIdsProductionMode)) {
                        CheckDuplicateIdFaceletUtils.checkIds(context, (UIComponent)view);
                    }
                } else {
                    CheckDuplicateIdFaceletUtils.checkIds(context, (UIComponent)view);
                }
                boolean viewResetable = false;
                int count = 0;
                Object faceletViewState = null;
                boolean saveViewFully = view.getAttributes().containsKey(COMPONENT_ADDED_AFTER_BUILD_VIEW);
                if (saveViewFully) {
                    this.ensureClearInitialState((UIComponent)view);
                    Object rlcStates = !context.getResourceLibraryContracts().isEmpty() ? UIComponentBase.saveAttachedState((FacesContext)context, new ArrayList(context.getResourceLibraryContracts())) : null;
                    states = new Object[]{PartialStateManagementStrategy.internalBuildTreeStructureToSave((UIComponent)view), view.processSaveState(context), rlcStates};
                } else {
                    states = new HashMap();
                    faceletViewState = view.getAttributes().get("oam.FACELET_STATE_INSTANCE");
                    if (faceletViewState != null) {
                        ((Map)states).put("oam.FACELET_STATE_INSTANCE", UIComponentBase.saveAttachedState((FacesContext)context, faceletViewState));
                        view.getAttributes().remove("oam.FACELET_STATE_INSTANCE");
                        view.getTransientStateHelper().putTransient((Object)"oam.FACELET_STATE_INSTANCE", faceletViewState);
                    }
                    if (this._viewPoolProcessor != null && this._viewPoolProcessor.isViewPoolEnabledForThisView(context, view)) {
                        SaveStateAndResetViewCallback cb = this.saveStateOnMapVisitTreeAndReset(context, (Map)states, view, Boolean.TRUE.equals(context.getAttributes().get("oam.ViewPool.forceHardReset")));
                        viewResetable = cb.isViewResetable();
                        count = cb.getCount();
                    } else {
                        this.saveStateOnMapVisitTree(context, (Map)states, view);
                    }
                    if (((Map)states).isEmpty()) {
                        states = null;
                    }
                }
                Integer uniqueIdCount = (Integer)view.getAttributes().get(UNIQUE_ID_COUNTER_KEY);
                serializedView = uniqueIdCount != null && !uniqueIdCount.equals(1) ? new Object[]{null, states, uniqueIdCount} : (states == null ? EMPTY_STATES : new Object[]{null, states});
                if (!saveViewFully && this._viewPoolProcessor != null) {
                    if (viewResetable) {
                        this._viewPoolProcessor.pushResetableView(context, view, faceletViewState);
                    } else {
                        this._viewPoolProcessor.pushPartialView(context, view, faceletViewState, count);
                    }
                }
                context.getAttributes().put(StateManagerImpl.SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
                if (StateCacheUtils.isMyFacesResponseStateManager(responseStateManager)) {
                    StateCacheUtils.getMyFacesResponseStateManager(responseStateManager).saveState(context, serializedView);
                }
            }
            finally {
                context.getAttributes().remove("jakarta.faces.IS_SAVING_STATE");
            }
        }
        return serializedView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreViewRootOnlyFromMap(FacesContext context, Object viewState, UIComponent view) {
        block5: {
            try {
                view.pushComponentToEL(context, view);
                if (viewState == null || viewState instanceof AttachedFullStateWrapper) break block5;
                try {
                    view.restoreState(context, viewState);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error restoring component: " + view.getClientId(context), e);
                }
            }
            finally {
                view.popComponentFromEL(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreStateFromMap(FacesContext context, Map<String, Object> states, UIComponent component) {
        if (states == null) {
            return;
        }
        try {
            component.pushComponentToEL(context, component);
            Object state = states.get(component.getClientId(context));
            if (state != null) {
                if (state instanceof AttachedFullStateWrapper) {
                    return;
                }
                try {
                    component.restoreState(context, state);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error restoring component: " + component.getClientId(context), e);
                }
            }
            if (component.getChildCount() > 0) {
                List children = component.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    UIComponent child = (UIComponent)children.get(i);
                    if (child == null || child.isTransient()) continue;
                    this.restoreStateFromMap(context, states, child);
                }
            }
            if (component.getFacetCount() > 0) {
                Map facetMap = component.getFacets();
                for (Map.Entry entry : facetMap.entrySet()) {
                    UIComponent child = (UIComponent)entry.getValue();
                    if (child == null || child.isTransient()) continue;
                    this.restoreStateFromMap(context, states, child);
                }
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    static List<String> getClientIdsAdded(UIViewRoot root) {
        return (List)root.getAttributes().get(CLIENTIDS_ADDED);
    }

    static void setClientsIdsAdded(UIViewRoot root, List<String> clientIdsList) {
        root.getAttributes().put(CLIENTIDS_ADDED, clientIdsList);
    }

    static List<String> getClientIdsRemoved(UIViewRoot root) {
        return (List)root.getAttributes().get(CLIENTIDS_REMOVED);
    }

    static void setClientsIdsRemoved(UIViewRoot root, List<String> clientIdsList) {
        root.getAttributes().put(CLIENTIDS_REMOVED, clientIdsList);
    }

    private void registerOnAddRemoveList(FacesContext facesContext, String clientId) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        List<String> clientIdsAdded = PartialStateManagementStrategy.getClientIdsAdded(uiViewRoot);
        if (clientIdsAdded == null) {
            clientIdsAdded = new ArrayList<String>();
        }
        clientIdsAdded.add(clientId);
        PartialStateManagementStrategy.setClientsIdsAdded(uiViewRoot, clientIdsAdded);
        List<String> clientIdsRemoved = PartialStateManagementStrategy.getClientIdsRemoved(uiViewRoot);
        if (clientIdsRemoved == null) {
            clientIdsRemoved = new ArrayList<String>();
        }
        clientIdsRemoved.add(clientId);
        PartialStateManagementStrategy.setClientsIdsRemoved(uiViewRoot, clientIdsRemoved);
    }

    private void registerOnAddList(FacesContext facesContext, String clientId) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        List<String> clientIdsAdded = PartialStateManagementStrategy.getClientIdsAdded(uiViewRoot);
        if (clientIdsAdded == null) {
            clientIdsAdded = new ArrayList<String>();
        }
        clientIdsAdded.add(clientId);
        PartialStateManagementStrategy.setClientsIdsAdded(uiViewRoot, clientIdsAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStateOnMapVisitTree(FacesContext facesContext, final Map<String, Object> states, UIViewRoot uiViewRoot) {
        Object state;
        facesContext.getAttributes().put("jakarta.faces.visit.SKIP_ITERATION", Boolean.TRUE);
        try {
            uiViewRoot.visitTree(this.getVisitContextFactory().getVisitContext(facesContext, null, MyFacesVisitHints.SET_SKIP_ITERATION), new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    FacesContext facesContext = context.getFacesContext();
                    if (target == null || target.isTransient()) {
                        return VisitResult.REJECT;
                    }
                    ComponentState componentAddedAfterBuildView = (ComponentState)((Object)target.getAttributes().get(PartialStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW));
                    if (componentAddedAfterBuildView != null && target.getParent() != null) {
                        if (ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                            PartialStateManagementStrategy.this.registerOnAddRemoveList(facesContext, target.getClientId(facesContext));
                            target.getAttributes().put(PartialStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                        } else if (ComponentState.ADD.equals((Object)componentAddedAfterBuildView)) {
                            PartialStateManagementStrategy.this.registerOnAddList(facesContext, target.getClientId(facesContext));
                            target.getAttributes().put(PartialStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                        } else if (ComponentState.ADDED.equals((Object)componentAddedAfterBuildView)) {
                            PartialStateManagementStrategy.this.registerOnAddList(facesContext, target.getClientId(facesContext));
                        }
                        PartialStateManagementStrategy.this.ensureClearInitialState(target);
                        int childIndex = target.getParent().getChildren().indexOf(target);
                        if (childIndex >= 0) {
                            states.put(target.getClientId(facesContext), new AttachedFullStateWrapper(new Object[]{target.getParent().getClientId(facesContext), null, childIndex, PartialStateManagementStrategy.internalBuildTreeStructureToSave(target), target.processSaveState(facesContext)}));
                        } else {
                            String facetName = null;
                            if (target.getParent().getFacetCount() > 0) {
                                for (Map.Entry entry : target.getParent().getFacets().entrySet()) {
                                    if (!target.equals(entry.getValue())) continue;
                                    facetName = (String)entry.getKey();
                                    break;
                                }
                            }
                            states.put(target.getClientId(facesContext), new AttachedFullStateWrapper(new Object[]{target.getParent().getClientId(facesContext), facetName, null, PartialStateManagementStrategy.internalBuildTreeStructureToSave(target), target.processSaveState(facesContext)}));
                        }
                        return VisitResult.REJECT;
                    }
                    if (target.getParent() != null) {
                        Object state = target.saveState(facesContext);
                        if (state != null) {
                            states.put(target.getClientId(facesContext), state);
                        }
                        return VisitResult.ACCEPT;
                    }
                    return VisitResult.ACCEPT;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove("jakarta.faces.visit.SKIP_ITERATION");
        }
        if (!uiViewRoot.isTransient() && (state = uiViewRoot.saveState(facesContext)) != null) {
            states.put(uiViewRoot.getClientId(facesContext), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaveStateAndResetViewCallback saveStateOnMapVisitTreeAndReset(FacesContext facesContext, Map<String, Object> states, UIViewRoot uiViewRoot, boolean forceHardReset) {
        facesContext.getAttributes().put("jakarta.faces.visit.SKIP_ITERATION", Boolean.TRUE);
        SaveStateAndResetViewCallback callback = new SaveStateAndResetViewCallback(facesContext.getViewRoot(), states, forceHardReset);
        if (forceHardReset) {
            uiViewRoot.getAttributes().put("oam.view.resetSaveStateMode", ViewPoolProcessor.RESET_MODE_HARD);
        } else {
            uiViewRoot.getAttributes().put("oam.view.resetSaveStateMode", ViewPoolProcessor.RESET_MODE_SOFT);
        }
        try {
            Object state;
            List<String> clientIdsToRemove;
            List<String> removedIds;
            if (this._viewPoolProcessor != null && !this._viewPoolProcessor.isViewPoolEnabledForThisView(facesContext, uiViewRoot)) {
                callback.setViewResetable(false);
            }
            if (callback.isViewResetable() && (removedIds = PartialStateManagementStrategy.getClientIdsRemoved(uiViewRoot)) != null && !removedIds.isEmpty()) {
                callback.setViewResetable(false);
            }
            try {
                uiViewRoot.visitTree(this.getVisitContextFactory().getVisitContext(facesContext, null, MyFacesVisitHints.SET_SKIP_ITERATION), (VisitCallback)callback);
            }
            finally {
                facesContext.getAttributes().remove("jakarta.faces.visit.SKIP_ITERATION");
            }
            if (callback.isViewResetable() && callback.isRemoveAddedComponents() && (clientIdsToRemove = PartialStateManagementStrategy.getClientIdsAdded(uiViewRoot)) != null) {
                RemoveComponentCallback removeCallback = null;
                int size = clientIdsToRemove.size();
                for (int i = 0; i < size; ++i) {
                    if (removeCallback == null) {
                        removeCallback = new RemoveComponentCallback();
                    }
                    removeCallback.setComponentFound(false);
                    String clientId = clientIdsToRemove.get(i);
                    uiViewRoot.invokeOnComponent(facesContext, clientId, (ContextCallback)removeCallback);
                }
            }
            if ((state = uiViewRoot.saveState(facesContext)) != null) {
                states.put(uiViewRoot.getClientId(facesContext), state);
                Integer oldResetMode = uiViewRoot.getAttributes().put("oam.view.resetSaveStateMode", ViewPoolProcessor.RESET_MODE_HARD);
                state = uiViewRoot.saveState(facesContext);
                uiViewRoot.getAttributes().put("oam.view.resetSaveStateMode", oldResetMode);
                if (state != null) {
                    callback.setViewResetable(false);
                }
            }
        }
        finally {
            uiViewRoot.getAttributes().put("oam.view.resetSaveStateMode", ViewPoolProcessor.RESET_MODE_OFF);
        }
        return callback;
    }

    protected void ensureClearInitialState(UIComponent c) {
        c.clearInitialState();
        if (c.getChildCount() > 0) {
            int childCount = c.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)c.getChildren().get(i);
                this.ensureClearInitialState(child);
            }
        }
        if (c.getFacetCount() > 0) {
            for (UIComponent child : c.getFacets().values()) {
                this.ensureClearInitialState(child);
            }
        }
    }

    public void suscribeListeners(UIViewRoot uiViewRoot) {
        boolean listenerSubscribed = false;
        List pavList = uiViewRoot.getViewListenersForEventClass(PostAddToViewEvent.class);
        if (pavList != null) {
            for (SystemEventListener listener : pavList) {
                if (!(listener instanceof PostAddPreRemoveFromViewListener)) continue;
                listenerSubscribed = true;
                break;
            }
        }
        if (!listenerSubscribed) {
            PostAddPreRemoveFromViewListener componentListener = new PostAddPreRemoveFromViewListener();
            uiViewRoot.subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)componentListener);
            uiViewRoot.subscribeToViewEvent(PreRemoveFromViewEvent.class, (SystemEventListener)componentListener);
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected VisitContextFactory getVisitContextFactory() {
        if (this._visitContextFactory == null) {
            this._visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.component.visit.VisitContextFactory");
        }
        return this._visitContextFactory;
    }

    private static TreeStructComponent internalBuildTreeStructureToSave(UIComponent component) {
        TreeStructComponent structComp = new TreeStructComponent(component.getClass().getName(), component.getId());
        if (component.getChildCount() > 0) {
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                if (child.isTransient()) continue;
                TreeStructComponent structChild = PartialStateManagementStrategy.internalBuildTreeStructureToSave(child);
                structChildList.add(structChild);
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (component.getFacetCount() > 0) {
            Map facetMap = component.getFacets();
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            for (Map.Entry entry : facetMap.entrySet()) {
                UIComponent child = (UIComponent)entry.getValue();
                if (child.isTransient()) continue;
                String facetName = (String)entry.getKey();
                TreeStructComponent structChild = PartialStateManagementStrategy.internalBuildTreeStructureToSave(child);
                structFacetList.add(new Object[]{facetName, structChild});
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    private static UIComponent internalRestoreTreeStructure(TreeStructComponent treeStructComp) {
        Object[] facetArray;
        String compClass = treeStructComp.getComponentClass();
        String compId = treeStructComp.getComponentId();
        UIComponent component = (UIComponent)ClassUtils.newInstance((String)compClass);
        component.setId(compId);
        TreeStructComponent[] childArray = treeStructComp.getChildren();
        if (childArray != null) {
            List childList = component.getChildren();
            int len = childArray.length;
            for (int i = 0; i < len; ++i) {
                UIComponent child = PartialStateManagementStrategy.internalRestoreTreeStructure(childArray[i]);
                childList.add(child);
            }
        }
        if ((facetArray = treeStructComp.getFacets()) != null) {
            Map facetMap = component.getFacets();
            int len = facetArray.length;
            for (int i = 0; i < len; ++i) {
                Object[] tuple = (Object[])facetArray[i];
                String facetName = (String)tuple[0];
                TreeStructComponent structChild = (TreeStructComponent)tuple[1];
                UIComponent child = PartialStateManagementStrategy.internalRestoreTreeStructure(structChild);
                facetMap.put(facetName, child);
            }
        }
        return component;
    }

    public static class TreeStructComponent
    implements Serializable {
        private static final long serialVersionUID = 5069109074684737231L;
        private String _componentClass;
        private String _componentId;
        private TreeStructComponent[] _children = null;
        private Object[] _facets = null;

        TreeStructComponent(String componentClass, String componentId) {
            this._componentClass = componentClass;
            this._componentId = componentId;
        }

        public String getComponentClass() {
            return this._componentClass;
        }

        public String getComponentId() {
            return this._componentId;
        }

        void setChildren(TreeStructComponent[] children) {
            this._children = children;
        }

        TreeStructComponent[] getChildren() {
            return this._children;
        }

        Object[] getFacets() {
            return this._facets;
        }

        void setFacets(Object[] facets) {
            this._facets = facets;
        }
    }

    public static class PostAddPreRemoveFromViewListener
    implements SystemEventListener {
        private transient FacesContext _facesContext;
        private transient Boolean _isRefreshOnTransientBuildPreserveState;

        public boolean isListenerForSource(Object source) {
            return source instanceof UIComponent;
        }

        private boolean isRefreshOnTransientBuildPreserveState() {
            if (this._isRefreshOnTransientBuildPreserveState == null) {
                this._isRefreshOnTransientBuildPreserveState = MyfacesConfig.getCurrentInstance(this._facesContext).isRefreshTransientBuildOnPSSPreserveState();
            }
            return this._isRefreshOnTransientBuildPreserveState;
        }

        public void processEvent(SystemEvent event) {
            UIComponent component = (UIComponent)event.getSource();
            if (component.isTransient()) {
                return;
            }
            if (this._facesContext == null) {
                this._facesContext = FacesContext.getCurrentInstance();
            }
            if (event instanceof PostAddToViewEvent) {
                if (!this.isRefreshOnTransientBuildPreserveState() && Boolean.TRUE.equals(this._facesContext.getAttributes().get("jakarta.faces.IS_BUILDING_INITIAL_STATE"))) {
                    return;
                }
                component.getAttributes().put(PartialStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADD);
            } else {
                if (FaceletViewDeclarationLanguage.isRemovingComponentBuild(this._facesContext)) {
                    return;
                }
                if (!this.isRefreshOnTransientBuildPreserveState() && FaceletCompositionContext.getCurrentInstance(this._facesContext) != null && (component.getAttributes().containsKey("oam.vf.MARK_ID") || component.getAttributes().containsKey("oam.vf.addedByHandler"))) {
                    return;
                }
                UIViewRoot uiViewRoot = this._facesContext.getViewRoot();
                List<String> clientIdsRemoved = PartialStateManagementStrategy.getClientIdsRemoved(uiViewRoot);
                if (clientIdsRemoved == null) {
                    clientIdsRemoved = new ArrayList<String>();
                }
                clientIdsRemoved.add(component.getClientId(this._facesContext));
                PartialStateManagementStrategy.setClientsIdsRemoved(uiViewRoot, clientIdsRemoved);
            }
        }
    }

    private class SaveStateAndResetViewCallback
    implements VisitCallback {
        private final Map<String, Object> states;
        private final UIViewRoot view;
        private boolean viewResetable;
        private boolean skipRoot;
        private int count;
        private boolean forceHardReset;
        private boolean removeAddedComponents;

        public SaveStateAndResetViewCallback(UIViewRoot view, Map<String, Object> states, boolean forceHardReset) {
            this.states = states;
            this.view = view;
            this.viewResetable = true;
            this.skipRoot = true;
            this.count = 0;
            this.forceHardReset = forceHardReset;
            this.removeAddedComponents = false;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            FacesContext facesContext = context.getFacesContext();
            ++this.count;
            if (target == null || target.isTransient()) {
                return VisitResult.REJECT;
            }
            if (this.skipRoot && target instanceof UIViewRoot) {
                this.skipRoot = false;
                return VisitResult.ACCEPT;
            }
            ComponentState componentAddedAfterBuildView = (ComponentState)((Object)target.getAttributes().get(PartialStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW));
            if (componentAddedAfterBuildView != null && target.getParent() != null) {
                this.setRemoveAddedComponents(true);
                if (this.forceHardReset) {
                    if (this.isViewResetable() && ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                        this.setViewResetable(false);
                    }
                    return VisitResult.REJECT;
                }
                if (ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                    this.setViewResetable(false);
                    PartialStateManagementStrategy.this.registerOnAddRemoveList(facesContext, target.getClientId(facesContext));
                    target.getAttributes().put(PartialStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                } else if (ComponentState.ADD.equals((Object)componentAddedAfterBuildView)) {
                    PartialStateManagementStrategy.this.registerOnAddList(facesContext, target.getClientId(facesContext));
                    target.getAttributes().put(PartialStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, ComponentState.ADDED);
                } else if (ComponentState.ADDED.equals((Object)componentAddedAfterBuildView)) {
                    PartialStateManagementStrategy.this.registerOnAddList(facesContext, target.getClientId(facesContext));
                }
                PartialStateManagementStrategy.this.ensureClearInitialState(target);
                int childIndex = target.getParent().getChildren().indexOf(target);
                if (childIndex >= 0) {
                    this.states.put(target.getClientId(facesContext), new AttachedFullStateWrapper(new Object[]{target.getParent().getClientId(facesContext), null, childIndex, PartialStateManagementStrategy.internalBuildTreeStructureToSave(target), target.processSaveState(facesContext)}));
                } else {
                    String facetName = null;
                    if (target.getParent().getFacetCount() > 0) {
                        for (Map.Entry entry : target.getParent().getFacets().entrySet()) {
                            if (!target.equals(entry.getValue())) continue;
                            facetName = (String)entry.getKey();
                            break;
                        }
                    }
                    this.states.put(target.getClientId(facesContext), new AttachedFullStateWrapper(new Object[]{target.getParent().getClientId(facesContext), facetName, null, PartialStateManagementStrategy.internalBuildTreeStructureToSave(target), target.processSaveState(facesContext)}));
                }
                return VisitResult.REJECT;
            }
            if (target.getParent() != null) {
                if (this.forceHardReset) {
                    Object state = target.saveState(facesContext);
                    if (state != null) {
                        this.setViewResetable(false);
                        return VisitResult.REJECT;
                    }
                } else {
                    Object state = target.saveState(facesContext);
                    if (state != null) {
                        this.states.put(target.getClientId(facesContext), state);
                        if (this.isViewResetable()) {
                            Integer oldResetMode = this.view.getAttributes().put("oam.view.resetSaveStateMode", ViewPoolProcessor.RESET_MODE_HARD);
                            state = target.saveState(facesContext);
                            this.view.getAttributes().put("oam.view.resetSaveStateMode", oldResetMode);
                            if (state != null) {
                                this.setViewResetable(false);
                            }
                        }
                    }
                }
                return VisitResult.ACCEPT;
            }
            return VisitResult.ACCEPT;
        }

        public boolean isViewResetable() {
            return this.viewResetable;
        }

        public void setViewResetable(boolean viewResetable) {
            this.viewResetable = viewResetable;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isRemoveAddedComponents() {
            return this.removeAddedComponents;
        }

        public void setRemoveAddedComponents(boolean removeAddedComponents) {
            this.removeAddedComponents = removeAddedComponents;
        }
    }

    public static class AddComponentCallback
    implements ContextCallback {
        private Object[] addedState;

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (this.addedState[1] != null) {
                String facetName = (String)this.addedState[1];
                UIComponent child = PartialStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)this.addedState[3]);
                child.processRestoreState(context, this.addedState[4]);
                target.getFacets().put(facetName, child);
            } else {
                UIComponent parent;
                Integer childIndex = (Integer)this.addedState[2];
                UIComponent child = PartialStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)this.addedState[3]);
                child.processRestoreState(context, this.addedState[4]);
                boolean done = false;
                if (child.getAttributes().containsKey("oam.vf.MARK_ID") && (parent = target).getChildCount() > 0) {
                    UIComponent dup;
                    String tagId = (String)child.getAttributes().get("oam.vf.MARK_ID");
                    if (childIndex < parent.getChildCount() && tagId.equals((dup = (UIComponent)parent.getChildren().get(childIndex)).getAttributes().get("oam.vf.MARK_ID"))) {
                        parent.getChildren().remove(childIndex);
                        parent.getChildren().add(childIndex, child);
                        done = true;
                    }
                    if (!done) {
                        int childCount = parent.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            UIComponent dup2 = (UIComponent)parent.getChildren().get(i);
                            if (!tagId.equals(dup2.getAttributes().get("oam.vf.MARK_ID"))) continue;
                            parent.getChildren().remove(i);
                            parent.getChildren().add(i, child);
                            done = true;
                            break;
                        }
                    }
                }
                if (!done) {
                    try {
                        target.getChildren().add(childIndex, child);
                    }
                    catch (IndexOutOfBoundsException e) {
                        target.getChildren().add(child);
                    }
                }
            }
        }

        public Object[] getAddedState() {
            return this.addedState;
        }

        public void setAddedState(Object[] addedState) {
            this.addedState = addedState;
        }
    }

    public static class RemoveComponentCallback
    implements ContextCallback {
        private boolean componentFound = false;

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (target.getParent() != null && !target.getParent().getChildren().remove(target)) {
                UIComponent removedTarget;
                String key = null;
                if (target.getParent().getFacetCount() > 0) {
                    for (Map.Entry entry : target.getParent().getFacets().entrySet()) {
                        if (entry.getValue() != target) continue;
                        key = (String)entry.getKey();
                        break;
                    }
                }
                if (key != null && (removedTarget = (UIComponent)target.getParent().getFacets().remove(key)) != null) {
                    this.componentFound = true;
                }
            } else {
                this.componentFound = true;
            }
        }

        public boolean isComponentFound() {
            return this.componentFound;
        }

        public void setComponentFound(boolean componentFound) {
            this.componentFound = componentFound;
        }
    }
}

