/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.clientwindow;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Typed;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import java.io.Serializable;
import java.util.Map;
import org.apache.myfaces.cdi.util.AbstractContextualStorageHolder;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.util.lang.LRULinkedHashMap;

@Typed(value={ClientWindowScopeContextualStorageHolder.class})
@SessionScoped
public class ClientWindowScopeContextualStorageHolder
extends AbstractContextualStorageHolder<ContextualStorage>
implements Serializable {
    private LRULinkedHashMap<String, String> clientWindowExpirationStack;

    @Override
    @PostConstruct
    public void init() {
        super.init();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Integer numberOfClientWindowsInSession = MyfacesConfig.getCurrentInstance(facesContext).getNumberOfClientWindows();
        this.clientWindowExpirationStack = new LRULinkedHashMap((int)numberOfClientWindowsInSession, eldest -> this.destroyAll(FacesContext.getCurrentInstance(), (String)eldest.getKey()));
        this.pushClientWindow(facesContext, facesContext.getExternalContext().getClientWindow());
    }

    @Override
    public void destroyAll(ContextualStorage contextualStorage, FacesContext facesContext) {
        if (contextualStorage == null) {
            return;
        }
        Map<Object, ContextualInstanceInfo<?>> contextMap = contextualStorage.getStorage();
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
            Contextual<?> bean = contextualStorage.getBean(entry.getKey());
            ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
            bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        }
    }

    @Override
    protected ContextualStorage newContextualStorage(String slotId) {
        return new ContextualStorage(this.beanManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushClientWindow(FacesContext facesContext, ClientWindow clientWindow) {
        if (clientWindow != null && clientWindow.getId() != null) {
            LRULinkedHashMap<String, String> lRULinkedHashMap = this.clientWindowExpirationStack;
            synchronized (lRULinkedHashMap) {
                this.clientWindowExpirationStack.remove(clientWindow.getId());
                this.clientWindowExpirationStack.put(clientWindow.getId(), "");
            }
        }
    }

    public static ClientWindowScopeContextualStorageHolder getInstance(FacesContext facesContext) {
        return ClientWindowScopeContextualStorageHolder.getInstance(facesContext, false);
    }

    public static ClientWindowScopeContextualStorageHolder getInstance(FacesContext facesContext, boolean create) {
        return ClientWindowScopeContextualStorageHolder.getInstance(facesContext, ClientWindowScopeContextualStorageHolder.class, create);
    }
}

