/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.myfaces.config.annotation.DefaultLifecycleProviderFactory;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class LifecycleProviderFactory {
    protected static final String FACTORY_DEFAULT = DefaultLifecycleProviderFactory.class.getName();
    private static final String FACTORY_KEY = LifecycleProviderFactory.class.getName();

    public static LifecycleProviderFactory getLifecycleProviderFactory() {
        return LifecycleProviderFactory.getLifecycleProviderFactory(FacesContext.getCurrentInstance().getExternalContext());
    }

    public static LifecycleProviderFactory getLifecycleProviderFactory(ExternalContext ctx) {
        Map<String, Object> applicationMap = ctx.getApplicationMap();
        LifecycleProviderFactory instance = (LifecycleProviderFactory)applicationMap.get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        LifecycleProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (LifecycleProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, LifecycleProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (LifecycleProviderFactory)SpiUtils.build(ctx, LifecycleProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException(pae);
        }
        if (lpf != null) {
            applicationMap.put(FACTORY_KEY, lpf);
        }
        return lpf;
    }

    public static void setLifecycleProviderFactory(LifecycleProviderFactory instance) {
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract LifecycleProvider getLifecycleProvider(ExternalContext var1);

    public abstract void release();
}

