/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.webapp.ValidatorELTag;
import jakarta.servlet.jsp.JspException;
import org.apache.myfaces.taglib.core.DelegateValidator;

public class ValidatorImplTag
extends ValidatorELTag {
    private ValueExpression _validatorId;
    private ValueExpression _binding;
    private String _validatorIdString = null;

    public void setValidatorId(ValueExpression validatorId) {
        this._validatorId = validatorId;
    }

    public void setBinding(ValueExpression binding) {
        this._binding = binding;
    }

    public void setValidatorIdString(String validatorIdString) {
        this._validatorIdString = validatorIdString;
    }

    public void release() {
        super.release();
        this._validatorId = null;
        this._binding = null;
        this._validatorIdString = null;
    }

    protected Validator createValidator() throws JspException {
        if (this._validatorIdString != null) {
            return this.createClassicValidator();
        }
        if (this._validatorId != null && this._validatorId.isLiteralText()) {
            return this.createClassicValidator();
        }
        return new DelegateValidator(this._validatorId, this._binding, this._validatorIdString);
    }

    protected Validator createClassicValidator() throws JspException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        if (null != this._binding) {
            Object validator;
            try {
                validator = this._binding.getValue(elContext);
            }
            catch (Exception e) {
                throw new JspException("Error while creating the Validator", (Throwable)e);
            }
            if (validator instanceof Validator) {
                return (Validator)validator;
            }
        }
        Application application = facesContext.getApplication();
        Validator validator = null;
        try {
            if (null != this._validatorIdString) {
                validator = application.createValidator(this._validatorIdString);
            } else if (null != this._validatorId) {
                String validatorId = (String)this._validatorId.getValue(elContext);
                validator = application.createValidator(validatorId);
            }
        }
        catch (Exception e) {
            throw new JspException("Error while creating the Validator", (Throwable)e);
        }
        if (null != validator) {
            if (null != this._binding) {
                this._binding.setValue(elContext, (Object)validator);
            }
            return validator;
        }
        throw new JspException("validatorId and/or binding must be specified");
    }
}

