/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.NumberConverter;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.util.Locale;
import org.apache.myfaces.shared.taglib.UIComponentELTagUtils;
import org.apache.myfaces.shared.util.LocaleUtils;
import org.apache.myfaces.taglib.core.ConverterTag;

public class ConvertNumberTag
extends ConverterTag {
    private static final long serialVersionUID = -8365745569697171573L;
    private ValueExpression _currencyCode = null;
    private ValueExpression _currencySymbol = null;
    private ValueExpression _groupingUsed = null;
    private ValueExpression _integerOnly = null;
    private ValueExpression _locale = null;
    private ValueExpression _maxFractionDigits = null;
    private ValueExpression _maxIntegerDigits = null;
    private ValueExpression _minFractionDigits = null;
    private ValueExpression _minIntegerDigits = null;
    private ValueExpression _pattern = null;
    private ValueExpression _type = null;

    public ConvertNumberTag() {
        this.setConverterIdString("jakarta.faces.Number");
    }

    public void setCurrencyCode(ValueExpression currencyCode) {
        this._currencyCode = currencyCode;
    }

    public void setCurrencySymbol(ValueExpression currencySymbol) {
        this._currencySymbol = currencySymbol;
    }

    public void setGroupingUsed(ValueExpression groupingUsed) {
        this._groupingUsed = groupingUsed;
    }

    public void setIntegerOnly(ValueExpression integerOnly) {
        this._integerOnly = integerOnly;
    }

    public void setLocale(ValueExpression locale) {
        this._locale = locale;
    }

    public void setMaxFractionDigits(ValueExpression maxFractionDigits) {
        this._maxFractionDigits = maxFractionDigits;
    }

    public void setMaxIntegerDigits(ValueExpression maxIntegerDigits) {
        this._maxIntegerDigits = maxIntegerDigits;
    }

    public void setMinFractionDigits(ValueExpression minFractionDigits) {
        this._minFractionDigits = minFractionDigits;
    }

    public void setMinIntegerDigits(ValueExpression minIntegerDigits) {
        this._minIntegerDigits = minIntegerDigits;
    }

    public void setPattern(ValueExpression pattern) {
        this._pattern = pattern;
    }

    public void setType(ValueExpression type) {
        this._type = type;
    }

    public void setPageContext(PageContext context) {
        super.setPageContext(context);
        this.setConverterIdString("jakarta.faces.Number");
    }

    @Override
    protected Converter createConverter() throws JspException {
        NumberConverter converter = (NumberConverter)super.createConverter();
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        if (null != this._currencyCode) {
            converter.setCurrencyCode((String)UIComponentELTagUtils.evaluateValueExpression(elContext, this._currencyCode));
        }
        if (null != this._currencySymbol) {
            converter.setCurrencySymbol((String)UIComponentELTagUtils.evaluateValueExpression(elContext, this._currencySymbol));
        }
        if (null != this._groupingUsed) {
            converter.setGroupingUsed(UIComponentELTagUtils.getBooleanValue(elContext, this._groupingUsed));
        } else {
            converter.setGroupingUsed(true);
        }
        if (null != this._integerOnly) {
            converter.setIntegerOnly(UIComponentELTagUtils.getBooleanValue(elContext, this._integerOnly));
        } else {
            converter.setIntegerOnly(false);
        }
        if (null != this._locale) {
            Locale locale;
            if (this._locale.isLiteralText()) {
                locale = LocaleUtils.toLocale(this._locale.getExpressionString());
            } else {
                Object localeValue = this._locale.getValue(elContext);
                locale = localeValue instanceof Locale ? (Locale)localeValue : LocaleUtils.toLocale(localeValue.toString());
                if (null == locale) {
                    locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                }
            }
            converter.setLocale(locale);
        }
        if (null != this._maxFractionDigits) {
            converter.setMaxFractionDigits(UIComponentELTagUtils.getIntegerValue(elContext, this._maxFractionDigits));
        }
        if (null != this._maxIntegerDigits) {
            converter.setMaxIntegerDigits(UIComponentELTagUtils.getIntegerValue(elContext, this._maxIntegerDigits));
        }
        if (null != this._minFractionDigits) {
            converter.setMinFractionDigits(UIComponentELTagUtils.getIntegerValue(elContext, this._minFractionDigits));
        }
        if (null != this._minIntegerDigits) {
            converter.setMinIntegerDigits(UIComponentELTagUtils.getIntegerValue(elContext, this._minIntegerDigits));
        }
        if (null != this._pattern) {
            converter.setPattern((String)UIComponentELTagUtils.evaluateValueExpression(elContext, this._pattern));
        }
        if (null != this._type) {
            converter.setType((String)UIComponentELTagUtils.evaluateValueExpression(elContext, this._type));
        } else {
            converter.setType("number");
        }
        return converter;
    }
}

