/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class HCenterRecord
extends Record {
    public static final short sid = 131;
    private short field_1_hcenter;

    public HCenterRecord() {
    }

    public HCenterRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public HCenterRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 131) {
            throw new RecordFormatException("NOT A HCenter RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_hcenter = LittleEndian.getShort(data, 0 + offset);
    }

    public void setHCenter(boolean hc) {
        this.field_1_hcenter = hc ? (short)1 : 0;
    }

    public boolean getHCenter() {
        return this.field_1_hcenter == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[HCENTER]\n");
        buffer.append("    .hcenter        = ").append(this.getHCenter()).append("\n");
        buffer.append("[/HCENTER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)131);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_hcenter);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 131;
    }

    public Object clone() {
        HCenterRecord rec = new HCenterRecord();
        rec.field_1_hcenter = this.field_1_hcenter;
        return rec;
    }
}

