/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class AuthorizedKeyEntriesPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository.AttributeKey<AuthorizedKeyEntry> AUTHORIZED_KEY = new AttributeRepository.AttributeKey();
    private Map<AuthorizedKeyEntry, PublicKey> resolvedKeys;
    private Object id;

    public AuthorizedKeyEntriesPublickeyAuthenticator(Object id, ServerSession session, Collection<? extends AuthorizedKeyEntry> entries, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        this.id = id;
        int numEntries = GenericUtils.size(entries);
        if (numEntries <= 0) {
            this.resolvedKeys = Collections.emptyMap();
        } else {
            this.resolvedKeys = new HashMap<AuthorizedKeyEntry, PublicKey>(numEntries);
            for (AuthorizedKeyEntry authorizedKeyEntry : entries) {
                PublicKey k = authorizedKeyEntry.resolvePublicKey(session, Collections.emptyMap(), fallbackResolver);
                if (k == null) continue;
                this.resolvedKeys.put(authorizedKeyEntry, k);
            }
        }
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        if (MapEntryUtils.isEmpty(this.resolvedKeys)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no entries", (Object)username, (Object)session);
            }
            return false;
        }
        PublicKey keyToCheck = key;
        boolean isCert = false;
        if (key instanceof OpenSshCertificate) {
            keyToCheck = ((OpenSshCertificate)key).getCaPubKey();
            isCert = true;
        }
        for (Map.Entry<AuthorizedKeyEntry, PublicKey> e : this.resolvedKeys.entrySet()) {
            AuthorizedKeyEntry entry = e.getKey();
            if (isCert != entry.getLoginOptions().containsKey("cert-authority") || !KeyUtils.compareKeys(keyToCheck, e.getValue())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] match found", (Object)username, (Object)session);
            }
            if (isCert && !this.matchesPrincipals(entry, username, (OpenSshCertificate)key, session)) continue;
            if (session != null) {
                session.setAttribute(AUTHORIZED_KEY, entry);
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({})[{}] no match found", (Object)username, (Object)session);
        }
        return false;
    }

    protected boolean matchesPrincipals(AuthorizedKeyEntry entry, String username, OpenSshCertificate cert, ServerSession session) {
        Collection<String> certPrincipals = cert.getPrincipals();
        if (!GenericUtils.isEmpty(certPrincipals)) {
            String allowedPrincipals = entry.getLoginOptions().get("principals");
            if (!GenericUtils.isEmpty(allowedPrincipals)) {
                if (Stream.of(allowedPrincipals.split(",")).map(String::trim).filter(s -> !GenericUtils.isEmpty(s)).noneMatch(certPrincipals::contains)) {
                    this.log.debug("authenticate({})[{}] certificate match ignored, none of the allowed principals matched: {}", new Object[]{username, session, allowedPrincipals});
                    return false;
                }
            } else if (!GenericUtils.isEmpty(certPrincipals) && !certPrincipals.contains(username)) {
                this.log.debug("authenticate({})[{}] certificate match rejected, user not in certificate principals: {}", new Object[]{username, session, username});
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return Objects.toString(this.getId());
    }
}

