/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;

public class SunECSecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    private static final String X25519 = "X25519";
    private static final String X448 = "X448";
    private final Map<String, String> defaultProperties = new HashMap<String, String>();

    public SunECSecurityProviderRegistrar() {
        super("SunECWrapper");
        if (this.isSupported()) {
            Provider provider = this.getSecurityProvider();
            boolean haveEd25519 = SunECSecurityProviderRegistrar.have("Ed25519", provider);
            boolean haveX25519 = SunECSecurityProviderRegistrar.have(X25519, provider);
            boolean haveX448 = SunECSecurityProviderRegistrar.have(X448, provider);
            String keyAgreement = null;
            String generator = null;
            String factory = null;
            String signature = null;
            if (haveEd25519) {
                generator = "Ed25519";
                factory = "Ed25519";
                signature = "Ed25519";
            }
            if (haveX25519) {
                keyAgreement = X25519;
                generator = generator == null ? X25519 : generator + ',' + X25519;
                String string = factory = factory == null ? X25519 : factory + ',' + X25519;
            }
            if (haveX448) {
                keyAgreement = keyAgreement == null ? X448 : keyAgreement + ',' + X448;
                generator = generator == null ? X448 : generator + ',' + X448;
                factory = factory == null ? X448 : factory + ',' + X448;
            }
            String baseName = this.getBasePropertyName();
            if (keyAgreement != null) {
                this.defaultProperties.put(baseName + ".KeyAgreement", keyAgreement);
            }
            if (generator != null) {
                this.defaultProperties.put(baseName + ".KeyPairGenerator", generator);
            }
            if (factory != null) {
                this.defaultProperties.put(baseName + ".KeyFactory", factory);
            }
            if (signature != null) {
                this.defaultProperties.put(baseName + ".Signature", signature);
            }
        }
    }

    private static boolean have(String algorithm, Provider provider) {
        try {
            KeyFactory factory = KeyFactory.getInstance(algorithm, provider);
            return factory != null;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    @Override
    public boolean isEnabled() {
        if (SecurityUtils.isFipsMode() || !super.isEnabled()) {
            return false;
        }
        return this.isSupported();
    }

    @Override
    public String getProviderName() {
        return "SunEC";
    }

    @Override
    public String getDefaultSecurityEntitySupportValue(Class<?> entityType) {
        return "";
    }

    @Override
    public Boolean getBoolean(String name) {
        String value;
        Boolean configured = super.getBoolean(name);
        if (configured == null && (value = this.defaultProperties.get(name)) != null) {
            configured = Boolean.valueOf(value);
        }
        return configured;
    }

    @Override
    public boolean getBooleanProperty(String name, boolean def) {
        Boolean configured = this.getBoolean(name);
        if (configured == null) {
            return def;
        }
        return configured;
    }

    @Override
    public String getString(String name) {
        String byDefault;
        String configured = super.getString(name);
        if (GenericUtils.isEmpty(configured) && (byDefault = this.defaultProperties.get(name)) != null) {
            return byDefault;
        }
        return configured;
    }

    @Override
    public boolean isNamedProviderUsed() {
        return false;
    }

    @Override
    public Provider getSecurityProvider() {
        return Security.getProvider(this.getProviderName());
    }

    @Override
    public boolean isSupported() {
        return this.getSecurityProvider() != null;
    }
}

