/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.filter;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.filter.Filter;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;

public final class FilterContext {
    final Filter filter;
    volatile FilterContext prev;
    volatile FilterContext next;

    FilterContext(Filter filter) {
        this.filter = Objects.requireNonNull(filter);
    }

    public IoWriteFuture send(int cmd, Buffer message) throws IOException {
        FilterContext ctx = this.prev;
        while (ctx != null) {
            OutputHandler handler = ctx.filter.out();
            if (handler != null) {
                return handler.send(cmd, message);
            }
            ctx = ctx.prev;
        }
        throw new IllegalStateException("Fell off filter chain in send from " + this.filter);
    }

    public void passOn(Readable message) throws Exception {
        FilterContext ctx = this.next;
        while (ctx != null) {
            InputHandler handler = ctx.filter.in();
            if (handler != null) {
                handler.received(message);
                return;
            }
            ctx = ctx.next;
        }
        throw new IllegalStateException("Unhandled message: fell off filter chain in receive after " + this.filter);
    }
}

