/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;

public abstract class AbstractKexFactoryManager
extends AbstractInnerCloseable
implements KexFactoryManager {
    private final KexFactoryManager delegate;
    private List<KeyExchangeFactory> keyExchangeFactories;
    private List<NamedFactory<Cipher>> cipherFactories;
    private List<NamedFactory<Compression>> compressionFactories;
    private List<NamedFactory<Mac>> macFactories;
    private List<NamedFactory<Signature>> signatureFactories;
    private KexExtensionHandler kexExtensionHandler;

    protected AbstractKexFactoryManager() {
        this(null);
    }

    protected AbstractKexFactoryManager(KexFactoryManager delegate) {
        this.delegate = delegate;
    }

    protected KexFactoryManager getDelegate() {
        return this.delegate;
    }

    @Override
    public List<KeyExchangeFactory> getKeyExchangeFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(this.keyExchangeFactories, parent == null ? Collections.emptyList() : parent.getKeyExchangeFactories());
    }

    @Override
    public void setKeyExchangeFactories(List<KeyExchangeFactory> keyExchangeFactories) {
        this.keyExchangeFactories = keyExchangeFactories;
    }

    @Override
    public List<NamedFactory<Cipher>> getCipherFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(this.cipherFactories, parent == null ? Collections.emptyList() : parent.getCipherFactories());
    }

    @Override
    public void setCipherFactories(List<NamedFactory<Cipher>> cipherFactories) {
        this.cipherFactories = cipherFactories;
    }

    @Override
    public List<NamedFactory<Compression>> getCompressionFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(this.compressionFactories, parent == null ? Collections.emptyList() : parent.getCompressionFactories());
    }

    @Override
    public void setCompressionFactories(List<NamedFactory<Compression>> compressionFactories) {
        this.compressionFactories = compressionFactories;
    }

    @Override
    public List<NamedFactory<Mac>> getMacFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(this.macFactories, parent == null ? Collections.emptyList() : parent.getMacFactories());
    }

    @Override
    public void setMacFactories(List<NamedFactory<Mac>> macFactories) {
        this.macFactories = macFactories;
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(this.signatureFactories, parent == null ? Collections.emptyList() : parent.getSignatureFactories());
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> signatureFactories) {
        this.signatureFactories = signatureFactories;
    }

    @Override
    public KexExtensionHandler getKexExtensionHandler() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveProvider(KexExtensionHandler.class, this.kexExtensionHandler, parent == null ? null : parent.getKexExtensionHandler());
    }

    @Override
    public void setKexExtensionHandler(KexExtensionHandler kexExtensionHandler) {
        this.kexExtensionHandler = kexExtensionHandler;
    }

    protected <V, C extends Collection<V>> C resolveEffectiveFactories(C local, C inherited) {
        if (GenericUtils.isEmpty(local)) {
            return inherited;
        }
        return local;
    }

    protected <V> V resolveEffectiveProvider(Class<V> providerType, V local, V inherited) {
        if (local == null) {
            return inherited;
        }
        return local;
    }
}

