/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.OptionalDouble;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.BasicErrorMessageFactory;

public class OptionalDoubleShouldHaveValueCloseToPercentage
extends BasicErrorMessageFactory {
    private OptionalDoubleShouldHaveValueCloseToPercentage(double expected) {
        super("%nExpecting an OptionalDouble with value:%n  %s%nbut was empty.", expected);
    }

    private OptionalDoubleShouldHaveValueCloseToPercentage(OptionalDouble actual, double expected, Percentage percentage, double expectedPercentage) {
        super("%nExpecting actual:%n  %s%nto be close to:%n  %s%nby less than %s but difference was %s%%.%n(a difference of exactly %s being considered valid)", actual, expected, percentage, expectedPercentage, percentage);
    }

    public static OptionalDoubleShouldHaveValueCloseToPercentage shouldHaveValueCloseToPercentage(double expectedValue) {
        return new OptionalDoubleShouldHaveValueCloseToPercentage(expectedValue);
    }

    public static OptionalDoubleShouldHaveValueCloseToPercentage shouldHaveValueCloseToPercentage(OptionalDouble optional, double expectedValue, Percentage percentage, double difference) {
        double actualPercentage = difference / expectedValue * 100.0;
        return new OptionalDoubleShouldHaveValueCloseToPercentage(optional, expectedValue, percentage, actualPercentage);
    }
}

