/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.client.spi.NuxeoClientException;

public class NuxeoVersion {
    public static final NuxeoVersion LTS_7_10 = new NuxeoVersion(7, 10, 0, false);
    public static final NuxeoVersion LTS_8_10 = new NuxeoVersion(8, 10, 0, false);
    public static final NuxeoVersion LTS_9_10 = new NuxeoVersion(9, 10, 0, false);
    private static final Pattern NUXEO_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:-HF(\\d+))?(-SNAPSHOT)?(-I\\d{8}_\\d{4})?");
    private final int majorVersion;
    private final int minorVersion;
    private final int hotfix;
    private final boolean snapshot;

    protected NuxeoVersion(int majorVersion, int minorVersion, int hotfix, boolean snapshot) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.hotfix = hotfix;
        this.snapshot = snapshot;
    }

    public String version() {
        StringBuilder version = new StringBuilder();
        version.append(this.majorVersion()).append('.').append(this.minorVersion());
        if (this.hotfix() != 0) {
            version.append("-HF").append(String.format("%02d", this.hotfix()));
        }
        if (this.snapshot()) {
            version.append("-SNAPSHOT");
        }
        return version.toString();
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int hotfix() {
        return this.hotfix;
    }

    public boolean snapshot() {
        return this.snapshot;
    }

    public boolean equals(String version) {
        return this.version().equals(version);
    }

    public boolean equals(NuxeoVersion version) {
        return version != null && this.equals(version.version());
    }

    public boolean equals(Object version) {
        if (version instanceof String) {
            return this.equals((String)version);
        }
        if (version instanceof NuxeoVersion) {
            return this.equals((NuxeoVersion)version);
        }
        return false;
    }

    public String toString() {
        return this.version();
    }

    public NuxeoVersion hotfix(int hotfix) {
        return new NuxeoVersion(this.majorVersion, this.minorVersion, hotfix, false);
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(NuxeoVersion.parse(version));
    }

    public boolean isGreaterThan(NuxeoVersion version) {
        if (this.majorVersion > version.majorVersion() || this.majorVersion == version.majorVersion() && this.minorVersion > version.minorVersion()) {
            return true;
        }
        if (this.majorVersion == version.majorVersion() && this.minorVersion == version.minorVersion()) {
            return this.hotfix >= version.hotfix();
        }
        return false;
    }

    public static NuxeoVersion parse(String version) {
        Matcher matcher = NUXEO_VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new NuxeoClientException("Input version=" + version + " doesn't represent a valid Nuxeo server version");
        }
        int majorVersion = Integer.parseInt(matcher.group(1));
        int minorVersion = Integer.parseInt(matcher.group(2));
        int hotfix = 0;
        if (matcher.group(3) != null) {
            hotfix = Integer.parseInt(matcher.group(3));
        }
        boolean snaphot = matcher.group(4) != null;
        return new NuxeoVersion(majorVersion, minorVersion, hotfix, snaphot);
    }
}

