/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.sis.feature.DefaultFeatureType;

final class CommonParentFinder {
    private final Map<DefaultFeatureType, Boolean> allTypes;
    private final DefaultFeatureType[] required;
    private final int count;

    static DefaultFeatureType select(Iterable<? extends DefaultFeatureType> iterable) {
        LinkedHashMap<DefaultFeatureType, Boolean> linkedHashMap = new LinkedHashMap<DefaultFeatureType, Boolean>();
        iterable.forEach(defaultFeatureType -> linkedHashMap.putIfAbsent((DefaultFeatureType)defaultFeatureType, Boolean.FALSE));
        linkedHashMap.remove(null);
        int n = linkedHashMap.size();
        DefaultFeatureType[] defaultFeatureTypeArray = linkedHashMap.keySet().toArray(new DefaultFeatureType[n]);
        for (int i = 0; i < n; ++i) {
            DefaultFeatureType defaultFeatureType2 = defaultFeatureTypeArray[i];
            int n2 = n;
            while (--n2 >= 0) {
                if (n2 == i || !defaultFeatureType2.isAssignableFrom(defaultFeatureTypeArray[n2])) continue;
                System.arraycopy(defaultFeatureTypeArray, n2 + 1, defaultFeatureTypeArray, n2, --n - n2);
                defaultFeatureTypeArray[n] = null;
                if (n2 >= i) continue;
                --i;
            }
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return defaultFeatureTypeArray[0];
            }
        }
        return new CommonParentFinder(linkedHashMap, defaultFeatureTypeArray, n).select();
    }

    private CommonParentFinder(Map<DefaultFeatureType, Boolean> map, DefaultFeatureType[] defaultFeatureTypeArray, int n) {
        this.allTypes = map;
        this.required = defaultFeatureTypeArray;
        this.count = n;
        for (int i = 0; i < n; ++i) {
            this.scanParents(defaultFeatureTypeArray[i]);
        }
    }

    private boolean isAssignableFromAll(DefaultFeatureType defaultFeatureType) {
        for (int i = 0; i < this.count; ++i) {
            DefaultFeatureType defaultFeatureType2 = this.required[i];
            if (defaultFeatureType2 == defaultFeatureType || defaultFeatureType.isAssignableFrom(defaultFeatureType2)) continue;
            return false;
        }
        return true;
    }

    private void scanParents(DefaultFeatureType defaultFeatureType) {
        for (DefaultFeatureType defaultFeatureType2 : defaultFeatureType.getSuperTypes()) {
            if (this.allTypes.putIfAbsent(defaultFeatureType2, Boolean.FALSE) != null) continue;
            if (this.isAssignableFromAll(defaultFeatureType2)) {
                this.allTypes.put(defaultFeatureType2, Boolean.TRUE);
                this.skipParents(defaultFeatureType2);
                continue;
            }
            this.scanParents(defaultFeatureType2);
        }
    }

    private void skipParents(DefaultFeatureType defaultFeatureType) {
        assert (this.isAssignableFromAll(defaultFeatureType));
        for (DefaultFeatureType defaultFeatureType2 : defaultFeatureType.getSuperTypes()) {
            if (Boolean.TRUE.equals(this.allTypes.put(defaultFeatureType2, Boolean.FALSE))) continue;
            this.skipParents(defaultFeatureType2);
        }
    }

    DefaultFeatureType select() {
        this.allTypes.values().removeIf(Predicate.isEqual(Boolean.FALSE));
        DefaultFeatureType defaultFeatureType = null;
        int n = 0;
        for (DefaultFeatureType defaultFeatureType2 : this.allTypes.keySet()) {
            int n2 = defaultFeatureType2.getProperties(true).size();
            if (defaultFeatureType != null && n2 <= n) continue;
            defaultFeatureType = defaultFeatureType2;
            n = n2;
        }
        return defaultFeatureType;
    }
}

