/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Dates {
    public static Calendar parse(String str) throws ParseException {
        if (str == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        int len = str.length();
        if (len == 0) {
            return cal;
        }
        int i = 0;
        i = Dates.readYear(cal, str, i);
        if ((i = Dates.readCharOpt('-', cal, str, i)) == -1) {
            return cal;
        }
        i = Dates.readMonth(cal, str, i);
        if ((i = Dates.readCharOpt('-', cal, str, i)) == -1) {
            return cal;
        }
        i = Dates.readDay(cal, str, i);
        if ((i = Dates.readCharOpt('T', cal, str, i)) == -1) {
            return cal;
        }
        i = Dates.readHours(cal, str, i);
        if ((i = Dates.readCharOpt(':', cal, str, i)) == -1) {
            return cal;
        }
        if (Dates.isChar(':', str, i = Dates.readMinutes(cal, str, i)) && Dates.isChar('.', str, i = Dates.readSeconds(cal, str, i + 1))) {
            i = Dates.readMilliseconds(cal, str, i + 1);
        }
        if (i > -1) {
            Dates.readTimeZone(cal, str, i);
        }
        return cal;
    }

    public static Date parseW3CDateTime(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Dates.parse(str).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse ISO 8601 date: " + str, e);
        }
    }

    public static String formatW3CDateTime(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        return String.format("%04d-%02d-%02dT%02d:%02d:%02dZ", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static String formatW3CDateTimeMs(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    private static int readYear(Calendar cal, String str, int off) throws ParseException {
        if (str.length() >= off + 4) {
            cal.set(1, Integer.parseInt(str.substring(off, off + 4)));
            return off + 4;
        }
        throw new ParseException("Invalid year in date '" + str + "'", off);
    }

    private static int readMonth(Calendar cal, String str, int off) throws ParseException {
        if (str.length() >= off + 2) {
            cal.set(2, Integer.parseInt(str.substring(off, off + 2)) - 1);
            return off + 2;
        }
        throw new ParseException("Invalid month in date '" + str + "'", off);
    }

    private static int readDay(Calendar cal, String str, int off) throws ParseException {
        if (str.length() >= off + 2) {
            cal.set(5, Integer.parseInt(str.substring(off, off + 2)));
            return off + 2;
        }
        throw new ParseException("Invalid day in date '" + str + "'", off);
    }

    private static int readHours(Calendar cal, String str, int off) throws ParseException {
        if (str.length() >= off + 2) {
            cal.set(10, Integer.parseInt(str.substring(off, off + 2)));
            return off + 2;
        }
        throw new ParseException("Invalid hours in date '" + str + "'", off);
    }

    private static int readMinutes(Calendar cal, String str, int off) throws ParseException {
        if (str.length() >= off + 2) {
            cal.set(12, Integer.parseInt(str.substring(off, off + 2)));
            return off + 2;
        }
        throw new ParseException("Invalid minutes in date '" + str + "'", off);
    }

    private static int readSeconds(Calendar cal, String str, int off) throws ParseException {
        if (str.length() >= off + 2) {
            cal.set(13, Integer.parseInt(str.substring(off, off + 2)));
            return off + 2;
        }
        throw new ParseException("Invalid seconds in date '" + str + "'", off);
    }

    private static int readMilliseconds(Calendar cal, String str, int off) throws ParseException {
        String ms;
        int mslen;
        int e = str.indexOf(90, off);
        if (e == -1 && (e = str.indexOf(43, off)) == -1) {
            e = str.indexOf(45, off);
        }
        if ((mslen = (ms = e == -1 ? str.substring(off) : str.substring(off, e)).length()) > 0) {
            int f;
            switch (mslen) {
                case 1: {
                    f = Integer.parseInt(ms) * 100;
                    break;
                }
                case 2: {
                    f = Integer.parseInt(ms) * 10;
                    break;
                }
                case 3: {
                    f = Integer.parseInt(ms);
                    break;
                }
                default: {
                    f = Integer.parseInt(ms.substring(0, 3));
                }
            }
            cal.set(14, f);
        }
        return e;
    }

    private static boolean isChar(char c, String str, int off) {
        return str.length() > off && str.charAt(off) == c;
    }

    private static int readCharOpt(char c, Calendar cal, String str, int off) {
        if (str.length() > off && str.charAt(off) == c) {
            return off + 1;
        }
        return -1;
    }

    private static boolean readTimeZone(Calendar cal, String str, int off) throws ParseException {
        int h;
        int len = str.length();
        if (len == off) {
            return false;
        }
        char c = str.charAt(off);
        if (c == 'Z') {
            return true;
        }
        ++off;
        boolean plus = false;
        if (c == '+') {
            plus = true;
        } else if (c != '-') {
            throw new ParseException("Only Z, +, - prefixes are allowed in TZ", off);
        }
        int m = 0;
        int d = len - off;
        if (d == 2) {
            h = Integer.parseInt(str.substring(off, off + 2));
        } else if (d == 5) {
            h = Integer.parseInt(str.substring(off, off + 2));
            m = Integer.parseInt(str.substring(off + 3, off + 5));
        } else {
            throw new ParseException("Invalid TZ in \"" + str + "\"", off);
        }
        if (plus) {
            cal.add(10, -h);
            cal.add(12, -m);
        } else {
            cal.add(10, h);
            cal.add(12, m);
        }
        return true;
    }
}

