/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import java.lang.reflect.Constructor;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExceptionConverter {
    private ExceptionConverter() {
    }

    public static FileSystemException generate(DavException davExc) throws FileSystemException {
        return ExceptionConverter.generate(davExc, null);
    }

    public static FileSystemException generate(DavException davExc, DavMethod method) throws FileSystemException {
        String msg = davExc.getMessage();
        if (davExc.hasErrorCondition()) {
            try {
                Element error = davExc.toXml(DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument());
                if (DomUtil.matches((Node)error, (String)"error", (Namespace)DavConstants.NAMESPACE) && DomUtil.hasChildElement((Node)error, (String)"exception", null)) {
                    Class<?> cl;
                    Constructor<?> excConstr;
                    Element exc = DomUtil.getChildElement((Node)error, (String)"exception", null);
                    if (DomUtil.hasChildElement((Node)exc, (String)"message", null)) {
                        msg = DomUtil.getChildText((Element)exc, (String)"message", null);
                    }
                    if (DomUtil.hasChildElement((Node)exc, (String)"class", null) && (excConstr = (cl = Class.forName(DomUtil.getChildText((Element)exc, (String)"class", null))).getConstructor(String.class)) != null) {
                        Object o = excConstr.newInstance(msg);
                        if (o instanceof FileSystemException) {
                            return (FileSystemException)o;
                        }
                        if (o instanceof Exception) {
                            return new FileSystemException(msg, (Exception)o);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new FileSystemException(e);
            }
        }
        return new FileSystemException(msg);
    }
}

