/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.spi.auth;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.nuxeo.client.util.Base64;

public class PortalSSOAuthInterceptor
implements Interceptor {
    protected final String secret;
    protected final String username;

    public PortalSSOAuthInterceptor(String username, String secret) {
        this.username = username;
        this.secret = secret;
    }

    protected Headers computeHeaders(Headers headers) {
        byte[] hashedToken;
        long ts = new Date().getTime();
        long random = new Random(ts).nextInt();
        String clearToken = String.format("%d:%d:%s:%s", ts, random, this.secret, this.username);
        try {
            hashedToken = MessageDigest.getInstance("MD5").digest(clearToken.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot compute token", e);
        }
        String base64HashedToken = Base64.encode(hashedToken);
        return headers.newBuilder().add("NX_TS", String.valueOf(ts)).add("NX_RD", String.valueOf(random)).add("NX_TOKEN", base64HashedToken).add("NX_USER", this.username).build();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request request = chain.request().newBuilder().headers(this.computeHeaders(original.headers())).method(original.method(), original.body()).build();
        return chain.proceed(request);
    }
}

