/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.concurrency;

import java.util.concurrent.Callable;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperationCallable;
import net.sf.ehcache.constructs.nonstop.ThrowTimeoutException;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingClusterOperation;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContext;
import net.sf.ehcache.constructs.nonstop.concurrency.InvalidLockStateAfterRejoinException;
import net.sf.ehcache.constructs.nonstop.concurrency.NonstopThreadUniqueIdProvider;

public class CacheOperationUnderExplicitLockCallable<V>
implements Callable<V> {
    private final Callable<V> cacheOperationCallable;
    private final ExplicitLockingContext appThreadLockContext;
    private final NonstopConfiguration nonstopConfiguration;

    public CacheOperationUnderExplicitLockCallable(ExplicitLockingContext currentThreadLockContext, NonstopConfiguration nonstopConfiguration, Callable<V> callable) {
        this.appThreadLockContext = currentThreadLockContext;
        this.nonstopConfiguration = nonstopConfiguration;
        this.cacheOperationCallable = callable;
    }

    @Override
    public V call() throws Exception {
        if (this.isExplicitLockApi()) {
            return this.cacheOperationCallable.call();
        }
        if (this.appThreadLockContext.areLocksAcquiredByOtherThreads(NonstopThreadUniqueIdProvider.getCurrentNonstopThreadUniqueId())) {
            switch (this.nonstopConfiguration.getTimeoutBehavior().getTimeoutBehaviorType()) {
                case NOOP: 
                case LOCAL_READS: {
                    throw new ThrowTimeoutException();
                }
            }
            throw new InvalidLockStateAfterRejoinException();
        }
        return this.cacheOperationCallable.call();
    }

    private boolean isExplicitLockApi() {
        return this.cacheOperationCallable instanceof ClusterOperationCallable && ((ClusterOperationCallable)this.cacheOperationCallable).getClusterOperation() instanceof ExplicitLockingClusterOperation;
    }
}

