/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.sql.SQLException;
import java.text.Format;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.sis.internal.system.OptionalDependency;
import org.apache.sis.util.CharSequences;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;

public class MetadataServices
extends OptionalDependency {
    private static volatile MetadataServices instance;

    protected MetadataServices() {
        super("org.apache.sis.util", "sis-metadata");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void classpathChanged() {
        Class<MetadataServices> clazz = MetadataServices.class;
        synchronized (MetadataServices.class) {
            super.classpathChanged();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetadataServices getInstance() {
        MetadataServices metadataServices = instance;
        if (metadataServices != null) return metadataServices;
        Class<MetadataServices> clazz = MetadataServices.class;
        synchronized (MetadataServices.class) {
            metadataServices = instance;
            if (metadataServices != null) return metadataServices;
            metadataServices = MetadataServices.getInstance(MetadataServices.class, "org.apache.sis.util", "sis-metadata", "org.apache.sis.internal.metadata.ServicesForUtility");
            if (metadataServices == null) {
                metadataServices = new MetadataServices();
            }
            instance = metadataServices;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metadataServices;
        }
    }

    public boolean isUnmarshalling() {
        return false;
    }

    public String getCodeTitle(CodeList<?> codeList, Locale locale) {
        UML uML = codeList.getClass().getAnnotation(UML.class);
        if (uML != null) {
            try {
                return ResourceBundle.getBundle("org.opengis.metadata.CodeLists", locale, UML.class.getClassLoader()).getString(uML.identifier() + '.' + codeList.identifier());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return CharSequences.camelCaseToSentence(codeList.identifier()).toString();
    }

    public String getUnicodeIdentifier(Citation citation) {
        return null;
    }

    public String getInformation(String string, Locale locale) {
        return null;
    }

    public Format createCoordinateFormat(Locale locale, TimeZone timeZone) {
        throw this.moduleNotFound();
    }

    public DataSource getDataSource() throws SQLException {
        throw this.moduleNotFound();
    }

    public void setDataSource(Supplier<DataSource> supplier) {
        throw this.moduleNotFound();
    }
}

