/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableInt
extends VariableBase {
    protected int value;

    public VariableInt(int value) {
        this.value = value;
    }

    public int hashCode() {
        return new Integer(this.value).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableInt)) {
            return false;
        }
        return ((VariableInt)o).value == this.value;
    }

    @Override
    public boolean hasStringValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasIntValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasDoubleValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        return Integer.toString(this.value);
    }

    @Override
    public String getStringValue() throws ScriptException {
        return Integer.toString(this.value);
    }

    @Override
    public int getIntValue() throws ScriptException {
        return this.value;
    }

    @Override
    public double getDoubleValue() throws ScriptException {
        return this.value;
    }

    @Override
    public VariableReference plus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '+' operand cannot be null"));
        }
        return new VariableInt(this.value + v.getIntValue());
    }

    @Override
    public VariableReference minus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '-' operand cannot be null"));
        }
        return new VariableInt(this.value - v.getIntValue());
    }

    @Override
    public VariableReference asterisk(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '*' operand cannot be null"));
        }
        return new VariableInt(this.value * v.getIntValue());
    }

    @Override
    public VariableReference slash(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '/' operand cannot be null"));
        }
        return new VariableInt(this.value / v.getIntValue());
    }

    @Override
    public VariableReference unaryMinus() throws ScriptException {
        return new VariableInt(-this.value);
    }

    @Override
    public VariableReference greaterAngle(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '>' operand cannot be null"));
        }
        return new VariableBoolean(this.value > v.getIntValue());
    }

    @Override
    public VariableReference lesserAngle(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '<' operand cannot be null"));
        }
        return new VariableBoolean(this.value < v.getIntValue());
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '==' operand cannot be null"));
        }
        return new VariableBoolean(this.value == v.getIntValue());
    }

    @Override
    public VariableReference greaterAngleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '>=' operand cannot be null"));
        }
        return new VariableBoolean(this.value >= v.getIntValue());
    }

    @Override
    public VariableReference lesserAngleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '<=' operand cannot be null"));
        }
        return new VariableBoolean(this.value <= v.getIntValue());
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '!=' operand cannot be null"));
        }
        return new VariableBoolean(this.value != v.getIntValue());
    }

    @Override
    public VariableReference ampersand(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '&' operand cannot be null"));
        }
        return new VariableInt(this.value & v.getIntValue());
    }

    @Override
    public VariableReference pipe(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '|' operand cannot be null"));
        }
        return new VariableInt(this.value | v.getIntValue());
    }

    @Override
    public VariableReference unaryExclamation() throws ScriptException {
        return new VariableInt(this.value ^ this.value);
    }
}

