/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class Declaration
extends ASTCssNode {
    private InterpolableName name;
    private Expression expression;
    private ListExpressionOperator.Operator mergeOperator;

    public Declaration(HiddenTokenAwareTree token, InterpolableName name) {
        this(token, name, null, null);
    }

    public Declaration(HiddenTokenAwareTree token, InterpolableName name, Expression expression, ListExpressionOperator.Operator mergeOperator) {
        super(token);
        this.name = name;
        this.expression = expression;
        this.mergeOperator = mergeOperator;
    }

    public String getNameAsString() {
        return this.name.getName();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isMerging() {
        return this.mergeOperator != null;
    }

    public void setName(InterpolableName name) {
        this.name = name;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ListExpressionOperator.Operator getMergeOperator() {
        return this.mergeOperator;
    }

    public void setMergeOperator(ListExpressionOperator.Operator mergeOperator) {
        this.mergeOperator = mergeOperator;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.DECLARATION;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.expression, this.name);
    }

    public boolean isFontDeclaration() {
        String n = this.getNameAsString();
        return n != null ? n.toLowerCase().equals("font") : false;
    }

    public boolean isFilterDeclaration() {
        String n = this.getNameAsString();
        return n != null ? n.toLowerCase().endsWith("filter") : false;
    }

    @Override
    public String toString() {
        return "" + this.name + ":" + this.expression;
    }

    @Override
    public Declaration clone() {
        Declaration result = (Declaration)super.clone();
        result.name = this.name == null ? null : this.name.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

