/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIntIteratorImplBase;
import org.apache.uima.cas.impl.FSRBTSetIndex;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.rb_trees.IntArrayRBT;

public class IntIterator4set<T extends FeatureStructure>
extends FSIntIteratorImplBase<T> {
    private static final int NIL = 0;
    private int currentNode;
    private final IntComparator comp;
    private final FSRBTSetIndex<T> fsSetIndex;
    private final IntArrayRBT intArrayRBTindex;

    public IntIterator4set(FSRBTSetIndex<T> fsSetIndex, int[] detectIllegalIndexUpdates, IntComparator comp) {
        super(fsSetIndex, detectIllegalIndexUpdates);
        this.fsSetIndex = fsSetIndex;
        this.intArrayRBTindex = fsSetIndex.tree;
        this.comp = comp;
        this.moveToFirst();
    }

    @Override
    public boolean isValid() {
        return this.currentNode != 0;
    }

    @Override
    public void moveToFirst() {
        this.resetConcurrentModification();
        this.currentNode = this.intArrayRBTindex.getFirstNode();
    }

    @Override
    public void moveToLast() {
        this.resetConcurrentModification();
        this.currentNode = this.intArrayRBTindex.greatestNode;
    }

    @Override
    public void moveToNext() {
        this.checkConcurrentModification();
        this.currentNode = this.intArrayRBTindex.nextNode(this.currentNode);
    }

    @Override
    public void moveToPrevious() {
        this.checkConcurrentModification();
        this.currentNode = this.intArrayRBTindex.previousNode(this.currentNode);
    }

    @Override
    public int get() {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        this.checkConcurrentModification();
        return this.intArrayRBTindex.getKeyForNode(this.currentNode);
    }

    @Override
    public Object copy() {
        IntIterator4set<T> copy = new IntIterator4set<T>(this.fsSetIndex, this.detectIllegalIndexUpdates, this.comp);
        copy.currentNode = this.currentNode;
        return copy;
    }

    @Override
    public void moveTo(int i) {
        this.resetConcurrentModification();
        this.currentNode = this.intArrayRBTindex.findInsertionPoint(i);
    }

    @Override
    public int ll_indexSize() {
        return this.fsSetIndex.size();
    }

    @Override
    public int compareTo(FSIntIteratorImplBase<T> o) {
        return this.comp.compare(this.get(), ((IntIterator4set)o).get());
    }
}

