/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.marshaller;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import org.nuxeo.client.marshaller.NuxeoConverterFactory;

public class EntityValueDeserializer
extends StdDeserializer<Object> {
    protected EntityValueDeserializer() {
        super(Object.class);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        TreeNode node = jp.readValueAsTree();
        Class<?> concreteType = this.determineConcreteType(node);
        return jp.getCodec().treeToValue(node, concreteType);
    }

    protected Class<?> determineConcreteType(TreeNode node) {
        String entityType;
        Class<?> klazz;
        TreeNode entityNode = node.get("entity-type");
        if (entityNode != null && entityNode.isValueNode() && (klazz = NuxeoConverterFactory.entityTypeToClass.get(entityType = ((ValueNode)entityNode).asText())) != null) {
            return klazz;
        }
        return Object.class;
    }
}

