/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.renderer;

import com.uwyn.jhighlight.renderer.CppXhtmlRenderer;
import com.uwyn.jhighlight.renderer.GroovyXhtmlRenderer;
import com.uwyn.jhighlight.renderer.JavaXhtmlRenderer;
import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XmlXhtmlRenderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class XhtmlRendererFactory {
    public static final String GROOVY = "groovy";
    public static final String JAVA = "java";
    public static final String BEANSHELL = "beanshell";
    public static final String BSH = "bsh";
    public static final String XML = "xml";
    public static final String XHTML = "xhtml";
    public static final String LZX = "lzx";
    public static final String HTML = "html";
    public static final String CPP = "cpp";
    public static final String CXX = "cxx";
    public static final String CPLUSPLUS = "c++";
    private static final Map RENDERERS_CLASSNAMES = new HashMap(){
        {
            this.put(XhtmlRendererFactory.GROOVY, GroovyXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.JAVA, JavaXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.BEANSHELL, JavaXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.BSH, JavaXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.XML, XmlXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.XHTML, XmlXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.LZX, XmlXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.HTML, XmlXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.CPP, CppXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.CXX, CppXhtmlRenderer.class.getName());
            this.put(XhtmlRendererFactory.CPLUSPLUS, CppXhtmlRenderer.class.getName());
        }
    };

    public static Renderer getRenderer(String type) {
        String classname = (String)RENDERERS_CLASSNAMES.get(type.toLowerCase());
        if (null == classname) {
            return null;
        }
        try {
            Class<?> klass = Class.forName(classname);
            return (Renderer)klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Set getSupportedTypes() {
        return Collections.unmodifiableSet(RENDERERS_CLASSNAMES.keySet());
    }
}

