/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.solr.ModifiedHttpSolrClient;
import org.apache.manifoldcf.agents.output.solr.ModifiedLBHttpSolrClient;
import org.apache.manifoldcf.agents.output.solr.PreemptiveBasicAuthInterceptor;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;

public class HttpPoster {
    public static final String _rcsid = "@(#)$Id: HttpPoster.java 991295 2010-08-31 19:12:14Z kwright $";
    public static String ingestBufferSizeProperty = "org.apache.manifoldcf.ingest.buffersize";
    public static String ingestCredentialsRealm = "org.apache.manifoldcf.ingest.credentialrealm";
    public static String ingestResponseRetryCount = "org.apache.manifoldcf.ingest.responseretrycount";
    public static String ingestResponseRetryInterval = "org.apache.manifoldcf.ingest.retryinterval";
    public static String ingestRescheduleInterval = "org.apache.manifoldcf.ingest.rescheduleinterval";
    public static String ingestURIProperty = "org.apache.manifoldcf.ingest.uri";
    public static String ingestUserProperty = "org.apache.manifoldcf.ingest.user";
    public static String ingestPasswordProperty = "org.apache.manifoldcf.ingest.password";
    public static String ingestMaxConnectionsProperty = "org.apache.manifoldcf.ingest.maxconnections";
    protected PoolingHttpClientConnectionManager connectionManager = null;
    protected SolrClient solrServer = null;
    private final String postUpdateAction;
    private final String postRemoveAction;
    private final String postStatusAction;
    private final String allowAttributeName;
    private final String denyAttributeName;
    private final String idAttributeName;
    private final String originalSizeAttributeName;
    private final String modifiedDateAttributeName;
    private final String createdDateAttributeName;
    private final String indexedDateAttributeName;
    private final String fileNameAttributeName;
    private final String mimeTypeAttributeName;
    private final String contentAttributeName;
    private final boolean useExtractUpdateHandler;
    private final Long maxDocumentLength;
    private final Set<String> includedMimeTypes;
    private final Set<String> excludedMimeTypes;
    private final String commitWithin;
    private static final String LITERAL = "literal.";
    private static final String NOTHING = "__NOTHING__";
    private static final String ID_METADATA = "lcf_metadata_id";
    private static final String COMMITWITHIN_METADATA = "commitWithin";
    private static final long interruptionRetryTime = 60000L;
    private static final Set<String> acceptableMimeTypes = new HashSet<String>();

    public HttpPoster(String zookeeperHosts, String collection, int zkClientTimeout, int zkConnectTimeout, String updatePath, String removePath, String statusPath, String allowAttributeName, String denyAttributeName, String idAttributeName, String originalSizeAttributeName, String modifiedDateAttributeName, String createdDateAttributeName, String indexedDateAttributeName, String fileNameAttributeName, String mimeTypeAttributeName, String contentAttributeName, Long maxDocumentLength, String commitWithin, boolean useExtractUpdateHandler, Set<String> includedMimeTypes, Set<String> excludedMimeTypes, boolean allowCompression) throws ManifoldCFException {
        this.postUpdateAction = updatePath;
        this.postRemoveAction = removePath;
        this.postStatusAction = statusPath;
        this.commitWithin = commitWithin;
        this.allowAttributeName = allowAttributeName;
        this.denyAttributeName = denyAttributeName;
        this.idAttributeName = idAttributeName;
        this.originalSizeAttributeName = originalSizeAttributeName;
        this.modifiedDateAttributeName = modifiedDateAttributeName;
        this.createdDateAttributeName = createdDateAttributeName;
        this.indexedDateAttributeName = indexedDateAttributeName;
        this.fileNameAttributeName = fileNameAttributeName;
        this.mimeTypeAttributeName = mimeTypeAttributeName;
        this.contentAttributeName = contentAttributeName;
        this.useExtractUpdateHandler = useExtractUpdateHandler;
        this.includedMimeTypes = includedMimeTypes;
        this.excludedMimeTypes = excludedMimeTypes;
        this.maxDocumentLength = maxDocumentLength;
        HttpPoster.initializeKerberos();
        try {
            CloudSolrClient cloudSolrServer = new CloudSolrClient.Builder().withZkHost(zookeeperHosts).withLBHttpSolrClient((LBHttpSolrClient)new ModifiedLBHttpSolrClient((HttpClient)HttpClientUtil.createClient(null), allowCompression, new String[0])).build();
            cloudSolrServer.setZkClientTimeout(zkClientTimeout);
            cloudSolrServer.setZkConnectTimeout(zkConnectTimeout);
            cloudSolrServer.setDefaultCollection(collection);
            this.solrServer = cloudSolrServer;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public HttpPoster(String protocol, String server, int port, String webapp, String core, int connectionTimeout, int socketTimeout, String updatePath, String removePath, String statusPath, String realm, String userID, String password, String allowAttributeName, String denyAttributeName, String idAttributeName, String originalSizeAttributeName, String modifiedDateAttributeName, String createdDateAttributeName, String indexedDateAttributeName, String fileNameAttributeName, String mimeTypeAttributeName, String contentAttributeName, IKeystoreManager keystoreManager, Long maxDocumentLength, String commitWithin, boolean useExtractUpdateHandler, Set<String> includedMimeTypes, Set<String> excludedMimeTypes, boolean allowCompression) throws ManifoldCFException {
        this.postUpdateAction = updatePath;
        this.postRemoveAction = removePath;
        this.postStatusAction = statusPath;
        this.commitWithin = commitWithin;
        this.allowAttributeName = allowAttributeName;
        this.denyAttributeName = denyAttributeName;
        this.idAttributeName = idAttributeName;
        this.originalSizeAttributeName = originalSizeAttributeName;
        this.modifiedDateAttributeName = modifiedDateAttributeName;
        this.createdDateAttributeName = createdDateAttributeName;
        this.indexedDateAttributeName = indexedDateAttributeName;
        this.fileNameAttributeName = fileNameAttributeName;
        this.mimeTypeAttributeName = mimeTypeAttributeName;
        this.contentAttributeName = contentAttributeName;
        this.useExtractUpdateHandler = useExtractUpdateHandler;
        this.includedMimeTypes = includedMimeTypes;
        this.excludedMimeTypes = excludedMimeTypes;
        this.maxDocumentLength = maxDocumentLength;
        HttpPoster.initializeKerberos();
        String location = "";
        if (webapp != null) {
            location = "/" + webapp;
        }
        if (core != null) {
            if (webapp == null) {
                throw new ManifoldCFException("Webapp must be specified if core is specified.");
            }
            location = location + "/" + core;
        }
        SSLConnectionSocketFactory myFactory = keystoreManager != null ? new SSLConnectionSocketFactory(keystoreManager.getSecureSocketFactory(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : new SSLConnectionSocketFactory(KeystoreManagerFactory.getTrustingSecureSocketFactory(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        this.connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
        this.connectionManager.setDefaultMaxPerRoute(1);
        this.connectionManager.setValidateAfterInactivity(2000);
        this.connectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setRequestExecutor(new HttpRequestExecutor(socketTimeout));
        if (userID != null && userID.length() > 0 && password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userID, password);
            if (realm != null && realm.trim().length() > 0) {
                AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, realm);
                credentialsProvider.setCredentials(scope, (Credentials)credentials);
                clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveBasicAuthInterceptor(scope));
            } else {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveBasicAuthInterceptor(AuthScope.ANY));
            }
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        CloseableHttpClient localClient = clientBuilder.build();
        String httpSolrServerUrl = protocol + "://" + server + ":" + port + location;
        this.solrServer = new ModifiedHttpSolrClient(httpSolrServerUrl, (HttpClient)localClient, (ResponseParser)new XMLResponseParser(), allowCompression);
    }

    private static void initializeKerberos() {
        String loginConfig = System.getProperty("java.security.auth.login.config");
        if (loginConfig != null && loginConfig.trim().length() > 0) {
            if (Logging.ingest.isInfoEnabled()) {
                Logging.ingest.info((Object)"Using Kerberos for Solr Authentication");
            }
            Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();
            SolrHttpClientBuilder kb = krbBuild.getBuilder();
            HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
        }
    }

    public void shutdown() {
        if (this.solrServer != null) {
            try {
                this.solrServer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.solrServer = null;
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
    }

    public void commitPost() throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)"commitPost()");
        }
        try {
            CommitThread t = new CommitThread();
            try {
                t.start();
                t.finishUp();
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
            }
        }
        catch (SolrServerException e) {
            HttpPoster.handleSolrServerException(e, "commit");
            return;
        }
        catch (SolrException e) {
            HttpPoster.handleSolrException(e, "commit");
            return;
        }
        catch (RuntimeException e) {
            HttpPoster.handleRuntimeException(e, "commit");
            return;
        }
        catch (IOException ioe) {
            HttpPoster.handleIOException(ioe, "commit");
            return;
        }
    }

    protected static void handleRuntimeException(RuntimeException e, String context) throws ManifoldCFException, ServiceInterruption {
        Throwable childException = e.getCause();
        if (childException != null && childException instanceof TimeoutException) {
            Logging.ingest.warn((Object)("SolrJ runtime exception during " + context + ": " + childException.getMessage()), childException);
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption(childException.getMessage(), childException, currentTime + 60000L, currentTime + 0x6DDD00L, -1, true);
        }
        Logging.ingest.warn((Object)("Solr was unable to parse request during " + context + ": " + e.getMessage()), (Throwable)e);
    }

    protected static void handleSolrServerException(SolrServerException e, String context) throws ManifoldCFException, ServiceInterruption {
        Throwable childException = e.getCause();
        if (childException instanceof IOException) {
            HttpPoster.handleIOException((IOException)childException, context);
            return;
        }
        if (childException instanceof RuntimeException) {
            HttpPoster.handleRuntimeException((RuntimeException)childException, context);
            return;
        }
        String message = "SolrServerException exception during " + context + ": " + e.getMessage();
        Logging.ingest.warn((Object)message, (Throwable)e);
    }

    protected static void handleSolrException(SolrException e, String context) throws ManifoldCFException, ServiceInterruption {
        int code = e.code();
        if (code == 0) {
            try {
                Pattern p = Pattern.compile("non ok status:([0-9]*),");
                Matcher m = p.matcher(e.getMessage());
                if (m.find()) {
                    code = Integer.parseInt(m.group(1));
                }
            }
            catch (PatternSyntaxException e2) {
                throw new ManifoldCFException("Unexpected error: " + e2.getMessage());
            }
            catch (NumberFormatException e2) {
                throw new ManifoldCFException("Unexpected error: " + e2.getMessage());
            }
        }
        if (code == 500 && e.getMessage().indexOf("org.apache.tika.exception.TikaException") != -1) {
            return;
        }
        if (code == 401) {
            String message = "Solr authorization failure, code " + code + ": aborting job";
            Logging.ingest.error((Object)message);
            throw new ManifoldCFException(message);
        }
        if (code >= 400 && code < 500) {
            return;
        }
        if (code == 500) {
            long currentTime = System.currentTimeMillis();
            String message = "Solr exception during " + context + " (" + e.code() + "): " + e.getMessage();
            Logging.ingest.warn((Object)message, (Throwable)e);
            throw new ServiceInterruption(message, (Throwable)e, currentTime + 60000L, currentTime + 0x6DDD00L, -1, true);
        }
        throw new ManifoldCFException("Unhandled Solr exception during " + context + " (" + e.code() + "): " + e.getMessage());
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof InterruptedIOException && !(e instanceof SocketTimeoutException)) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        long currentTime = System.currentTimeMillis();
        if (e instanceof ConnectException) {
            String message = "Server could not be contacted during " + context + ": " + e.getMessage();
            Logging.ingest.warn((Object)message, (Throwable)e);
            throw new ServiceInterruption(message, (Throwable)e, currentTime + 60000L, -1L, 3, true);
        }
        if (e instanceof SocketTimeoutException) {
            String message2 = "Socket timeout exception during " + context + ": " + e.getMessage();
            Logging.ingest.warn((Object)message2, (Throwable)e);
            throw new ServiceInterruption(message2, (Throwable)e, currentTime + 60000L, currentTime + 1200000L, -1, false);
        }
        if (e.getClass().getName().equals("java.net.SocketException")) {
            if (e.getMessage().toLowerCase(Locale.ROOT).indexOf("broken pipe") != -1 || e.getMessage().toLowerCase(Locale.ROOT).indexOf("connection reset") != -1 || e.getMessage().toLowerCase(Locale.ROOT).indexOf("target server failed to respond") != -1) {
                String message = "Server dropped connection during " + context + ": " + e.getMessage();
                Logging.ingest.warn((Object)message, (Throwable)e);
                throw new ServiceInterruption(message, (Throwable)e, currentTime + 60000L, -1L, 3, false);
            }
            String message2 = "Socket exception during " + context + ": " + e.getMessage();
            Logging.ingest.warn((Object)message2, (Throwable)e);
            throw new ServiceInterruption(message2, (Throwable)e, currentTime + 60000L, currentTime + 1200000L, -1, false);
        }
        String message3 = "IO exception during " + context + ": " + e.getMessage();
        Logging.ingest.warn((Object)message3, (Throwable)e);
        throw new ServiceInterruption(message3, (Throwable)e, currentTime + 60000L, -1L, 3, false);
    }

    public boolean indexPost(String documentURI, RepositoryDocument document, Map<String, List<String>> arguments, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("indexPost(): '" + documentURI + "'"));
        }
        if (this.maxDocumentLength != null && document.getBinaryLength() > this.maxDocumentLength) {
            activities.recordActivity(null, "document ingest", null, documentURI, "EXCLUDEDLENGTH", "Solr connector rejected document due to its big size: ('" + document.getBinaryLength() + "')");
            return false;
        }
        if (!(this.includedMimeTypes == null && this.excludedMimeTypes == null || HttpPoster.checkMimeTypeIndexable(document.getMimeType(), true, this.includedMimeTypes, this.excludedMimeTypes))) {
            activities.recordActivity(null, "document ingest", null, documentURI, "EXCLUDEDMIMETYPE", "Solr connector rejected document due to mime type restrictions: (" + document.getMimeType() + ")");
            return false;
        }
        HashMap<String, String[]> aclsMap = new HashMap<String, String[]>();
        HashMap<String, String[]> denyAclsMap = new HashMap<String, String[]>();
        Iterator aclTypes = document.securityTypesIterator();
        while (aclTypes.hasNext()) {
            String aclType = (String)aclTypes.next();
            aclsMap.put(aclType, HttpPoster.convertACL(document.getSecurityACL(aclType), authorityNameString, activities));
            denyAclsMap.put(aclType, HttpPoster.convertACL(document.getSecurityDenyACL(aclType), authorityNameString, activities));
            if (aclType.equals("document") || aclType.equals("share") || aclType.startsWith("parent")) continue;
            activities.recordActivity(null, "document ingest", null, documentURI, "UNKNOWNSECURITY", "Solr connector rejected document that has security info which Solr does not recognize: '" + aclType + "'");
            return false;
        }
        try {
            IngestThread t = new IngestThread(documentURI, document, arguments, aclsMap, denyAclsMap);
            try {
                t.start();
                t.finishUp();
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document ingest", t.getActivityBytes(), documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                return t.getRval();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
            }
            catch (SolrServerException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document ingest", t.getActivityBytes(), documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
            catch (SolrException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document ingest", t.getActivityBytes(), documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document ingest", t.getActivityBytes(), documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
            catch (IOException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document ingest", t.getActivityBytes(), documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
        }
        catch (SolrServerException e) {
            HttpPoster.handleSolrServerException(e, "indexing " + documentURI);
            return false;
        }
        catch (SolrException e) {
            HttpPoster.handleSolrException(e, "indexing " + documentURI);
            return false;
        }
        catch (RuntimeException e) {
            HttpPoster.handleRuntimeException(e, "indexing " + documentURI);
            return false;
        }
        catch (IOException ioe) {
            HttpPoster.handleIOException(ioe, "indexing " + documentURI);
            return false;
        }
    }

    public void checkPost() throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)"checkPost()");
        }
        try {
            StatusThread t = new StatusThread();
            try {
                t.start();
                t.finishUp();
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
            }
        }
        catch (SolrServerException e) {
            HttpPoster.handleSolrServerException(e, "check");
            return;
        }
        catch (SolrException e) {
            HttpPoster.handleSolrException(e, "check");
            return;
        }
        catch (RuntimeException e) {
            HttpPoster.handleRuntimeException(e, "check");
            return;
        }
        catch (IOException ioe) {
            HttpPoster.handleIOException(ioe, "check");
            return;
        }
    }

    public void deletePost(String documentURI, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("deletePost(): '" + documentURI + "'"));
        }
        try {
            DeleteThread t = new DeleteThread(documentURI);
            try {
                t.start();
                t.finishUp();
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document deletion", null, documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
            }
            catch (SolrServerException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document deletion", null, documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
            catch (SolrException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document deletion", null, documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document deletion", null, documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
            catch (IOException e) {
                if (t.getActivityCode() != null) {
                    activities.recordActivity(t.getActivityStart(), "document deletion", null, documentURI, t.getActivityCode(), t.getActivityDetails());
                }
                throw e;
            }
        }
        catch (SolrServerException e) {
            HttpPoster.handleSolrServerException(e, "delete");
            return;
        }
        catch (SolrException e) {
            HttpPoster.handleSolrException(e, "delete");
            return;
        }
        catch (RuntimeException e) {
            HttpPoster.handleRuntimeException(e, "delete");
            return;
        }
        catch (IOException ioe) {
            HttpPoster.handleIOException(ioe, "delete");
            return;
        }
    }

    public static boolean checkMimeTypeIndexable(String mimeType, boolean useExtractUpdateHandler, Set<String> includedMimeTypes, Set<String> excludedMimeTypes) {
        String lowerMimeType;
        String string = lowerMimeType = mimeType == null ? null : mimeType.toLowerCase(Locale.ROOT);
        if (useExtractUpdateHandler) {
            int index = lowerMimeType == null ? -1 : lowerMimeType.indexOf(";");
            String checkMimeType = index != -1 ? lowerMimeType.substring(0, index) : lowerMimeType;
            if (includedMimeTypes != null && !includedMimeTypes.contains(checkMimeType)) {
                return false;
            }
            return excludedMimeTypes == null || !excludedMimeTypes.contains(checkMimeType);
        }
        return acceptableMimeTypes.contains(lowerMimeType);
    }

    protected static String[] convertACL(String[] acl, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException {
        if (acl != null) {
            String[] rval = new String[acl.length];
            for (int i = 0; i < rval.length; ++i) {
                rval[i] = activities.qualifyAccessToken(authorityNameString, acl[i]);
            }
            return rval;
        }
        return new String[0];
    }

    protected static void writeField(ModifiableSolrParams out, String fieldName, String[] fieldValues) {
        out.add(fieldName, fieldValues);
    }

    protected static void writeField(ModifiableSolrParams out, String fieldName, List<String> fieldValues) {
        String[] values = new String[fieldValues.size()];
        int i = 0;
        for (String fieldValue : fieldValues) {
            values[i++] = fieldValue;
        }
        HttpPoster.writeField(out, fieldName, values);
    }

    protected static void writeField(ModifiableSolrParams out, String fieldName, String fieldValue) {
        out.add(fieldName, new String[]{fieldValue});
    }

    protected void writeACLs(ModifiableSolrParams out, String aclType, String[] acl, String[] denyAcl) {
        String metadataACLName = LITERAL + this.allowAttributeName + aclType;
        for (int i = 0; i < acl.length; ++i) {
            HttpPoster.writeField(out, metadataACLName, acl[i]);
        }
        String metadataDenyACLName = LITERAL + this.denyAttributeName + aclType;
        for (int i = 0; i < denyAcl.length; ++i) {
            HttpPoster.writeField(out, metadataDenyACLName, denyAcl[i]);
        }
    }

    protected void writeACLsInSolrDoc(SolrInputDocument inputDoc, String aclType, String[] acl, String[] denyAcl) {
        String metadataACLName = this.allowAttributeName + aclType;
        inputDoc.addField(metadataACLName, (Object)acl);
        String metadataDenyACLName = this.denyAttributeName + aclType;
        inputDoc.addField(metadataDenyACLName, (Object)denyAcl);
    }

    protected static String makeSafeLuceneField(String inputField) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int i = 0; i < inputField.length(); ++i) {
            char x = inputField.charAt(i);
            if (isFirst && !Character.isJavaIdentifierStart(x) || !isFirst && !Character.isJavaIdentifierPart(x)) {
                if (!(isFirst || x != '.' && x != '-')) {
                    sb.append(x);
                } else {
                    sb.append('_');
                }
            } else if (isFirst && x == '$') {
                sb.append('_');
            } else {
                sb.append(x);
            }
            isFirst = false;
        }
        return sb.toString();
    }

    static {
        acceptableMimeTypes.add("text/plain;charset=utf-8");
        acceptableMimeTypes.add("text/plain;charset=ascii");
        acceptableMimeTypes.add("text/plain;charset=us-ascii");
        acceptableMimeTypes.add("text/plain; charset=utf-8");
        acceptableMimeTypes.add("text/plain; charset=ascii");
        acceptableMimeTypes.add("text/plain; charset=us-ascii");
        acceptableMimeTypes.add("text/plain");
    }

    protected static class SolrPing
    extends SolrRequest {
        private ModifiableSolrParams params = new ModifiableSolrParams();

        public SolrPing() {
            super(SolrRequest.METHOD.GET, "/admin/ping");
        }

        public SolrPing(String url) {
            super(SolrRequest.METHOD.GET, url);
        }

        public Collection<ContentStream> getContentStreams() {
            return null;
        }

        protected SolrPingResponse createResponse(SolrClient client) {
            return new SolrPingResponse();
        }

        public ModifiableSolrParams getParams() {
            return this.params;
        }

        public SolrPing removeAction() {
            this.params.remove("action");
            return this;
        }

        public SolrPing setActionDisable() {
            this.params.set("action", new String[]{"disable"});
            return this;
        }

        public SolrPing setActionEnable() {
            this.params.set("action", new String[]{"enable"});
            return this;
        }

        public SolrPing setActionPing() {
            this.params.set("action", new String[]{"ping"});
            return this;
        }
    }

    protected static class RepositoryDocumentStream
    extends ContentStreamBase {
        protected final InputStream is;
        protected final long length;
        protected final String contentType;
        protected final String contentName;

        public RepositoryDocumentStream(InputStream is, long length, String contentType, String contentName) {
            this.is = is;
            this.length = length;
            this.contentType = contentType;
            this.contentName = contentName;
        }

        public Long getSize() {
            return new Long(this.length);
        }

        public InputStream getStream() throws IOException {
            return this.is;
        }

        public Reader getReader() throws IOException {
            return null;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.contentName;
        }
    }

    protected class StatusThread
    extends Thread {
        protected Throwable exception = null;

        public StatusThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                try {
                    SolrResponse solrResponse = new SolrPing(HttpPoster.this.postStatusAction).process(HttpPoster.this.solrServer);
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error checking status: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, SolrServerException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SolrServerException) {
                    throw (SolrServerException)thr;
                }
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }

    protected class CommitThread
    extends Thread {
        protected Throwable exception = null;

        public CommitThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                try {
                    UpdateRequest updateRequest = new UpdateRequest(HttpPoster.this.postUpdateAction + "?commit=true");
                    UpdateResponse updateResponse = (UpdateResponse)updateRequest.process(HttpPoster.this.solrServer);
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error committing: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, SolrServerException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SolrServerException) {
                    throw (SolrServerException)thr;
                }
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }

    protected class DeleteThread
    extends Thread {
        protected String documentURI;
        protected Long activityStart = null;
        protected String activityCode = null;
        protected String activityDetails = null;
        protected Throwable exception = null;

        public DeleteThread(String documentURI) {
            this.setDaemon(true);
            this.documentURI = documentURI;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                long fullStartTime = System.currentTimeMillis();
                try {
                    UpdateResponse response = (UpdateResponse)new UpdateRequest(HttpPoster.this.postRemoveAction).deleteById(this.documentURI).process(HttpPoster.this.solrServer);
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = "OK";
                    this.activityDetails = null;
                    return;
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (SolrServerException e) {
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    this.activityDetails = e.getMessage() + (e.getCause() != null ? ": " + e.getCause().getMessage() : "");
                    throw e;
                }
                catch (SolrException e) {
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    this.activityDetails = e.getMessage() + (e.getCause() != null ? ": " + e.getCause().getMessage() : "");
                    throw e;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error deleting document: " + ioe.getMessage()), (Throwable)ioe);
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = ioe.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    this.activityDetails = ioe.getMessage();
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public void finishUp() throws InterruptedException, SolrServerException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SolrServerException) {
                    throw (SolrServerException)thr;
                }
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }

        public Long getActivityStart() {
            return this.activityStart;
        }

        public String getActivityCode() {
            return this.activityCode;
        }

        public String getActivityDetails() {
            return this.activityDetails;
        }
    }

    protected class IngestThread
    extends Thread {
        protected final String documentURI;
        protected final RepositoryDocument document;
        protected final Map<String, List<String>> arguments;
        protected final Map<String, String[]> aclsMap;
        protected final Map<String, String[]> denyAclsMap;
        protected Long activityStart = null;
        protected Long activityBytes = null;
        protected String activityCode = null;
        protected String activityDetails = null;
        protected Throwable exception = null;
        protected boolean readFromDocumentStreamYet = false;
        protected boolean rval = false;

        public IngestThread(String documentURI, RepositoryDocument document, Map<String, List<String>> arguments, Map<String, String[]> aclsMap, Map<String, String[]> denyAclsMap) {
            this.setDaemon(true);
            this.documentURI = documentURI;
            this.document = document;
            this.arguments = arguments;
            this.aclsMap = aclsMap;
            this.denyAclsMap = denyAclsMap;
        }

        @Override
        public void run() {
            long length = this.document.getBinaryLength();
            InputStream is = this.document.getBinaryStream();
            String contentType = this.document.getMimeType();
            String contentName = this.document.getFileName();
            try {
                long fullStartTime = System.currentTimeMillis();
                try {
                    SolrInputDocument currentSolrDoc = new SolrInputDocument(new String[0]);
                    ContentStreamUpdateRequest contentStreamUpdateRequest = new ContentStreamUpdateRequest(HttpPoster.this.postUpdateAction);
                    if (HttpPoster.this.useExtractUpdateHandler) {
                        this.buildExtractUpdateHandlerRequest(length, is, contentType, contentName == null || contentName.length() == 0 ? "docname" : contentName, contentStreamUpdateRequest);
                    } else {
                        currentSolrDoc = this.buildSolrDocument(length, is);
                    }
                    try {
                        this.readFromDocumentStreamYet = true;
                        if (HttpPoster.this.useExtractUpdateHandler) {
                            UpdateResponse response = (UpdateResponse)contentStreamUpdateRequest.process(HttpPoster.this.solrServer);
                        } else {
                            ModifiableSolrParams params = new ModifiableSolrParams();
                            for (String name : this.arguments.keySet()) {
                                List<String> values = this.arguments.get(name);
                                HttpPoster.writeField(params, name, values);
                            }
                            UpdateRequest req = new UpdateRequest();
                            req.setParams(params);
                            req.add(currentSolrDoc);
                            if (HttpPoster.this.commitWithin != null) {
                                req.setCommitWithin(Integer.parseInt(HttpPoster.this.commitWithin));
                            }
                            UpdateResponse response = (UpdateResponse)req.process(HttpPoster.this.solrServer);
                        }
                        this.activityStart = new Long(fullStartTime);
                        this.activityBytes = new Long(length);
                        this.activityCode = "OK";
                        this.activityDetails = null;
                        this.rval = true;
                        return;
                    }
                    catch (SolrServerException e) {
                        this.activityStart = new Long(fullStartTime);
                        this.activityBytes = new Long(length);
                        this.activityDetails = e.getMessage() + (e.getCause() != null ? ": " + e.getCause().getMessage() : "");
                        this.activityCode = e.getCause() != null && e.getCause().getClass().getName().equals("java.net.SocketException") && (this.activityDetails.toLowerCase(Locale.ROOT).indexOf("broken pipe") != -1 || this.activityDetails.toLowerCase(Locale.ROOT).indexOf("connection reset") != -1 || this.activityDetails.toLowerCase(Locale.ROOT).indexOf("target server failed to respond") != -1) ? "SOLRREJECT" : ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                        throw e;
                    }
                    catch (SolrException e) {
                        this.activityStart = new Long(fullStartTime);
                        this.activityBytes = new Long(length);
                        this.activityCode = Integer.toString(e.code());
                        this.activityDetails = e.getMessage() + (e.getCause() != null ? ": " + e.getCause().getMessage() : "");
                        throw e;
                    }
                }
                catch (IOException ioe) {
                    if (ioe instanceof InterruptedIOException && !(ioe instanceof SocketTimeoutException)) {
                        return;
                    }
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = ioe.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    this.activityDetails = ioe.getMessage();
                    Logging.ingest.warn((Object)("Error indexing into Solr: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        private SolrInputDocument buildSolrDocument(long length, InputStream is) throws IOException {
            String mimeType;
            String fileName;
            Date date;
            Long size;
            SolrInputDocument outputDoc = new SolrInputDocument(new String[0]);
            outputDoc.addField(HttpPoster.this.idAttributeName, (Object)this.documentURI);
            if (HttpPoster.this.contentAttributeName != null) {
                int amt;
                InputStreamReader r = new InputStreamReader(is, Consts.UTF_8);
                StringBuilder sb = new StringBuilder((int)length);
                char[] buffer = new char[65536];
                while ((amt = ((Reader)r).read(buffer, 0, buffer.length)) != -1) {
                    sb.append(buffer, 0, amt);
                }
                outputDoc.addField(HttpPoster.this.contentAttributeName, (Object)sb.toString());
            }
            if (HttpPoster.this.originalSizeAttributeName != null && (size = this.document.getOriginalSize()) != null) {
                outputDoc.addField(HttpPoster.this.originalSizeAttributeName, (Object)size.toString());
            }
            if (HttpPoster.this.modifiedDateAttributeName != null && (date = this.document.getModifiedDate()) != null) {
                outputDoc.addField(HttpPoster.this.modifiedDateAttributeName, (Object)DateParser.formatISO8601Date((Date)date));
            }
            if (HttpPoster.this.createdDateAttributeName != null && (date = this.document.getCreatedDate()) != null) {
                outputDoc.addField(HttpPoster.this.createdDateAttributeName, (Object)DateParser.formatISO8601Date((Date)date));
            }
            if (HttpPoster.this.indexedDateAttributeName != null && (date = this.document.getIndexingDate()) != null) {
                outputDoc.addField(HttpPoster.this.indexedDateAttributeName, (Object)DateParser.formatISO8601Date((Date)date));
            }
            if (HttpPoster.this.fileNameAttributeName != null && !StringUtils.isBlank((String)(fileName = this.document.getFileName()))) {
                outputDoc.addField(HttpPoster.this.fileNameAttributeName, (Object)fileName);
            }
            if (HttpPoster.this.mimeTypeAttributeName != null && !StringUtils.isBlank((String)(mimeType = this.document.getMimeType()))) {
                outputDoc.addField(HttpPoster.this.mimeTypeAttributeName, (Object)mimeType);
            }
            for (String aclType : this.aclsMap.keySet()) {
                HttpPoster.this.writeACLsInSolrDoc(outputDoc, aclType, this.aclsMap.get(aclType), this.denyAclsMap.get(aclType));
            }
            this.buildSolrParamsFromMetadata(outputDoc);
            return outputDoc;
        }

        private void buildExtractUpdateHandlerRequest(long length, InputStream is, String contentType, String contentName, ContentStreamUpdateRequest contentStreamUpdateRequest) throws IOException {
            String mimeType;
            String fileName;
            Date date;
            Long size;
            ModifiableSolrParams out = new ModifiableSolrParams();
            Logging.ingest.debug((Object)("Solr: Writing document '" + this.documentURI));
            HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.idAttributeName, this.documentURI);
            if (HttpPoster.this.originalSizeAttributeName != null && (size = this.document.getOriginalSize()) != null) {
                HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.originalSizeAttributeName, size.toString());
            }
            if (HttpPoster.this.modifiedDateAttributeName != null && (date = this.document.getModifiedDate()) != null) {
                HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.modifiedDateAttributeName, DateParser.formatISO8601Date((Date)date));
            }
            if (HttpPoster.this.createdDateAttributeName != null && (date = this.document.getCreatedDate()) != null) {
                HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.createdDateAttributeName, DateParser.formatISO8601Date((Date)date));
            }
            if (HttpPoster.this.indexedDateAttributeName != null && (date = this.document.getIndexingDate()) != null) {
                HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.indexedDateAttributeName, DateParser.formatISO8601Date((Date)date));
            }
            if (HttpPoster.this.fileNameAttributeName != null && !StringUtils.isBlank((String)(fileName = this.document.getFileName()))) {
                HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.fileNameAttributeName, fileName);
            }
            if (HttpPoster.this.mimeTypeAttributeName != null && !StringUtils.isBlank((String)(mimeType = this.document.getMimeType()))) {
                HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.mimeTypeAttributeName, mimeType);
            }
            for (String aclType : this.aclsMap.keySet()) {
                HttpPoster.this.writeACLs(out, aclType, this.aclsMap.get(aclType), this.denyAclsMap.get(aclType));
            }
            for (String name : this.arguments.keySet()) {
                List<String> values = this.arguments.get(name);
                HttpPoster.writeField(out, name, values);
            }
            this.buildSolrParamsFromMetadata(out);
            if (!StringUtils.isBlank((String)this.document.getFileName())) {
                HttpPoster.writeField(out, "resource.name", this.document.getFileName());
            }
            if (HttpPoster.this.commitWithin != null) {
                HttpPoster.writeField(out, HttpPoster.COMMITWITHIN_METADATA, HttpPoster.this.commitWithin);
            }
            contentStreamUpdateRequest.setParams(out);
            contentStreamUpdateRequest.addContentStream((ContentStream)new RepositoryDocumentStream(is, length, contentType, contentName));
            Logging.ingest.debug((Object)("Solr: Done writing '" + this.documentURI + "'"));
        }

        private void buildSolrParamsFromMetadata(ModifiableSolrParams out) throws IOException {
            Iterator iter = this.document.getFields();
            while (iter.hasNext()) {
                String originalFieldName = (String)iter.next();
                String fieldName = HttpPoster.makeSafeLuceneField(originalFieldName);
                Logging.ingest.debug((Object)("Solr: Saw field '" + originalFieldName + "'; converted to '" + fieldName + "'"));
                this.applySingleMapping(originalFieldName, out, fieldName);
            }
        }

        private void buildSolrParamsFromMetadata(SolrInputDocument outputDocument) throws IOException {
            Iterator iter = this.document.getFields();
            while (iter.hasNext()) {
                String originalFieldName = (String)iter.next();
                String fieldName = HttpPoster.makeSafeLuceneField(originalFieldName);
                this.applySingleMapping(originalFieldName, outputDocument, fieldName);
            }
        }

        private void applySingleMapping(String originalFieldName, ModifiableSolrParams out, String newFieldName) throws IOException {
            if (newFieldName != null && !newFieldName.isEmpty()) {
                if (newFieldName.toLowerCase(Locale.ROOT).equals(HttpPoster.this.idAttributeName.toLowerCase(Locale.ROOT))) {
                    newFieldName = HttpPoster.ID_METADATA;
                }
                String[] values = this.document.getFieldAsStrings(originalFieldName);
                HttpPoster.writeField(out, HttpPoster.LITERAL + newFieldName, values);
            }
        }

        private void applySingleMapping(String originalFieldName, SolrInputDocument outputDocument, String newFieldName) throws IOException {
            if (newFieldName != null && !newFieldName.isEmpty()) {
                if (newFieldName.toLowerCase(Locale.ROOT).equals(HttpPoster.this.idAttributeName.toLowerCase(Locale.ROOT))) {
                    newFieldName = HttpPoster.ID_METADATA;
                }
                String[] values = this.document.getFieldAsStrings(originalFieldName);
                outputDocument.addField(newFieldName, (Object)values);
            }
        }

        public void finishUp() throws InterruptedException, SolrServerException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof SolrServerException) {
                    throw (SolrServerException)thr;
                }
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }

        public Long getActivityStart() {
            return this.activityStart;
        }

        public Long getActivityBytes() {
            return this.activityBytes;
        }

        public String getActivityCode() {
            return this.activityCode;
        }

        public String getActivityDetails() {
            return this.activityDetails;
        }

        public boolean getReadFromDocumentStreamYet() {
            return this.readFromDocumentStreamYet;
        }

        public boolean getRval() {
            return this.rval;
        }
    }
}

