/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.JoinClause;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.system.Logging;

public class IntrinsicLink
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: IntrinsicLink.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final int LINKSTATUS_BASE = 0;
    protected static final int LINKSTATUS_NEW = 1;
    protected static final int LINKSTATUS_EXISTING = 2;
    public static final String jobIDField = "jobid";
    public static final String linkTypeField = "linktype";
    public static final String parentIDHashField = "parentidhash";
    public static final String childIDHashField = "childidhash";
    public static final String newField = "isnew";
    public static final String processIDField = "processid";
    protected static Map linkstatusMap = new HashMap();

    public IntrinsicLink(IDBInterface database) throws ManifoldCFException {
        super(database, "intrinsiclink");
    }

    public void install(String jobsTable, String jobsColumn) throws ManifoldCFException {
        block7: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(jobIDField, new ColumnDescription("BIGINT", false, false, jobsTable, jobsColumn, false));
                map.put(linkTypeField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(parentIDHashField, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(childIDHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                map.put(newField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                map.put(processIDField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription uniqueIndex = new IndexDescription(true, new String[]{jobIDField, parentIDHashField, linkTypeField, childIDHashField});
            IndexDescription jobChildNewIndex = new IndexDescription(false, new String[]{jobIDField, childIDHashField, newField});
            IndexDescription newIndex = new IndexDescription(false, new String[]{newField, processIDField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (uniqueIndex != null && id.equals((Object)uniqueIndex)) {
                    uniqueIndex = null;
                    continue;
                }
                if (jobChildNewIndex != null && id.equals((Object)jobChildNewIndex)) {
                    jobChildNewIndex = null;
                    continue;
                }
                if (newIndex != null && id.equals((Object)newIndex)) {
                    newIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (jobChildNewIndex != null) {
                this.performAddIndex(null, jobChildNewIndex);
            }
            if (newIndex != null) {
                this.performAddIndex(null, newIndex);
            }
            if (uniqueIndex == null) break block7;
            this.performAddIndex(null, uniqueIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void analyzeTables() throws ManifoldCFException {
        long startTime = System.currentTimeMillis();
        Logging.perf.debug((Object)"Beginning to analyze intrinsiclink table");
        this.analyzeTable();
        Logging.perf.debug((Object)("Done analyzing intrinsiclink table in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
    }

    public void deleteOwner(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
        this.performDelete("WHERE " + query, list, null);
        this.noteModifications(0, 0, 1);
    }

    public void restart(String processID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(newField, IntrinsicLink.statusToString(0));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(newField, new Object[]{IntrinsicLink.statusToString(1), IntrinsicLink.statusToString(2)}), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void restart() throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(newField, IntrinsicLink.statusToString(0));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(newField, new Object[]{IntrinsicLink.statusToString(1), IntrinsicLink.statusToString(2)})});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void restartCluster() throws ManifoldCFException {
    }

    public String[] recordReferences(Long jobID, String sourceDocumentIDHash, String[] targetDocumentIDHashes, String linkType, String processID) throws ManifoldCFException {
        HashSet<String> duplicateRemoval = new HashSet<String>();
        int maxClause = this.maxClausePerformExistsCheck(jobID, linkType, sourceDocumentIDHash);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        HashSet<String> presentMap = new HashSet<String>();
        for (String targetDocumentIDHash : targetDocumentIDHashes) {
            if (duplicateRemoval.contains(targetDocumentIDHash)) continue;
            duplicateRemoval.add(targetDocumentIDHash);
            if (i == maxClause) {
                this.performExistsCheck(presentMap, jobID, linkType, sourceDocumentIDHash, list);
                i = 0;
                list.clear();
            }
            list.add(targetDocumentIDHash);
            ++i;
        }
        if (i > 0) {
            this.performExistsCheck(presentMap, jobID, linkType, sourceDocumentIDHash, list);
        }
        int count = 0;
        for (String targetDocumentIDHash : duplicateRemoval) {
            if (presentMap.contains(targetDocumentIDHash)) continue;
            ++count;
        }
        String[] newReferences = new String[count];
        int j = 0;
        for (String targetDocumentIDHash : duplicateRemoval) {
            HashMap<String, Object> map;
            if (!presentMap.contains(targetDocumentIDHash)) {
                newReferences[j++] = targetDocumentIDHash;
                map = new HashMap();
                map.put(jobIDField, jobID);
                map.put(parentIDHashField, targetDocumentIDHash);
                map.put(childIDHashField, sourceDocumentIDHash);
                map.put(linkTypeField, linkType);
                map.put(newField, IntrinsicLink.statusToString(1));
                map.put(processIDField, processID);
                this.performInsert(map, null);
                this.noteModifications(1, 0, 0);
                continue;
            }
            map = new HashMap<String, Object>();
            map.put(newField, IntrinsicLink.statusToString(2));
            map.put(processIDField, processID);
            ArrayList updateList = new ArrayList();
            String query = this.buildConjunctionClause(updateList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(parentIDHashField, (Object)targetDocumentIDHash), new UnitaryClause(linkTypeField, (Object)linkType), new UnitaryClause(childIDHashField, (Object)sourceDocumentIDHash)});
            this.performUpdate(map, "WHERE " + query, updateList, null);
            this.noteModifications(0, 1, 0);
        }
        return newReferences;
    }

    protected int maxClausePerformExistsCheck(Long jobID, String linkType, String childIDHash) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(linkTypeField, (Object)linkType), new UnitaryClause(childIDHashField, (Object)childIDHash)});
    }

    protected void performExistsCheck(Set<String> presentMap, Long jobID, String linkType, String childIDHash, List<String> list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, list), new UnitaryClause(linkTypeField, (Object)linkType), new UnitaryClause(childIDHashField, (Object)childIDHash)});
        IResultSet result = this.performQuery("SELECT parentidhash FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", newList, null, null);
        for (int i = 0; i < result.getRowCount(); ++i) {
            IResultRow row = result.getRow(i);
            String parentIDHash = (String)row.getValue(parentIDHashField);
            presentMap.add(parentIDHash);
        }
    }

    public void removeDocumentLinks(Long jobID, String joinTableName, String joinTableIDColumn, String joinTableJobColumn, String joinTableCriteria, ArrayList joinTableParams) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList list = new ArrayList();
        sb.append("EXISTS(SELECT 'x' FROM ").append(joinTableName).append(" WHERE ").append(this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(joinTableJobColumn, (Object)jobID), new JoinClause(joinTableIDColumn, this.getTableName() + "." + childIDHashField)})).append(" AND ");
        sb.append(joinTableCriteria);
        list.addAll(joinTableParams);
        sb.append(")");
        this.performDelete(sb.toString(), list, null);
        this.noteModifications(0, 0, 1);
    }

    public void removeDocumentLinks(Long jobID, String[] documentIDHashes) throws ManifoldCFException {
        int maxClause = this.maxClausePerformRemoveDocumentLinks(jobID);
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (String documentIDHash : documentIDHashes) {
            if (k == maxClause) {
                this.performRemoveDocumentLinks(list, jobID);
                list.clear();
                k = 0;
            }
            list.add(documentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performRemoveDocumentLinks(list, jobID);
        }
        this.noteModifications(0, 0, documentIDHashes.length);
    }

    protected int maxClausePerformRemoveDocumentLinks(Long jobID) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
    }

    protected void performRemoveDocumentLinks(List<String> list, Long jobID) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList thisList = new ArrayList();
        sb.append(this.buildConjunctionClause(thisList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(childIDHashField, list)}));
        this.performDelete(sb.toString(), thisList, null);
    }

    public void removeLinks(Long jobID, String commonNewExpression, ArrayList commonNewParams, String[] sourceDocumentIDHashes) throws ManifoldCFException {
        int maxClause = this.maxClausePerformRemoveLinks(jobID);
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (String sourceDocumentIDHash : sourceDocumentIDHashes) {
            if (k == maxClause) {
                this.performRemoveLinks(list, jobID, commonNewExpression, commonNewParams);
                list.clear();
                k = 0;
            }
            list.add(sourceDocumentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performRemoveLinks(list, jobID, commonNewExpression, commonNewParams);
        }
        this.noteModifications(0, 0, sourceDocumentIDHashes.length);
    }

    protected int maxClausePerformRemoveLinks(Long jobID) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
    }

    protected void performRemoveLinks(List<String> list, Long jobID, String commonNewExpression, ArrayList commonNewParams) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList thisList = new ArrayList();
        sb.append(this.buildConjunctionClause(thisList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(childIDHashField, list)}));
        if (commonNewExpression != null) {
            sb.append(" AND ").append(commonNewExpression);
            thisList.addAll(commonNewParams);
        }
        this.performDelete(sb.toString(), thisList, null);
    }

    public void restoreLinks(Long jobID, String[] sourceDocumentIDHashes) throws ManifoldCFException {
        int maxClause = this.maxClausesPerformRestoreLinks(jobID);
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (String sourceDocumentIDHash : sourceDocumentIDHashes) {
            if (k == maxClause) {
                this.performRestoreLinks(jobID, list);
                list.clear();
                k = 0;
            }
            list.add(sourceDocumentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performRestoreLinks(jobID, list);
        }
        this.noteModifications(0, sourceDocumentIDHashes.length, 0);
    }

    protected int maxClausesPerformRestoreLinks(Long jobID) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
    }

    protected void performRestoreLinks(Long jobID, List<String> list) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(newField, IntrinsicLink.statusToString(0));
        map.put(processIDField, null);
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList<String> newList = new ArrayList<String>();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(childIDHashField, list)})).append(" AND ").append(newField).append(" IN (?,?)");
        newList.add(IntrinsicLink.statusToString(2));
        newList.add(IntrinsicLink.statusToString(1));
        this.performUpdate(map, sb.toString(), newList, null);
    }

    public void revertLinks(Long jobID, String[] sourceDocumentIDHashes) throws ManifoldCFException {
        int maxClause = this.maxClausesPerformRevertLinks(jobID);
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (String sourceDocumentIDHash : sourceDocumentIDHashes) {
            if (k == maxClause) {
                this.performRevertLinks(jobID, list);
                list.clear();
                k = 0;
            }
            list.add(sourceDocumentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performRevertLinks(jobID, list);
        }
        this.noteModifications(0, sourceDocumentIDHashes.length, 0);
    }

    protected int maxClausesPerformRevertLinks(Long jobID) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
    }

    protected void performRevertLinks(Long jobID, List<String> list) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList<String> newList = new ArrayList<String>();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(childIDHashField, list)})).append(" AND ").append(newField).append("=?");
        newList.add(IntrinsicLink.statusToString(1));
        this.performDelete(sb.toString(), newList, null);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(newField, IntrinsicLink.statusToString(0));
        map.put(processIDField, null);
        sb = new StringBuilder();
        newList.clear();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(childIDHashField, list)})).append(" AND ").append(newField).append("=?");
        newList.add(IntrinsicLink.statusToString(2));
        this.performUpdate(map, sb.toString(), newList, null);
    }

    public IResultSet getDocumentChildren(Long jobID, String parentIDHash) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(parentIDHashField, (Object)parentIDHash)});
        return this.performQuery("SELECT linktype AS linktype,childidhash AS childidentifier FROM " + this.getTableName() + " WHERE " + query, list, null, null);
    }

    public String[] getDocumentUniqueParents(Long jobID, String childIDHash) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(childIDHashField, (Object)childIDHash)});
        IResultSet set = this.performQuery("SELECT DISTINCT parentidhash FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(parentIDHashField);
        }
        return rval;
    }

    public static int stringToStatus(String status) {
        Integer value = (Integer)linkstatusMap.get(status);
        return value;
    }

    public static String statusToString(int status) {
        switch (status) {
            case 0: {
                return "B";
            }
            case 1: {
                return "N";
            }
            case 2: {
                return "E";
            }
        }
        return null;
    }

    static {
        linkstatusMap.put("B", new Integer(0));
        linkstatusMap.put("N", new Integer(1));
        linkstatusMap.put("E", new Integer(2));
    }

    protected static class DuplicateFinder
    implements ILimitChecker {
        protected Long prevJobID = null;
        protected String prevLinkType = null;
        protected String prevParentIDHash = null;
        protected String prevChildIDHash = null;

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            DuplicateFinder df = new DuplicateFinder();
            df.prevJobID = this.prevJobID;
            df.prevLinkType = this.prevLinkType;
            df.prevParentIDHash = this.prevParentIDHash;
            df.prevChildIDHash = this.prevChildIDHash;
            return df;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            String childIDHash;
            Long jobID = (Long)row.getValue(IntrinsicLink.jobIDField);
            String linkType = (String)row.getValue(IntrinsicLink.linkTypeField);
            String parentIDHash = (String)row.getValue(IntrinsicLink.parentIDHashField);
            if (parentIDHash == null) {
                parentIDHash = "";
            }
            if ((childIDHash = (String)row.getValue(IntrinsicLink.childIDHashField)) == null) {
                childIDHash = "";
            }
            if (this.prevJobID != null && jobID.equals(this.prevJobID) && linkType.equals(this.prevLinkType) && parentIDHash.equals(this.prevParentIDHash) && childIDHash.equals(this.prevChildIDHash)) {
                return true;
            }
            this.prevJobID = jobID;
            this.prevLinkType = linkType;
            this.prevParentIDHash = parentIDHash;
            this.prevChildIDHash = childIDHash;
            return false;
        }

        public boolean checkContinue() throws ManifoldCFException {
            return true;
        }
    }
}

