/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;

public class TermsBuilder
extends ValuesSourceAggregationBuilder<TermsBuilder> {
    private int size = -1;
    private int shardSize = -1;
    private long minDocCount = -1L;
    private Terms.ValueType valueType;
    private Terms.Order order;
    private String includePattern;
    private int includeFlags;
    private String excludePattern;
    private int excludeFlags;
    private String executionHint;

    public TermsBuilder(String name) {
        super(name, "terms");
    }

    public TermsBuilder size(int size) {
        this.size = size;
        return this;
    }

    public TermsBuilder shardSize(int shardSize) {
        this.shardSize = shardSize;
        return this;
    }

    public TermsBuilder minDocCount(long minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    public TermsBuilder include(String regex) {
        return this.include(regex, 0);
    }

    public TermsBuilder include(String regex, int flags) {
        this.includePattern = regex;
        this.includeFlags = flags;
        return this;
    }

    public TermsBuilder exclude(String regex) {
        return this.exclude(regex, 0);
    }

    public TermsBuilder exclude(String regex, int flags) {
        this.excludePattern = regex;
        this.excludeFlags = flags;
        return this;
    }

    public TermsBuilder valueType(Terms.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public TermsBuilder order(Terms.Order order) {
        this.order = order;
        return this;
    }

    public TermsBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    @Override
    protected XContentBuilder doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.size >= 0) {
            builder.field("size", this.size);
        }
        if (this.shardSize >= 0) {
            builder.field("shard_size", this.shardSize);
        }
        if (this.minDocCount >= 0L) {
            builder.field("min_doc_count", this.minDocCount);
        }
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.name().toLowerCase(Locale.ROOT));
        }
        if (this.order != null) {
            builder.field("order");
            this.order.toXContent(builder, params);
        }
        if (this.includePattern != null) {
            if (this.includeFlags == 0) {
                builder.field("include", this.includePattern);
            } else {
                builder.startObject("include").field("pattern", this.includePattern).field("flags", this.includeFlags).endObject();
            }
        }
        if (this.excludePattern != null) {
            if (this.excludeFlags == 0) {
                builder.field("exclude", this.excludePattern);
            } else {
                builder.startObject("exclude").field("pattern", this.excludePattern).field("flags", this.excludeFlags).endObject();
            }
        }
        if (this.executionHint != null) {
            builder.field("execution_hint", this.executionHint);
        }
        return builder;
    }
}

