/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cache.recycler;

import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.Recyclers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;

public class PageCacheRecycler
extends AbstractComponent {
    public static final String TYPE = "page.type";
    public static final String LIMIT_HEAP = "page.limit.heap";
    public static final String LIMIT_PER_THREAD = "page.limit.per_thread";
    public static final String WEIGHT = "page.weight";
    private final Recycler<byte[]> bytePage;
    private final Recycler<int[]> intPage;
    private final Recycler<long[]> longPage;
    private final Recycler<double[]> doublePage;
    private final Recycler<Object[]> objectPage;

    public void close() {
        this.bytePage.close();
        this.intPage.close();
        this.longPage.close();
        this.doublePage.close();
        this.objectPage.close();
    }

    private static int maximumSearchThreadPoolSize(ThreadPool threadPool, Settings settings) {
        ThreadPool.Info searchThreadPool = threadPool.info("search");
        assert (searchThreadPool != null);
        int maxSize = searchThreadPool.getMax();
        if (maxSize <= 0) {
            return 3 * EsExecutors.boundedNumberOfProcessors(settings);
        }
        return maxSize;
    }

    private static int maxCount(long limit, long pageSize, double weight, double totalWeight) {
        return (int)(weight / totalWeight * (double)limit / (double)pageSize);
    }

    @Inject
    public PageCacheRecycler(Settings settings, ThreadPool threadPool) {
        super(settings);
        Type type = Type.parse(this.componentSettings.get(TYPE));
        long limit = this.componentSettings.getAsMemory(LIMIT_HEAP, "10%").bytes();
        int availableProcessors = EsExecutors.boundedNumberOfProcessors(settings);
        int searchThreadPoolSize = PageCacheRecycler.maximumSearchThreadPoolSize(threadPool, settings);
        double bytesWeight = this.componentSettings.getAsDouble("page.weight.bytes", (Double)1.0);
        double intsWeight = this.componentSettings.getAsDouble("page.weight.ints", (Double)1.0);
        double longsWeight = this.componentSettings.getAsDouble("page.weight.longs", (Double)1.0);
        double doublesWeight = this.componentSettings.getAsDouble("page.weight.doubles", (Double)1.0);
        double objectsWeight = this.componentSettings.getAsDouble("page.weight.objects", (Double)0.1);
        double totalWeight = bytesWeight + intsWeight + longsWeight + doublesWeight + objectsWeight;
        this.bytePage = PageCacheRecycler.build(type, PageCacheRecycler.maxCount(limit, 16384L, bytesWeight, totalWeight), searchThreadPoolSize, availableProcessors, new Recycler.C<byte[]>(){

            @Override
            public byte[] newInstance(int sizing) {
                return new byte[16384];
            }

            @Override
            public void clear(byte[] value) {
            }
        });
        this.intPage = PageCacheRecycler.build(type, PageCacheRecycler.maxCount(limit, 4096L, intsWeight, totalWeight), searchThreadPoolSize, availableProcessors, new Recycler.C<int[]>(){

            @Override
            public int[] newInstance(int sizing) {
                return new int[4096];
            }

            @Override
            public void clear(int[] value) {
            }
        });
        this.longPage = PageCacheRecycler.build(type, PageCacheRecycler.maxCount(limit, 2048L, longsWeight, totalWeight), searchThreadPoolSize, availableProcessors, new Recycler.C<long[]>(){

            @Override
            public long[] newInstance(int sizing) {
                return new long[2048];
            }

            @Override
            public void clear(long[] value) {
            }
        });
        this.doublePage = PageCacheRecycler.build(type, PageCacheRecycler.maxCount(limit, 2048L, doublesWeight, totalWeight), searchThreadPoolSize, availableProcessors, new Recycler.C<double[]>(){

            @Override
            public double[] newInstance(int sizing) {
                return new double[2048];
            }

            @Override
            public void clear(double[] value) {
            }
        });
        this.objectPage = PageCacheRecycler.build(type, PageCacheRecycler.maxCount(limit, BigArrays.OBJECT_PAGE_SIZE, objectsWeight, totalWeight), searchThreadPoolSize, availableProcessors, new Recycler.C<Object[]>(){

            @Override
            public Object[] newInstance(int sizing) {
                return new Object[BigArrays.OBJECT_PAGE_SIZE];
            }

            @Override
            public void clear(Object[] value) {
                Arrays.fill(value, null);
            }
        });
    }

    public Recycler.V<byte[]> bytePage(boolean clear) {
        Recycler.V<byte[]> v = this.bytePage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), (byte)0);
        }
        return v;
    }

    public Recycler.V<int[]> intPage(boolean clear) {
        Recycler.V<int[]> v = this.intPage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), 0);
        }
        return v;
    }

    public Recycler.V<long[]> longPage(boolean clear) {
        Recycler.V<long[]> v = this.longPage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), 0L);
        }
        return v;
    }

    public Recycler.V<double[]> doublePage(boolean clear) {
        Recycler.V<double[]> v = this.doublePage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), 0.0);
        }
        return v;
    }

    public Recycler.V<Object[]> objectPage() {
        return this.objectPage.obtain();
    }

    private static <T> Recycler<T> build(Type type, int limit, int estimatedThreadPoolSize, int availableProcessors, Recycler.C<T> c) {
        Recycler<T> recycler = limit == 0 ? Recyclers.none(c) : type.build(c, limit, estimatedThreadPoolSize, availableProcessors);
        return recycler;
    }

    public static enum Type {
        SOFT_THREAD_LOCAL{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.threadLocal(Recyclers.softFactory(Recyclers.dequeFactory(c, limit / estimatedThreadPoolSize)));
            }
        }
        ,
        THREAD_LOCAL{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.threadLocal(Recyclers.dequeFactory(c, limit / estimatedThreadPoolSize));
            }
        }
        ,
        QUEUE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.concurrentDeque(c, limit);
            }
        }
        ,
        SOFT_CONCURRENT{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.concurrent(Recyclers.softFactory(Recyclers.dequeFactory(c, limit / availableProcessors)), availableProcessors);
            }
        }
        ,
        CONCURRENT{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.concurrent(Recyclers.dequeFactory(c, limit / availableProcessors), availableProcessors);
            }
        }
        ,
        NONE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.none(c);
            }
        };


        public static Type parse(String type) {
            if (Strings.isNullOrEmpty(type)) {
                return SOFT_CONCURRENT;
            }
            try {
                return Type.valueOf(type.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new ElasticsearchIllegalArgumentException("no type support [" + type + "]");
            }
        }

        abstract <T> Recycler<T> build(Recycler.C<T> var1, int var2, int var3, int var4);
    }
}

