/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;

public class UpdateRequest
extends InstanceShardOperationRequest<UpdateRequest> {
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    String script;
    @Nullable
    String scriptLang;
    @Nullable
    Map<String, Object> scriptParams;
    private String[] fields;
    private long version = 0L;
    private VersionType versionType = VersionType.INTERNAL;
    private int retryOnConflict = 0;
    private boolean refresh = false;
    private ReplicationType replicationType = ReplicationType.DEFAULT;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;
    private IndexRequest upsertRequest;
    private boolean docAsUpsert = false;
    @Nullable
    private IndexRequest doc;

    public UpdateRequest() {
    }

    public UpdateRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (this.version != 0L && this.retryOnConflict > 0) {
            validationException = ValidateActions.addValidationError("can't provide both retry_on_conflict and a specific version", validationException);
        }
        if (this.script == null && this.doc == null) {
            validationException = ValidateActions.addValidationError("script or doc is missing", validationException);
        }
        if (this.script != null && this.doc != null) {
            validationException = ValidateActions.addValidationError("can't provide both script and doc", validationException);
        }
        if (this.doc == null && this.docAsUpsert) {
            validationException = ValidateActions.addValidationError("doc must be specified if doc_as_upsert is enabled", validationException);
        }
        return validationException;
    }

    public String type() {
        return this.type;
    }

    public UpdateRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public UpdateRequest id(String id) {
        this.id = id;
        return this;
    }

    public UpdateRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    public UpdateRequest parent(String parent) {
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public String routing() {
        return this.routing;
    }

    int shardId() {
        return this.shardId;
    }

    public String script() {
        return this.script;
    }

    public Map<String, Object> scriptParams() {
        return this.scriptParams;
    }

    public UpdateRequest script(String script) {
        this.script = script;
        return this;
    }

    public UpdateRequest scriptLang(String scriptLang) {
        this.scriptLang = scriptLang;
        return this;
    }

    public String scriptLang() {
        return this.scriptLang;
    }

    public UpdateRequest addScriptParam(String name, Object value) {
        if (this.scriptParams == null) {
            this.scriptParams = Maps.newHashMap();
        }
        this.scriptParams.put(name, value);
        return this;
    }

    public UpdateRequest scriptParams(Map<String, Object> scriptParams) {
        if (this.scriptParams == null) {
            this.scriptParams = scriptParams;
        } else {
            this.scriptParams.putAll(scriptParams);
        }
        return this;
    }

    public UpdateRequest script(String script, @Nullable Map<String, Object> scriptParams) {
        this.script = script;
        if (this.scriptParams != null) {
            this.scriptParams.putAll(scriptParams);
        } else {
            this.scriptParams = scriptParams;
        }
        return this;
    }

    public UpdateRequest script(String script, @Nullable String scriptLang, @Nullable Map<String, Object> scriptParams) {
        this.script = script;
        this.scriptLang = scriptLang;
        if (this.scriptParams != null) {
            this.scriptParams.putAll(scriptParams);
        } else {
            this.scriptParams = scriptParams;
        }
        return this;
    }

    public UpdateRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public UpdateRequest retryOnConflict(int retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
        return this;
    }

    public int retryOnConflict() {
        return this.retryOnConflict;
    }

    public UpdateRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public UpdateRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    public UpdateRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public UpdateRequest replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public UpdateRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public UpdateRequest doc(IndexRequest doc) {
        this.doc = doc;
        return this;
    }

    public UpdateRequest doc(XContentBuilder source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map source, XContentType contentType) {
        this.safeDoc().source(source, contentType);
        return this;
    }

    public UpdateRequest doc(String source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(byte[] source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(byte[] source, int offset, int length) {
        this.safeDoc().source(source, offset, length);
        return this;
    }

    public UpdateRequest doc(Object ... source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(String field, Object value) {
        this.safeDoc().source(field, value);
        return this;
    }

    public IndexRequest doc() {
        return this.doc;
    }

    private IndexRequest safeDoc() {
        if (this.doc == null) {
            this.doc = new IndexRequest();
        }
        return this.doc;
    }

    public UpdateRequest upsert(IndexRequest upsertRequest) {
        this.upsertRequest = upsertRequest;
        return this;
    }

    public UpdateRequest upsert(XContentBuilder source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map source, XContentType contentType) {
        this.safeUpsertRequest().source(source, contentType);
        return this;
    }

    public UpdateRequest upsert(String source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(byte[] source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(byte[] source, int offset, int length) {
        this.safeUpsertRequest().source(source, offset, length);
        return this;
    }

    public UpdateRequest upsert(Object ... source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public IndexRequest upsertRequest() {
        return this.upsertRequest;
    }

    private IndexRequest safeUpsertRequest() {
        if (this.upsertRequest == null) {
            this.upsertRequest = new IndexRequest();
        }
        return this.upsertRequest;
    }

    public UpdateRequest source(XContentBuilder source) throws Exception {
        return this.source(source.bytes());
    }

    public UpdateRequest source(byte[] source) throws Exception {
        return this.source(source, 0, source.length);
    }

    public UpdateRequest source(byte[] source, int offset, int length) throws Exception {
        return this.source(new BytesArray(source, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateRequest source(BytesReference source) throws Exception {
        XContentType xContentType = XContentFactory.xContentType(source);
        XContentParser parser = XContentFactory.xContent(xContentType).createParser(source);
        try {
            XContentParser.Token t = parser.nextToken();
            if (t == null) {
                UpdateRequest updateRequest = this;
                return updateRequest;
            }
            String currentFieldName = null;
            while ((t = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (t == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("script".equals(currentFieldName)) {
                    this.script = parser.textOrNull();
                    continue;
                }
                if ("params".equals(currentFieldName)) {
                    this.scriptParams = parser.map();
                    continue;
                }
                if ("lang".equals(currentFieldName)) {
                    this.scriptLang = parser.text();
                    continue;
                }
                if ("upsert".equals(currentFieldName)) {
                    XContentBuilder builder = XContentFactory.contentBuilder(xContentType);
                    builder.copyCurrentStructure(parser);
                    this.safeUpsertRequest().source(builder);
                    continue;
                }
                if ("doc".equals(currentFieldName)) {
                    XContentBuilder docBuilder = XContentFactory.contentBuilder(xContentType);
                    docBuilder.copyCurrentStructure(parser);
                    this.safeDoc().source(docBuilder);
                    continue;
                }
                if (!"doc_as_upsert".equals(currentFieldName)) continue;
                this.docAsUpsert(parser.booleanValue());
            }
        }
        finally {
            parser.close();
        }
        return this;
    }

    public boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    public void docAsUpsert(boolean shouldUpsertDoc) {
        this.docAsUpsert = shouldUpsertDoc;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size;
        super.readFrom(in);
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        this.type = in.readSharedString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.script = in.readOptionalString();
        this.scriptLang = in.readOptionalString();
        this.scriptParams = in.readMap();
        this.retryOnConflict = in.readVInt();
        this.refresh = in.readBoolean();
        if (in.readBoolean()) {
            this.doc = new IndexRequest();
            this.doc.readFrom(in);
        }
        if ((size = in.readInt()) >= 0) {
            this.fields = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = in.readString();
            }
        }
        if (in.readBoolean()) {
            this.upsertRequest = new IndexRequest();
            this.upsertRequest.readFrom(in);
        }
        this.docAsUpsert = in.readBoolean();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        out.writeSharedString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.script);
        out.writeOptionalString(this.scriptLang);
        out.writeMap(this.scriptParams);
        out.writeVInt(this.retryOnConflict);
        out.writeBoolean(this.refresh);
        if (this.doc == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.doc.index(this.index);
            this.doc.type(this.type);
            this.doc.id(this.id);
            this.doc.writeTo(out);
        }
        if (this.fields == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.fields.length);
            for (String field : this.fields) {
                out.writeString(field);
            }
        }
        if (this.upsertRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.upsertRequest.index(this.index);
            this.upsertRequest.type(this.type);
            this.upsertRequest.id(this.id);
            this.upsertRequest.writeTo(out);
        }
        out.writeBoolean(this.docAsUpsert);
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
    }
}

