/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.mapper.internal.TimestampFieldMapper;

public class IndexRequest
extends ShardReplicationOperationRequest<IndexRequest> {
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    private String parent;
    @Nullable
    private String timestamp;
    private long ttl = -1L;
    private BytesReference source;
    private boolean sourceUnsafe;
    private OpType opType = OpType.INDEX;
    private boolean refresh = false;
    private long version = 0L;
    private VersionType versionType = VersionType.INTERNAL;
    private XContentType contentType = Requests.INDEX_CONTENT_TYPE;

    public IndexRequest() {
    }

    public IndexRequest(String index) {
        this.index = index;
    }

    public IndexRequest(String index, String type) {
        this.index = index;
        this.type = type;
    }

    public IndexRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void beforeLocalFork() {
        this.safeSource();
    }

    public IndexRequest contentType(XContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public String type() {
        return this.type;
    }

    public IndexRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public IndexRequest id(String id) {
        this.id = id;
        return this;
    }

    public IndexRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public IndexRequest parent(String parent) {
        this.parent = parent;
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public IndexRequest timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public IndexRequest ttl(Long ttl) throws ElasticsearchGenerationException {
        if (ttl == null) {
            this.ttl = -1L;
            return this;
        }
        if (ttl <= 0L) {
            throw new ElasticsearchIllegalArgumentException("TTL value must be > 0. Illegal value provided [" + ttl + "]");
        }
        this.ttl = ttl;
        return this;
    }

    public long ttl() {
        return this.ttl;
    }

    public BytesReference source() {
        return this.source;
    }

    public BytesReference safeSource() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
            this.sourceUnsafe = false;
        }
        return this.source;
    }

    public Map<String, Object> sourceAsMap() {
        return XContentHelper.convertToMap(this.source, false).v2();
    }

    public IndexRequest source(Map source) throws ElasticsearchGenerationException {
        return this.source(source, this.contentType);
    }

    public IndexRequest source(Map source, XContentType contentType) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public IndexRequest source(String source) {
        this.source = new BytesArray(source.getBytes(Charsets.UTF_8));
        this.sourceUnsafe = false;
        return this;
    }

    public IndexRequest source(XContentBuilder sourceBuilder) {
        this.source = sourceBuilder.bytes();
        this.sourceUnsafe = false;
        return this;
    }

    public IndexRequest source(String field1, Object value1) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(String field1, Object value1, String field2, Object value2) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).field(field2, value2).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(String field1, Object value1, String field2, Object value2, String field3, Object value3) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).field(field2, value2).field(field3, value3).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(String field1, Object value1, String field2, Object value2, String field3, Object value3, String field4, Object value4) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject().field(field1, value1).field(field2, value2).field(field3, value3).field(field4, value4).endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("The number of object passed must be even but was [" + source.length + "]");
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject();
            for (int i = 0; i < source.length; ++i) {
                builder.field(source[i++].toString(), source[i]);
            }
            builder.endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(BytesReference source, boolean unsafe) {
        this.source = source;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public IndexRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public IndexRequest source(byte[] source, int offset, int length) {
        return this.source(source, offset, length, false);
    }

    public IndexRequest source(byte[] source, int offset, int length, boolean unsafe) {
        this.source = new BytesArray(source, offset, length);
        this.sourceUnsafe = unsafe;
        return this;
    }

    public IndexRequest opType(OpType opType) {
        this.opType = opType;
        return this;
    }

    public IndexRequest opType(String opType) throws ElasticsearchIllegalArgumentException {
        if ("create".equals(opType)) {
            return this.opType(OpType.CREATE);
        }
        if ("index".equals(opType)) {
            return this.opType(OpType.INDEX);
        }
        throw new ElasticsearchIllegalArgumentException("No index opType matching [" + opType + "]");
    }

    public IndexRequest create(boolean create) {
        if (create) {
            return this.opType(OpType.CREATE);
        }
        return this.opType(OpType.INDEX);
    }

    public OpType opType() {
        return this.opType;
    }

    public IndexRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public IndexRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public IndexRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    public void process(MetaData metaData, String aliasOrIndex, @Nullable MappingMetaData mappingMd, boolean allowIdGeneration) throws ElasticsearchException {
        this.routing(metaData.resolveIndexRouting(this.routing, aliasOrIndex));
        if (this.timestamp != null) {
            this.timestamp = MappingMetaData.Timestamp.parseStringTimestamp(this.timestamp, mappingMd != null ? mappingMd.timestamp().dateTimeFormatter() : TimestampFieldMapper.Defaults.DATE_TIME_FORMATTER);
        }
        if (mappingMd != null) {
            MappingMetaData.ParseContext parseContext = mappingMd.createParseContext(this.id, this.routing, this.timestamp);
            if (parseContext.shouldParse()) {
                XContentParser parser = null;
                try {
                    parser = XContentHelper.createParser(this.source);
                    mappingMd.parse(parser, parseContext);
                    if (parseContext.shouldParseId()) {
                        this.id = parseContext.id();
                    }
                    if (parseContext.shouldParseRouting()) {
                        this.routing = parseContext.routing();
                    }
                    if (parseContext.shouldParseTimestamp()) {
                        this.timestamp = parseContext.timestamp();
                        this.timestamp = MappingMetaData.Timestamp.parseStringTimestamp(this.timestamp, mappingMd.timestamp().dateTimeFormatter());
                    }
                }
                catch (Exception e) {
                    throw new ElasticsearchParseException("failed to parse doc to extract routing/timestamp/id", e);
                }
                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
            }
            if (mappingMd.routing().required() && this.routing == null) {
                throw new RoutingMissingException(this.index, this.type, this.id);
            }
            if (this.parent != null && !mappingMd.hasParentField()) {
                throw new ElasticsearchIllegalArgumentException("Can't specify parent if no parent field has been configured");
            }
        } else if (this.parent != null) {
            throw new ElasticsearchIllegalArgumentException("Can't specify parent if no parent field has been configured");
        }
        if (allowIdGeneration && this.id == null) {
            this.id(Strings.randomBase64UUID());
            this.opType(OpType.CREATE);
        }
        if (this.timestamp == null) {
            this.timestamp = Long.toString(System.currentTimeMillis());
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readSharedString();
        this.id = in.readOptionalString();
        this.routing = in.readOptionalString();
        this.parent = in.readOptionalString();
        this.timestamp = in.readOptionalString();
        this.ttl = in.readLong();
        this.source = in.readBytesReference();
        this.sourceUnsafe = false;
        this.opType = OpType.fromId(in.readByte());
        this.refresh = in.readBoolean();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeSharedString(this.type);
        out.writeOptionalString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.parent);
        out.writeOptionalString(this.timestamp);
        out.writeLong(this.ttl);
        out.writeBytesReference(this.source);
        out.writeByte(this.opType.id());
        out.writeBoolean(this.refresh);
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "index {[" + this.index + "][" + this.type + "][" + this.id + "], source[" + sSource + "]}";
    }

    public static enum OpType {
        INDEX(0),
        CREATE(1);

        private final byte id;
        private final String lowercase;

        private OpType(byte id) {
            this.id = id;
            this.lowercase = this.toString().toLowerCase(Locale.ENGLISH);
        }

        public byte id() {
            return this.id;
        }

        public String lowercase() {
            return this.lowercase;
        }

        public static OpType fromId(byte id) {
            if (id == 0) {
                return INDEX;
            }
            if (id == 1) {
                return CREATE;
            }
            throw new ElasticsearchIllegalArgumentException("No type match for [" + id + "]");
        }
    }
}

