/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.PropertyBoxParserImpl;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MovieBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.FileDataSourceImpl;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.util.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.WritableByteChannel;

@DoNotParseDetail
public class IsoFile
extends BasicContainer
implements Closeable {
    private static Logger LOG = Logger.getLogger(IsoFile.class);

    public IsoFile(String filename) throws IOException {
        this(new FileDataSourceImpl(new File(filename)));
    }

    public IsoFile(DataSource dataSource) throws IOException {
        this.parseContainer(dataSource, dataSource.size(), new PropertyBoxParserImpl(new String[0]));
    }

    public IsoFile(DataSource dataSource, BoxParser boxParser) throws IOException {
        this.dataSource = dataSource;
        this.boxParser = boxParser;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("IsoFile[").append(this.dataSource.toString()).append("]");
        return buffer.toString();
    }

    public static byte[] fourCCtoBytes(String fourCC) {
        byte[] result = new byte[4];
        if (fourCC != null) {
            int i = 0;
            while (i < Math.min(4, fourCC.length())) {
                result[i] = (byte)fourCC.charAt(i);
                ++i;
            }
        }
        return result;
    }

    public static String bytesToFourCC(byte[] type) {
        byte[] result = new byte[4];
        if (type != null) {
            System.arraycopy(type, 0, result, 0, Math.min(type.length, 4));
        }
        try {
            return new String(result, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Required character encoding is missing", e);
        }
    }

    public long getSize() {
        return this.getContainerSize();
    }

    public MovieBox getMovieBox() {
        for (Box box : this.getBoxes()) {
            if (!(box instanceof MovieBox)) continue;
            return (MovieBox)box;
        }
        return null;
    }

    public void getBox(WritableByteChannel os) throws IOException {
        this.writeContainer(os);
    }

    public void close() throws IOException {
        this.dataSource.close();
    }
}

