/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.AscFieldComp;
import org.apache.solr.client.solrj.io.DescFieldComp;
import org.apache.solr.client.solrj.io.MultiComp;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.SolrStream;
import org.apache.solr.client.solrj.io.StreamContext;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.TupleStream;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.SolrjNamedThreadFactory;

public class CloudSolrStream
extends TupleStream {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    protected String collection;
    protected Map params;
    private Map<String, String> fieldMappings;
    protected Comparator<Tuple> comp;
    private int zkConnectTimeout = 10000;
    private int zkClientTimeout = 10000;
    private int numWorkers;
    private int workerID;
    private boolean trace;
    protected transient Map<String, Tuple> eofTuples;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;
    protected transient List<TupleStream> solrStreams;
    protected transient TreeSet<TupleWrapper> tuples;
    protected transient StreamContext streamContext;

    public CloudSolrStream(String zkHost, String collection, Map params) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.params = params;
        String sort = (String)params.get("sort");
        this.comp = this.parseComp(sort, params);
    }

    protected CloudSolrStream() {
    }

    public void setComp(Comparator<Tuple> comp) {
        this.comp = comp;
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.numWorkers = context.numWorkers;
        this.workerID = context.workerID;
        this.cache = context.getSolrClientCache();
        this.streamContext = context;
    }

    @Override
    public void open() throws IOException {
        this.tuples = new TreeSet();
        this.solrStreams = new ArrayList<TupleStream>();
        this.eofTuples = new HashMap<String, Tuple>();
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            this.cloudSolrClient = new CloudSolrClient(this.zkHost);
            this.cloudSolrClient.connect();
        }
        this.constructStreams();
        this.openStreams();
    }

    public Map getEofTuples() {
        return this.eofTuples;
    }

    @Override
    public List<TupleStream> children() {
        return this.solrStreams;
    }

    private Comparator<Tuple> parseComp(String sort, Map params) throws IOException {
        String fl = (String)params.get("fl");
        String[] fls = fl.split(",");
        HashSet<String> fieldSet = new HashSet<String>();
        for (String f : fls) {
            fieldSet.add(f.trim());
        }
        String[] sorts = sort.split(",");
        Comparator[] comps = new Comparator[sorts.length];
        for (int i = 0; i < sorts.length; ++i) {
            String s = sorts[i];
            String[] spec = s.trim().split("\\s+");
            if (!fieldSet.contains(spec[0])) {
                throw new IOException("Fields in the sort spec must be included in the field list:" + spec[0]);
            }
            comps[i] = spec[1].trim().equalsIgnoreCase("asc") ? new AscFieldComp(spec[0]) : new DescFieldComp(spec[0]);
        }
        if (comps.length > 1) {
            return new MultiComp(comps);
        }
        return comps[0];
    }

    protected void constructStreams() throws IOException {
        try {
            ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection<Slice> slices = clusterState.getActiveSlices(this.collection);
            long time = System.currentTimeMillis();
            this.params.put("distrib", "false");
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                ArrayList<Replica> shuffler = new ArrayList<Replica>();
                for (Replica replica : replicas) {
                    shuffler.add(replica);
                }
                Collections.shuffle(shuffler, new Random(time));
                Replica rep = (Replica)shuffler.get(0);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                SolrStream solrStream = new SolrStream(url, this.params);
                if (this.streamContext != null) {
                    solrStream.setStreamContext(this.streamContext);
                }
                solrStream.setFieldMappings(this.fieldMappings);
                this.solrStreams.add(solrStream);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStreams() throws IOException {
        ExecutorService service = Executors.newCachedThreadPool(new SolrjNamedThreadFactory("CloudSolrStream"));
        try {
            ArrayList<Future<TupleWrapper>> futures = new ArrayList<Future<TupleWrapper>>();
            for (TupleStream tupleStream : this.solrStreams) {
                StreamOpener so = new StreamOpener((SolrStream)tupleStream, this.comp);
                Future<TupleWrapper> future = service.submit(so);
                futures.add(future);
            }
            try {
                for (Future future : futures) {
                    TupleWrapper w = (TupleWrapper)future.get();
                    if (w == null) continue;
                    this.tuples.add(w);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public void close() throws IOException {
        for (TupleStream solrStream : this.solrStreams) {
            solrStream.close();
        }
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        return this._read();
    }

    protected Tuple _read() throws IOException {
        TupleWrapper tw = this.tuples.pollFirst();
        if (tw != null) {
            Tuple t = tw.getTuple();
            if (this.trace) {
                t.put("_COLLECTION_", this.collection);
            }
            if (tw.next()) {
                this.tuples.add(tw);
            }
            return t;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.trace) {
            m.put("_COLLECTION_", this.collection);
        }
        m.put("EOF", true);
        return new Tuple(m);
    }

    protected class StreamOpener
    implements Callable<TupleWrapper> {
        private SolrStream stream;
        private Comparator<Tuple> comp;

        public StreamOpener(SolrStream stream, Comparator<Tuple> comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public TupleWrapper call() throws Exception {
            this.stream.open();
            TupleWrapper wrapper = new TupleWrapper(this.stream, this.comp);
            if (wrapper.next()) {
                return wrapper;
            }
            return null;
        }
    }

    protected class TupleWrapper
    implements Comparable<TupleWrapper> {
        private Tuple tuple;
        private SolrStream stream;
        private Comparator comp;

        public TupleWrapper(SolrStream stream, Comparator comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public int compareTo(TupleWrapper w) {
            if (this == w) {
                return 0;
            }
            int i = this.comp.compare(this.tuple, w.tuple);
            if (i == 0) {
                return 1;
            }
            return i;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public boolean next() throws IOException {
            this.tuple = this.stream.read();
            if (this.tuple.EOF) {
                CloudSolrStream.this.eofTuples.put(this.stream.getBaseUrl(), this.tuple);
            }
            return !this.tuple.EOF;
        }
    }
}

