/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.mbeans.drda.NetworkServerMBean;
import org.apache.derby.security.SystemPermission;

class NetworkServerMBeanImpl
implements NetworkServerMBean {
    private NetworkServerControlImpl server;
    private final long startTime;
    private static final SystemPermission CONTROL = new SystemPermission("server", "control");
    private static final SystemPermission MONITOR = new SystemPermission("server", "monitor");
    private long lastReceiveTime = System.currentTimeMillis();
    private long lastReceiveBytes = 0L;
    private int receiveResult = 0;
    private long lastSentTime = System.currentTimeMillis();
    private long lastSentBytes = 0L;
    private int sentResult = 0;

    NetworkServerMBeanImpl(NetworkServerControlImpl networkServerControlImpl) {
        this.server = networkServerControlImpl;
        this.startTime = System.currentTimeMillis();
    }

    private static void checkControl() {
        NetworkServerMBeanImpl.checkPermission(CONTROL);
    }

    private static void checkMonitor() {
        NetworkServerMBeanImpl.checkPermission(MONITOR);
    }

    private static void checkPermission(SystemPermission systemPermission) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission((Permission)systemPermission);
            }
        }
        catch (AccessControlException accessControlException) {
            throw new SecurityException(accessControlException.getMessage());
        }
    }

    public String getDrdaHost() {
        NetworkServerMBeanImpl.checkControl();
        String string = this.getServerProperty("derby.drda.host");
        return string;
    }

    public boolean getDrdaKeepAlive() {
        NetworkServerMBeanImpl.checkMonitor();
        String string = this.getServerProperty("derby.drda.keepAlive");
        return "true".equals(string);
    }

    public int getDrdaMaxThreads() {
        NetworkServerMBeanImpl.checkMonitor();
        int n = 0;
        String string = this.getServerProperty("derby.drda.maxThreads");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public int getDrdaPortNumber() {
        NetworkServerMBeanImpl.checkControl();
        int n = 1527;
        String string = this.getServerProperty("derby.drda.portNumber");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public String getDrdaSecurityMechanism() {
        NetworkServerMBeanImpl.checkControl();
        String string = this.getServerProperty("derby.drda.securityMechanism");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getDrdaSslMode() {
        NetworkServerMBeanImpl.checkControl();
        String string = this.getServerProperty("derby.drda.sslMode");
        return string;
    }

    public int getDrdaStreamOutBufferSize() {
        NetworkServerMBeanImpl.checkMonitor();
        int n = PropertyUtil.getSystemInt((String)"derby.drda.streamOutBufferSize", (int)0);
        return n;
    }

    public int getDrdaTimeSlice() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getTimeSlice();
    }

    public boolean getDrdaTraceAll() {
        NetworkServerMBeanImpl.checkMonitor();
        String string = this.getServerProperty("derby.drda.traceAll");
        return "true".equals(string);
    }

    public String getDrdaTraceDirectory() {
        NetworkServerMBeanImpl.checkControl();
        String string = null;
        string = this.getServerProperty("derby.drda.traceDirectory");
        if (string == null) {
            string = this.getServerProperty("derby.system.home");
        }
        if (string == null) {
            string = PropertyUtil.getSystemProperty((String)"user.dir");
        }
        return string;
    }

    public int getConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.getActiveConnectionCount() + this.getWaitingConnectionCount();
    }

    public int getActiveConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getActiveSessions();
    }

    public int getWaitingConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getRunQueueSize();
    }

    public int getConnectionThreadPoolSize() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getThreadListSize();
    }

    public int getAccumulatedConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getConnectionNumber();
    }

    public long getBytesReceived() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getBytesRead();
    }

    public long getBytesSent() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getBytesWritten();
    }

    public synchronized int getBytesReceivedPerSecond() {
        NetworkServerMBeanImpl.checkMonitor();
        long l = System.currentTimeMillis();
        if (l - this.lastReceiveTime >= 1000L) {
            long l2 = this.getBytesReceived();
            this.receiveResult = (int)((l2 - this.lastReceiveBytes) * 1000L / (l - this.lastReceiveTime));
            this.lastReceiveTime = l;
            this.lastReceiveBytes = l2;
        }
        return this.receiveResult;
    }

    public synchronized int getBytesSentPerSecond() {
        NetworkServerMBeanImpl.checkMonitor();
        long l = System.currentTimeMillis();
        if (l - this.lastSentTime >= 1000L) {
            long l2 = this.getBytesSent();
            this.sentResult = (int)((l2 - this.lastSentBytes) * 1000L / (l - this.lastSentTime));
            this.lastSentTime = l;
            this.lastSentBytes = l2;
        }
        return this.sentResult;
    }

    public long getStartTime() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.startTime;
    }

    public long getUptime() {
        NetworkServerMBeanImpl.checkMonitor();
        return System.currentTimeMillis() - this.startTime;
    }

    public void ping() throws Exception {
        NetworkServerMBeanImpl.checkMonitor();
        try {
            this.server.ping();
        }
        catch (Exception exception) {
            Monitor.logThrowable((Throwable)exception);
            throw exception;
        }
    }

    private String getServerProperty(String string) {
        return this.server.getPropertyValues().getProperty(string);
    }
}

