/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class GetSeedList {
    public static final String _rcsid = "@(#)$Id: GetSeedList.java 988245 2010-08-23 18:39:35Z kwright $";

    private GetSeedList() {
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: GetSeedList <job_id>");
            System.err.println("(Writes a set of urls to stdout)");
            System.exit(-1);
        }
        String jobString = args[0];
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment((IThreadContext)tc);
            IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
            IJobDescription desc = jobManager.load(new Long(jobString));
            DocumentSpecification ds = desc.getSpecification();
            for (int i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode sn = ds.getChild(i);
                if (!sn.getType().equals("feed")) continue;
                String url = sn.getAttributeValue("url");
                System.out.println(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }
}

