/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.json;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.impl.json.JSONAware;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.impl.json.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
extends LinkedHashMap<String, Object>
implements Map<String, Object>,
JSONAware,
JSONStreamAware {
    private static final long serialVersionUID = 1L;

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("JSON key must not be null!");
        }
        return super.put(key, value);
    }

    public static void writeJSONString(Map<String, Object> map, Writer out) throws IOException {
        if (map == null) {
            out.write("null");
            return;
        }
        boolean first = true;
        out.write(123);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.write(44);
            }
            out.write(34);
            if (entry.getKey() == null) {
                out.write("null");
            } else {
                out.write(JSONObject.escape(entry.getKey()));
            }
            out.write(34);
            out.write(58);
            JSONValue.writeJSONString(entry.getValue(), out);
        }
        out.write(125);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject.writeJSONString(this, out);
    }

    public static String toJSONString(Map<String, Object> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('{');
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            JSONObject.toJSONString(entry.getKey(), entry.getValue(), sb);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this);
    }

    private static String toJSONString(String key, Object value, StringBuilder sb) {
        sb.append('\"');
        if (key == null) {
            sb.append("null");
        } else {
            JSONValue.escape(key, sb);
        }
        sb.append('\"').append(':');
        sb.append(JSONValue.toJSONString(value));
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public static String toString(String key, Object value) {
        StringBuilder sb = new StringBuilder();
        JSONObject.toJSONString(key, value, sb);
        return sb.toString();
    }

    public static String escape(String s) {
        return JSONValue.escape(s);
    }
}

