/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.manifoldcf.core.common.XMLDoc;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHierarchyParent;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONWriter;

public class Configuration
implements IHierarchyParent {
    public static final String _rcsid = "@(#)$Id: Configuration.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String JSON_ATTRIBUTE = "_attribute_";
    protected static final String JSON_VALUE = "_value_";
    protected static final String JSON_CHILDREN = "_children_";
    protected static final String JSON_TYPE = "_type_";
    protected String rootNodeLabel;
    protected List<ConfigurationNode> children = new ArrayList<ConfigurationNode>();
    protected boolean readOnly = false;

    public Configuration() {
        this.rootNodeLabel = "data";
    }

    public Configuration(String rootNodeLabel) {
        this.rootNodeLabel = rootNodeLabel;
    }

    protected Configuration createNew() {
        return new Configuration();
    }

    protected ConfigurationNode createNewNode(String type) {
        return new ConfigurationNode(type);
    }

    protected void clearOuterNodes() {
    }

    protected void addOuterNode(ConfigurationNode node) {
    }

    protected void removeOuterNode(ConfigurationNode node) {
    }

    protected Configuration createDuplicate(boolean readOnly) {
        if (readOnly && this.readOnly) {
            return this;
        }
        Configuration rval = this.createNew();
        rval.readOnly = readOnly;
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                ConfigurationNode child = this.children.get(i++);
                ConfigurationNode newChild = child.createDuplicate(readOnly);
                rval.addChild(rval.getChildCount(), newChild);
            }
        }
        return rval;
    }

    public void makeReadOnly() {
        if (this.readOnly) {
            return;
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                ConfigurationNode child = this.children.get(i++);
                child.makeReadOnly();
            }
        }
        this.readOnly = true;
    }

    public String toXML() throws ManifoldCFException {
        XMLDoc doc = new XMLDoc();
        Object top = doc.createElement(null, this.rootNodeLabel);
        int i = 0;
        while (i < this.children.size()) {
            ConfigurationNode node = this.children.get(i++);
            Configuration.writeNode(doc, top, node);
        }
        return doc.getXML();
    }

    public String toJSON() throws ManifoldCFException {
        try {
            ConfigurationNode child;
            String key;
            List<ConfigurationNode> list;
            JSONStringer writer = new JSONStringer();
            writer.object();
            HashMap childMap = new HashMap();
            ArrayList<String> childList = new ArrayList<String>();
            String lastChildType = null;
            boolean needAlternate = false;
            int i = 0;
            while (i < this.getChildCount()) {
                if ((list = (ArrayList)childMap.get(key = (child = this.findChild(i++)).getType())) == null) {
                    list = new ArrayList();
                    childMap.put(key, list);
                    childList.add(key);
                } else if (!lastChildType.equals(key)) {
                    needAlternate = true;
                    break;
                }
                list.add(child);
                lastChildType = key;
            }
            if (needAlternate) {
                writer.key(JSON_CHILDREN);
                writer.array();
                i = 0;
                while (i < this.getChildCount()) {
                    child = this.findChild(i++);
                    Configuration.writeNode((JSONWriter)writer, child, false, true);
                }
                writer.endArray();
            } else {
                int q = 0;
                while (q < childList.size()) {
                    if ((list = (List)childMap.get(key = (String)childList.get(q++))).size() > 1) {
                        writer.key(key);
                        writer.array();
                        i = 0;
                        while (i < list.size()) {
                            ConfigurationNode child2 = (ConfigurationNode)list.get(i++);
                            Configuration.writeNode((JSONWriter)writer, child2, false, false);
                        }
                        writer.endArray();
                        continue;
                    }
                    Configuration.writeNode((JSONWriter)writer, (ConfigurationNode)list.get(0), true, false);
                }
            }
            writer.endObject();
            return writer.toString();
        }
        catch (JSONException e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
    }

    protected static void writeNode(XMLDoc doc, Object parent, ConfigurationNode node) throws ManifoldCFException {
        String type = node.getType();
        String value = node.getValue();
        Object o = doc.createElement(parent, type);
        Iterator<String> iter = node.getAttributes();
        while (iter.hasNext()) {
            String attribute = iter.next();
            String attrValue = node.getAttributeValue(attribute);
            doc.setAttribute(o, attribute, attrValue);
        }
        if (value != null) {
            doc.createText(o, value);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            ConfigurationNode child = node.findChild(i++);
            Configuration.writeNode(doc, o, child);
        }
    }

    protected static void writeNode(JSONWriter writer, ConfigurationNode node, boolean writeKey, boolean writeSpecialKey) throws ManifoldCFException {
        try {
            if (writeKey) {
                String type = node.getType();
                writer.key(type);
            } else if (writeSpecialKey) {
                writer.object();
                writer.key(JSON_TYPE);
                writer.value((Object)node.getType());
            }
            String value = node.getValue();
            if (value != null && node.getAttributeCount() == 0 && node.getChildCount() == 0) {
                writer.value((Object)value);
            } else {
                ConfigurationNode child;
                String key;
                List<ConfigurationNode> list;
                if (!writeSpecialKey) {
                    writer.object();
                }
                if (value != null) {
                    writer.key(JSON_VALUE);
                    writer.value((Object)value);
                }
                Iterator<String> iter = node.getAttributes();
                while (iter.hasNext()) {
                    String attribute = iter.next();
                    String attrValue = node.getAttributeValue(attribute);
                    writer.key(JSON_ATTRIBUTE + attribute);
                    writer.value((Object)attrValue);
                }
                HashMap childMap = new HashMap();
                ArrayList<String> childList = new ArrayList<String>();
                String lastChildType = null;
                boolean needAlternate = false;
                int i = 0;
                while (i < node.getChildCount()) {
                    if ((list = (ArrayList)childMap.get(key = (child = node.findChild(i++)).getType())) == null) {
                        list = new ArrayList();
                        childMap.put(key, list);
                        childList.add(key);
                    } else if (!lastChildType.equals(key)) {
                        needAlternate = true;
                        break;
                    }
                    list.add(child);
                    lastChildType = key;
                }
                if (needAlternate) {
                    writer.key(JSON_CHILDREN);
                    writer.array();
                    i = 0;
                    while (i < node.getChildCount()) {
                        child = node.findChild(i++);
                        Configuration.writeNode(writer, child, false, true);
                    }
                    writer.endArray();
                } else {
                    int q = 0;
                    while (q < childList.size()) {
                        if ((list = (List)childMap.get(key = (String)childList.get(q++))).size() > 1) {
                            writer.key(key);
                            writer.array();
                            i = 0;
                            while (i < list.size()) {
                                ConfigurationNode child2 = (ConfigurationNode)list.get(i++);
                                Configuration.writeNode(writer, child2, false, false);
                            }
                            writer.endArray();
                            continue;
                        }
                        Configuration.writeNode(writer, (ConfigurationNode)list.get(0), true, false);
                    }
                }
                if (!writeSpecialKey) {
                    writer.endObject();
                }
            }
            if (writeSpecialKey) {
                writer.endObject();
            }
        }
        catch (JSONException e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
    }

    public void fromXML(String xml) throws ManifoldCFException {
        XMLDoc doc = new XMLDoc(xml);
        this.initializeFromDoc(doc);
    }

    public void fromJSON(String json) throws ManifoldCFException {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.clearChildren();
        try {
            JSONObject object = new JSONObject(json);
            Iterator iter = object.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object x = object.opt(key);
                if (x instanceof JSONArray) {
                    JSONArray array = (JSONArray)x;
                    int i = 0;
                    while (i < array.length()) {
                        x = array.opt(i++);
                        this.processObject(key, x);
                    }
                    continue;
                }
                this.processObject(key, x);
            }
        }
        catch (JSONException e) {
            throw new ManifoldCFException("Json syntax error - " + e.getMessage(), e);
        }
    }

    protected void processObject(String key, Object x) throws ManifoldCFException {
        if (x instanceof JSONObject) {
            ConfigurationNode cn = this.readNode(key, (JSONObject)x);
            this.addChild(this.getChildCount(), cn);
        } else if (x != JSONObject.NULL) {
            if (key.equals(JSON_CHILDREN)) {
                if (!(x instanceof JSONArray)) {
                    throw new ManifoldCFException("Expected array contents for '_children_' node");
                }
                JSONArray array = (JSONArray)x;
                int i = 0;
                while (i < array.length()) {
                    Object z;
                    if (!((z = array.opt(i++)) instanceof JSONObject)) {
                        throw new ManifoldCFException("Expected object as array member");
                    }
                    ConfigurationNode nestedCn = this.readNode((String)null, (JSONObject)z);
                    this.addChild(this.getChildCount(), nestedCn);
                }
            } else {
                String value = x.toString();
                ConfigurationNode cn = this.createNewNode(key);
                cn.setValue(value);
                this.addChild(this.getChildCount(), cn);
            }
        }
    }

    protected ConfigurationNode readNode(String key, JSONObject object) throws ManifoldCFException {
        if (object.has(JSON_TYPE)) {
            try {
                key = object.getString(JSON_TYPE);
            }
            catch (JSONException e) {
                throw new ManifoldCFException("Exception decoding JSON: " + e.getMessage());
            }
        }
        if (key == null) {
            throw new ManifoldCFException("No type found for node");
        }
        ConfigurationNode rval = this.createNewNode(key);
        Iterator iter = object.keys();
        while (iter.hasNext()) {
            String nestedKey = (String)iter.next();
            if (nestedKey.equals(JSON_TYPE)) continue;
            Object x = object.opt(nestedKey);
            if (x instanceof JSONArray) {
                JSONArray array = (JSONArray)x;
                int i = 0;
                while (i < array.length()) {
                    x = array.opt(i++);
                    this.processObject(rval, nestedKey, x);
                }
                continue;
            }
            this.processObject(rval, nestedKey, x);
        }
        return rval;
    }

    protected void processObject(ConfigurationNode cn, String key, Object x) throws ManifoldCFException {
        if (x instanceof JSONObject) {
            ConfigurationNode nestedCn = this.readNode(key, (JSONObject)x);
            cn.addChild(cn.getChildCount(), nestedCn);
        } else if (x != JSONObject.NULL) {
            String value = x.toString();
            if (key.startsWith(JSON_ATTRIBUTE)) {
                cn.setAttribute(key.substring(JSON_ATTRIBUTE.length()), value);
            } else if (key.equals(JSON_VALUE)) {
                cn.setValue(value);
            } else if (key.equals(JSON_CHILDREN)) {
                if (!(x instanceof JSONArray)) {
                    throw new ManifoldCFException("Expected array contents for '_children_' node");
                }
                JSONArray array = (JSONArray)x;
                int i = 0;
                while (i < array.length()) {
                    Object z;
                    if (!((z = array.opt(i++)) instanceof JSONObject)) {
                        throw new ManifoldCFException("Expected object as array member");
                    }
                    ConfigurationNode nestedCn = this.readNode((String)null, (JSONObject)z);
                    cn.addChild(cn.getChildCount(), nestedCn);
                }
            } else {
                ConfigurationNode nestedCn = this.createNewNode(key);
                nestedCn.setValue(value);
                cn.addChild(cn.getChildCount(), nestedCn);
            }
        }
    }

    public void fromXML(InputStream xmlstream) throws ManifoldCFException {
        XMLDoc doc = new XMLDoc(xmlstream);
        this.initializeFromDoc(doc);
    }

    protected void initializeFromDoc(XMLDoc doc) throws ManifoldCFException {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.clearChildren();
        ArrayList list = new ArrayList();
        doc.processPath(list, "*", null);
        if (list.size() != 1) {
            throw new ManifoldCFException("Bad xml - missing outer '" + this.rootNodeLabel + "' node - there are " + Integer.toString(list.size()) + " nodes");
        }
        Object parent = list.get(0);
        if (!doc.getNodeName(parent).equals(this.rootNodeLabel)) {
            throw new ManifoldCFException("Bad xml - outer node is not '" + this.rootNodeLabel + "'");
        }
        list.clear();
        doc.processPath(list, "*", parent);
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i++);
            ConfigurationNode node = this.readNode(doc, o);
            this.addChild(this.getChildCount(), node);
        }
    }

    protected ConfigurationNode readNode(XMLDoc doc, Object object) throws ManifoldCFException {
        String type = doc.getNodeName(object);
        ConfigurationNode rval = this.createNewNode(type);
        String value = doc.getData(object);
        rval.setValue(value);
        ArrayList list = doc.getAttributes(object);
        int i = 0;
        while (i < list.size()) {
            String attribute = (String)list.get(i++);
            String attrValue = doc.getValue(object, attribute);
            rval.setAttribute(attribute, attrValue);
        }
        list.clear();
        doc.processPath(list, "*", object);
        i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            ConfigurationNode node = this.readNode(doc, o);
            rval.addChild(i++, node);
        }
        return rval;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ConfigurationNode findChild(int index) {
        return this.children.get(index);
    }

    @Override
    public void removeChild(int index) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        ConfigurationNode node = this.children.remove(index);
        this.removeOuterNode(node);
    }

    @Override
    public void addChild(int index, ConfigurationNode child) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.children.add(index, child);
        this.addOuterNode(child);
    }

    @Override
    public void clearChildren() {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to change read-only object");
        }
        this.children.clear();
        this.clearOuterNodes();
    }

    public int hashCode() {
        int rval = 0;
        int i = 0;
        while (i < this.children.size()) {
            rval += this.children.get(i++).hashCode();
        }
        return rval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration p = (Configuration)o;
        if (this.children.size() != p.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).equals(p.children.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                if (i > 0) {
                    sb.append(", ");
                }
                ConfigurationNode cn = this.children.get(i++);
                sb.append(cn.toString());
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

