/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSetAndFlags;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.system.CleanupQueuedDocument;
import org.apache.manifoldcf.crawler.system.DocumentCleanupQueue;
import org.apache.manifoldcf.crawler.system.DocumentCleanupSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;

public class ExpireStufferThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: ExpireStufferThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final DocumentCleanupQueue documentQueue;
    protected final WorkerResetManager resetManager;
    protected final int n;
    protected final String processID;

    public ExpireStufferThread(DocumentCleanupQueue documentQueue, int n, WorkerResetManager resetManager, String processID) throws ManifoldCFException {
        this.documentQueue = documentQueue;
        this.n = n;
        this.resetManager = resetManager;
        this.processID = processID;
        this.setName("Expire stuffer thread");
        this.setDaemon(true);
        this.setPriority(this.getPriority() + 1);
    }

    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            Logging.threads.debug((Object)("Expire stuffer thread: Maximum document count per check is " + Integer.toString(this.n)));
            HashMap documentSets = new HashMap();
            HashMap jobDescriptionMap = new HashMap();
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            int deleteChunkSize = database.getMaxInClause();
            while (true) {
                try {
                    while (true) {
                        int k;
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.resetManager.waitForReset(threadContext);
                        boolean isEmpty = this.documentQueue.checkIfEmpty(this.n * 3);
                        if (!isEmpty) {
                            ExpireStufferThread.sleep(1000L);
                            continue;
                        }
                        Logging.threads.debug((Object)"Expiration stuffer thread woke up");
                        long currentTime = System.currentTimeMillis();
                        DocumentSetAndFlags docsAndFlags = jobManager.getExpiredDocuments(this.processID, deleteChunkSize, currentTime);
                        DocumentDescription[] descs = docsAndFlags.getDocumentSet();
                        boolean[] deleteFromIndex = docsAndFlags.getFlags();
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)("Expiration stuffer thread: Found " + Integer.toString(descs.length) + " documents to expire"));
                        }
                        if (descs.length == 0) {
                            ManifoldCF.sleep((long)5000L);
                            continue;
                        }
                        HashMap<Long, ArrayList<CleanupQueuedDocument>> jobMap = new HashMap<Long, ArrayList<CleanupQueuedDocument>>();
                        for (k = 0; k < descs.length; ++k) {
                            CleanupQueuedDocument x = new CleanupQueuedDocument(descs[k], deleteFromIndex[k]);
                            Long jobID = descs[k].getJobID();
                            ArrayList<CleanupQueuedDocument> y = (ArrayList<CleanupQueuedDocument>)jobMap.get(jobID);
                            if (y == null) {
                                y = new ArrayList<CleanupQueuedDocument>();
                                jobMap.put(jobID, y);
                            }
                            y.add(x);
                        }
                        for (Long jobID : jobMap.keySet()) {
                            IJobDescription jobDescription = jobManager.load(jobID, true);
                            List y = (List)jobMap.get(jobID);
                            CleanupQueuedDocument[] docDescs = new CleanupQueuedDocument[y.size()];
                            for (k = 0; k < docDescs.length; ++k) {
                                docDescs[k] = (CleanupQueuedDocument)y.get(k);
                            }
                            DocumentCleanupSet set = new DocumentCleanupSet(docDescs, jobDescription);
                            this.documentQueue.addDocuments(set);
                        }
                        ExpireStufferThread.yield();
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)("Expiration stuffer thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("ExpirationStufferThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

