/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConfig;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConnection;
import org.apache.manifoldcf.core.common.Base64;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.system.Logging;

public class ElasticSearchIndex
extends ElasticSearchConnection {
    protected static final String allowAttributeName = "allow_token_";
    protected static final String denyAttributeName = "deny_token_";
    protected static final String noSecurityToken = "__nosecurity__";
    protected static final boolean useNullValue = false;

    protected static boolean writeField(PrintWriter pw, boolean needComma, String fieldName, String[] fieldValues) throws IOException {
        if (fieldValues == null) {
            return needComma;
        }
        if (fieldValues.length == 1) {
            if (needComma) {
                pw.print(",");
            }
            pw.print(ElasticSearchIndex.jsonStringEscape(fieldName) + " : " + ElasticSearchIndex.jsonStringEscape(fieldValues[0]));
            needComma = true;
            return needComma;
        }
        if (fieldValues.length > 1) {
            if (needComma) {
                pw.print(",");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int j = 0; j < fieldValues.length; ++j) {
                sb.append(ElasticSearchIndex.jsonStringEscape(fieldValues[j])).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
            pw.print(ElasticSearchIndex.jsonStringEscape(fieldName) + " : " + sb.toString());
            needComma = true;
        }
        return needComma;
    }

    protected static boolean writeACLs(PrintWriter pw, boolean needComma, String aclType, String[] acl, String[] denyAcl) throws IOException {
        String metadataACLName = allowAttributeName + aclType;
        needComma = acl != null && acl.length > 0 ? ElasticSearchIndex.writeField(pw, needComma, metadataACLName, acl) : ElasticSearchIndex.writeField(pw, needComma, metadataACLName, new String[]{noSecurityToken});
        String metadataDenyACLName = denyAttributeName + aclType;
        needComma = denyAcl != null && denyAcl.length > 0 ? ElasticSearchIndex.writeField(pw, needComma, metadataDenyACLName, denyAcl) : ElasticSearchIndex.writeField(pw, needComma, metadataDenyACLName, new String[]{noSecurityToken});
        return needComma;
    }

    protected static String jsonStringEscape(String value) {
        StringBuilder sb = new StringBuilder("\"");
        for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            if (x == '\n') {
                sb.append('\\').append('n');
                continue;
            }
            if (x == '\r') {
                sb.append('\\').append('r');
                continue;
            }
            if (x == '\t') {
                sb.append('\\').append('t');
                continue;
            }
            if (x == '\b') {
                sb.append('\\').append('b');
                continue;
            }
            if (x == '\f') {
                sb.append('\\').append('f');
                continue;
            }
            if (x == '\"' || x == '\\' || x == '/') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append("\"");
        return sb.toString();
    }

    public ElasticSearchIndex(HttpClient client, ElasticSearchConfig config) {
        super(config, client);
    }

    public boolean execute(String documentURI, RepositoryDocument document, InputStream inputStream, String[] acls, String[] denyAcls, String[] shareAcls, String[] shareDenyAcls, String[] parentAcls, String[] parentDenyAcls) throws ManifoldCFException, ServiceInterruption {
        String idField = URLEncoder.encode((String)documentURI);
        StringBuffer url = this.getApiUrl(this.config.getIndexType() + "/" + idField, false);
        HttpPut put = new HttpPut(url.toString());
        put.setEntity((HttpEntity)new IndexRequestEntity(document, inputStream, acls, denyAcls, shareAcls, shareDenyAcls, parentAcls, parentDenyAcls));
        if (!this.call((HttpRequestBase)put)) {
            return false;
        }
        String error = this.checkJson("\"error\"");
        if (this.getResult() == ElasticSearchConnection.Result.OK && error == null) {
            return true;
        }
        this.setResult("JSONERROR", ElasticSearchConnection.Result.ERROR, error);
        Logging.connectors.warn((Object)("ES: Index failed: " + this.getResponse()));
        return true;
    }

    private class IndexRequestEntity
    implements HttpEntity {
        private final RepositoryDocument document;
        private final InputStream inputStream;
        private final String[] acls;
        private final String[] denyAcls;
        private final String[] shareAcls;
        private final String[] shareDenyAcls;
        private final String[] parentAcls;
        private final String[] parentDenyAcls;

        public IndexRequestEntity(RepositoryDocument document, InputStream inputStream, String[] acls, String[] denyAcls, String[] shareAcls, String[] shareDenyAcls, String[] parentAcls, String[] parentDenyAcls) throws ManifoldCFException {
            this.document = document;
            this.inputStream = inputStream;
            this.acls = acls;
            this.denyAcls = denyAcls;
            this.shareAcls = shareAcls;
            this.shareDenyAcls = shareDenyAcls;
            this.parentAcls = parentAcls;
            this.parentDenyAcls = parentDenyAcls;
        }

        public boolean isChunked() {
            return false;
        }

        @Deprecated
        public void consumeContent() throws IOException {
            EntityUtils.consume((HttpEntity)this);
        }

        public boolean isRepeatable() {
            return false;
        }

        public boolean isStreaming() {
            return false;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return this.inputStream;
        }

        public void writeTo(OutputStream out) throws IOException {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            try {
                pw.print("{");
                Iterator i = this.document.getFields();
                boolean needComma = false;
                while (i.hasNext()) {
                    String fieldName = (String)i.next();
                    String[] fieldValues = this.document.getFieldAsStrings(fieldName);
                    needComma = ElasticSearchIndex.writeField(pw, needComma, fieldName, fieldValues);
                }
                needComma = ElasticSearchIndex.writeACLs(pw, needComma, "document", this.acls, this.denyAcls);
                needComma = ElasticSearchIndex.writeACLs(pw, needComma, "share", this.shareAcls, this.shareDenyAcls);
                needComma = ElasticSearchIndex.writeACLs(pw, needComma, "parent", this.parentAcls, this.parentDenyAcls);
                if (this.inputStream != null) {
                    String fileName;
                    if (needComma) {
                        pw.print(",");
                    }
                    pw.print("\"file\" : {");
                    String contentType = this.document.getMimeType();
                    if (contentType != null) {
                        pw.print("\"_content_type\" : " + ElasticSearchIndex.jsonStringEscape(contentType) + ",");
                    }
                    if ((fileName = this.document.getFileName()) != null) {
                        pw.print("\"_name\" : " + ElasticSearchIndex.jsonStringEscape(fileName) + ",");
                    }
                    pw.print(" \"_content\" : \"");
                    Base64 base64 = new Base64();
                    base64.encodeStream(this.inputStream, (Writer)pw);
                    pw.print("\"}");
                }
                pw.print("}");
            }
            catch (ManifoldCFException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                pw.flush();
                IOUtils.closeQuietly((Writer)pw);
            }
        }

        public long getContentLength() {
            return -1L;
        }

        public Header getContentType() {
            return new BasicHeader("Content-type", "application/x-www-form-urlencoded");
        }

        public Header getContentEncoding() {
            return null;
        }
    }
}

