/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.TransactionalAgentsInitializationCommand;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class RegisterTransformation
extends TransactionalAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: RegisterTransformation.java 1601529 2014-06-09 23:19:08Z kwright $";
    private final String className;
    private final String description;

    public RegisterTransformation(String className, String description) {
        this.className = className;
        this.description = description;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        ITransformationConnectorManager mgr = TransformationConnectorManagerFactory.make(tc);
        ITransformationConnectionManager connManager = TransformationConnectionManagerFactory.make(tc);
        mgr.registerConnector(this.description, this.className);
        String[] connectionNames = connManager.findConnectionsForConnector(this.className);
        AgentManagerFactory.noteTransformationConnectorRegistration(tc, connectionNames);
        Logging.root.info((Object)("Successfully registered transformation connector '" + this.className + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: RegisterTransformation <classname> <description>");
            System.exit(1);
        }
        String className = args[0];
        String description = args[1];
        try {
            RegisterTransformation registerTransformation = new RegisterTransformation(className, description);
            registerTransformation.execute();
            System.err.println("Successfully registered transformation connector '" + className + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

