/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ShortIntProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractShortIntMap
extends AbstractSet {
    public boolean containsKey(final short key) {
        return !this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final int value) {
        return !this.forEachPair(new ShortIntProcedure(){

            @Override
            public boolean apply(short iterKey, int iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractShortIntMap copy() {
        return (AbstractShortIntMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractShortIntMap)) {
            return false;
        }
        final AbstractShortIntMap other = (AbstractShortIntMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ShortIntProcedure(){

            @Override
            public boolean apply(short key, int value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ShortIntProcedure(){

            @Override
            public boolean apply(short key, int value) {
                return AbstractShortIntMap.this.containsKey(key) && AbstractShortIntMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new ShortIntProcedure(){
            int i = 0;

            @Override
            public boolean apply(short key, int value) {
                buf[this.i++] = HashUtils.hash(key) ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ShortProcedure var1);

    public boolean forEachPair(final ShortIntProcedure procedure) {
        return this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                return procedure.apply(key, AbstractShortIntMap.this.get(key));
            }
        });
    }

    public abstract int get(short var1);

    public ShortArrayList keys() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ShortArrayList keyList) {
        this.pairsSortedByValue(keyList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final ShortIntProcedure condition, final ShortArrayList keyList, final IntArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ShortIntProcedure(){

            @Override
            public boolean apply(short key, int value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ShortArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ShortArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final short[] k = keyList.elements();
        final int[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                int t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                short t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(short var1, int var2);

    public abstract boolean removeKey(short var1);

    public String toString() {
        ShortArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ShortArrayList theKeys = new ShortArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public IntArrayList values() {
        IntArrayList list = new IntArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final IntArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                list.add(AbstractShortIntMap.this.get(key));
                return true;
            }
        });
    }

    public int adjustOrPutValue(short key, int newValue, int incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

