/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.function;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleDoubleProcedure;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.function.IntIntFunction;
import org.apache.mahout.math.function.Mult;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.function.TimesFunction;
import org.apache.mahout.math.jet.random.engine.MersenneTwister;

public final class Functions {
    public static final DoubleFunction ABS = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.abs(a);
        }
    };
    public static final DoubleFunction ACOS = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.acos(a);
        }
    };
    public static final DoubleFunction ASIN = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.asin(a);
        }
    };
    public static final DoubleFunction ATAN = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.atan(a);
        }
    };
    public static final DoubleFunction CEIL = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.ceil(a);
        }
    };
    public static final DoubleFunction COS = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.cos(a);
        }
    };
    public static final DoubleFunction EXP = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.exp(a);
        }
    };
    public static final DoubleFunction FLOOR = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.floor(a);
        }
    };
    public static final DoubleFunction IDENTITY = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return a;
        }
    };
    public static final DoubleFunction INV = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return 1.0 / a;
        }
    };
    public static final DoubleFunction LOGARITHM = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.log(a);
        }
    };
    public static final DoubleFunction LOG2 = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.log(a) * 1.4426950408889634;
        }
    };
    public static final DoubleFunction NEGATE = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return -a;
        }
    };
    public static final DoubleFunction RINT = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.rint(a);
        }
    };
    public static final DoubleFunction SIGN = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return a < 0.0 ? -1.0 : (a > 0.0 ? 1.0 : 0.0);
        }
    };
    public static final DoubleFunction SIN = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.sin(a);
        }
    };
    public static final DoubleFunction SQRT = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.sqrt(a);
        }
    };
    public static final DoubleFunction SQUARE = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return a * a;
        }
    };
    public static final DoubleFunction SIGMOID = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return 1.0 / (1.0 + Math.exp(-a));
        }
    };
    public static final DoubleFunction SIGMOIDGRADIENT = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return a * (1.0 - a);
        }
    };
    public static final DoubleFunction TAN = new DoubleFunction(){

        @Override
        public double apply(double a) {
            return Math.tan(a);
        }
    };
    public static final DoubleDoubleFunction ATAN2 = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.atan2(a, b);
        }
    };
    public static final DoubleDoubleFunction COMPARE = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return a < b ? -1.0 : (a > b ? 1.0 : 0.0);
        }
    };
    public static final DoubleDoubleFunction DIV = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return a / b;
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return false;
        }
    };
    public static final DoubleDoubleFunction EQUALS = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return a == b ? 1.0 : 0.0;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }
    };
    public static final DoubleDoubleFunction GREATER = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return a > b ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction IEEE_REMAINDER = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.IEEEremainder(a, b);
        }
    };
    public static final DoubleDoubleProcedure IS_EQUAL = new DoubleDoubleProcedure(){

        @Override
        public boolean apply(double a, double b) {
            return a == b;
        }
    };
    public static final DoubleDoubleProcedure IS_LESS = new DoubleDoubleProcedure(){

        @Override
        public boolean apply(double a, double b) {
            return a < b;
        }
    };
    public static final DoubleDoubleProcedure IS_GREATER = new DoubleDoubleProcedure(){

        @Override
        public boolean apply(double a, double b) {
            return a > b;
        }
    };
    public static final DoubleDoubleFunction LESS = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return a < b ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction LG = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.log(a) / Math.log(b);
        }
    };
    public static final DoubleDoubleFunction MAX = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.max(a, b);
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return true;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }
    };
    public static final DoubleDoubleFunction MAX_ABS = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.max(Math.abs(a), Math.abs(b));
        }

        @Override
        public boolean isLikeRightPlus() {
            return true;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return true;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }
    };
    public static final DoubleDoubleFunction MIN = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.min(a, b);
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return true;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }
    };
    public static final DoubleDoubleFunction MINUS = Functions.plusMult(-1.0);
    public static final DoubleDoubleFunction MINUS_SQUARED = new DoubleDoubleFunction(){

        @Override
        public double apply(double x, double y) {
            return (x - y) * (x - y);
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public boolean isAssociative() {
            return false;
        }
    };
    public static final DoubleDoubleFunction MOD = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return a % b;
        }
    };
    public static final DoubleDoubleFunction MULT = new TimesFunction();
    public static final DoubleDoubleFunction PLUS = Functions.plusMult(1.0);
    public static final DoubleDoubleFunction PLUS_ABS = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.abs(a) + Math.abs(b);
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return true;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }
    };
    public static final DoubleDoubleFunction MINUS_ABS = new DoubleDoubleFunction(){

        @Override
        public double apply(double x, double y) {
            return Math.abs(x - y);
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return true;
        }

        @Override
        public boolean isAssociative() {
            return false;
        }
    };
    public static final DoubleDoubleFunction POW = new DoubleDoubleFunction(){

        @Override
        public double apply(double a, double b) {
            return Math.pow(a, b);
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return false;
        }
    };
    public static final DoubleDoubleFunction SECOND = new DoubleDoubleFunction(){

        @Override
        public double apply(double x, double y) {
            return y;
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return true;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return true;
        }
    };
    public static final DoubleDoubleFunction SECOND_LEFT_ZERO = new DoubleDoubleFunction(){

        @Override
        public double apply(double x, double y) {
            Preconditions.checkArgument((x == 0.0 ? 1 : 0) != 0, (Object)"This special version of SECOND needs x == 0");
            return y;
        }

        @Override
        public boolean isLikeRightPlus() {
            return true;
        }

        @Override
        public boolean isLikeLeftMult() {
            return false;
        }

        @Override
        public boolean isLikeRightMult() {
            return true;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return true;
        }
    };
    public static final DoubleDoubleFunction MULT_SQUARE_LEFT = new DoubleDoubleFunction(){

        @Override
        public double apply(double x, double y) {
            return x * x * y;
        }

        @Override
        public boolean isLikeRightPlus() {
            return false;
        }

        @Override
        public boolean isLikeLeftMult() {
            return true;
        }

        @Override
        public boolean isLikeRightMult() {
            return true;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return false;
        }
    };
    public static final DoubleDoubleFunction MULT_RIGHT_PLUS1 = new DoubleDoubleFunction(){

        @Override
        public double apply(double x, double y) {
            return x * (y + 1.0);
        }

        @Override
        public boolean isLikeRightPlus() {
            return true;
        }

        @Override
        public boolean isLikeLeftMult() {
            return true;
        }

        @Override
        public boolean isLikeRightMult() {
            return false;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public boolean isAssociative() {
            return false;
        }
    };

    public static DoubleDoubleFunction reweigh(final double wx, final double wy) {
        final double tw = wx + wy;
        return new DoubleDoubleFunction(){

            @Override
            public double apply(double x, double y) {
                return (wx * x + wy * y) / tw;
            }

            @Override
            public boolean isLikeRightPlus() {
                return wx == tw;
            }

            @Override
            public boolean isLikeLeftMult() {
                return false;
            }

            @Override
            public boolean isLikeRightMult() {
                return false;
            }

            @Override
            public boolean isCommutative() {
                return wx == wy;
            }

            @Override
            public boolean isAssociative() {
                return false;
            }
        };
    }

    private Functions() {
    }

    public static DoubleFunction between(final double from, final double to) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return from <= a && a <= to ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction bindArg1(final DoubleDoubleFunction function, final double c) {
        return new DoubleFunction(){

            @Override
            public double apply(double var) {
                return function.apply(c, var);
            }
        };
    }

    public static DoubleFunction bindArg2(final DoubleDoubleFunction function, final double c) {
        return new DoubleFunction(){

            @Override
            public double apply(double var) {
                return function.apply(var, c);
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleDoubleFunction f2, final DoubleFunction g, final DoubleFunction h) {
        return new DoubleDoubleFunction(){

            @Override
            public double apply(double a, double b) {
                return f2.apply(g.apply(a), h.apply(b));
            }

            @Override
            public boolean isLikeRightPlus() {
                return false;
            }

            @Override
            public boolean isLikeLeftMult() {
                return g.apply(0.0) == 0.0 && f2.isLikeLeftMult();
            }

            @Override
            public boolean isLikeRightMult() {
                return h.apply(0.0) == 0.0 && f2.isLikeRightMult();
            }

            @Override
            public boolean isCommutative() {
                return g.equals(h) && f2.isCommutative();
            }

            @Override
            public boolean isAssociative() {
                return false;
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleFunction g, final DoubleDoubleFunction h) {
        return new DoubleDoubleFunction(){

            @Override
            public double apply(double a, double b) {
                return g.apply(h.apply(a, b));
            }

            @Override
            public boolean isLikeRightPlus() {
                return false;
            }

            @Override
            public boolean isLikeLeftMult() {
                return !g.isDensifying() && h.isLikeLeftMult();
            }

            @Override
            public boolean isLikeRightMult() {
                return !g.isDensifying() && h.isLikeRightMult();
            }

            @Override
            public boolean isCommutative() {
                return h.isCommutative();
            }

            @Override
            public boolean isAssociative() {
                return false;
            }
        };
    }

    public static DoubleFunction chain(final DoubleFunction g, final DoubleFunction h) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return g.apply(h.apply(a));
            }
        };
    }

    public static IntIntFunction chain(final DoubleFunction g, final IntIntFunction h) {
        return new IntIntFunction(){

            @Override
            public double apply(int first, int second) {
                return g.apply(h.apply(first, second));
            }
        };
    }

    public static DoubleFunction compare(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return a < b ? -1.0 : (a > b ? 1.0 : 0.0);
            }
        };
    }

    public static DoubleFunction constant(final double c) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return c;
            }
        };
    }

    public static DoubleFunction div(double b) {
        return Functions.mult(1.0 / b);
    }

    public static DoubleFunction equals(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return a == b ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction notEqual(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return a != b ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction greater(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return a > b ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction mathIEEEremainder(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return Math.IEEEremainder(a, b);
            }
        };
    }

    public static DoubleProcedure isBetween(final double from, final double to) {
        return new DoubleProcedure(){

            @Override
            public boolean apply(double a) {
                return from <= a && a <= to;
            }
        };
    }

    public static DoubleProcedure isEqual(final double b) {
        return new DoubleProcedure(){

            @Override
            public boolean apply(double a) {
                return a == b;
            }
        };
    }

    public static DoubleProcedure isGreater(final double b) {
        return new DoubleProcedure(){

            @Override
            public boolean apply(double a) {
                return a > b;
            }
        };
    }

    public static DoubleProcedure isLess(final double b) {
        return new DoubleProcedure(){

            @Override
            public boolean apply(double a) {
                return a < b;
            }
        };
    }

    public static DoubleFunction less(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return a < b ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction lg(final double b) {
        return new DoubleFunction(){
            private final double logInv;
            {
                this.logInv = 1.0 / Math.log(b);
            }

            @Override
            public double apply(double a) {
                return Math.log(a) * this.logInv;
            }
        };
    }

    public static DoubleFunction max(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return Math.max(a, b);
            }
        };
    }

    public static DoubleFunction min(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return Math.min(a, b);
            }
        };
    }

    public static DoubleFunction minus(double b) {
        return Functions.plus(-b);
    }

    public static DoubleDoubleFunction minusMult(double constant) {
        return Functions.plusMult(-constant);
    }

    public static DoubleFunction mod(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return a % b;
            }
        };
    }

    public static DoubleFunction mult(double b) {
        return new Mult(b);
    }

    public static DoubleFunction plus(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return a + b;
            }
        };
    }

    public static DoubleDoubleFunction plusMult(double constant) {
        return new PlusMult(constant);
    }

    public static DoubleFunction pow(final double b) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                if (b == 2.0) {
                    return a * a;
                }
                return Math.pow(a, b);
            }
        };
    }

    public static DoubleFunction random() {
        return new MersenneTwister(new Date());
    }

    public static DoubleFunction round(final double precision) {
        return new DoubleFunction(){

            @Override
            public double apply(double a) {
                return Math.rint(a / precision) * precision;
            }
        };
    }

    public static DoubleDoubleFunction swapArgs(final DoubleDoubleFunction function) {
        return new DoubleDoubleFunction(){

            @Override
            public double apply(double a, double b) {
                return function.apply(b, a);
            }
        };
    }

    public static DoubleDoubleFunction minusAbsPow(final double exponent) {
        return new DoubleDoubleFunction(){

            @Override
            public double apply(double x, double y) {
                return Math.pow(Math.abs(x - y), exponent);
            }

            @Override
            public boolean isLikeRightPlus() {
                return false;
            }

            @Override
            public boolean isLikeLeftMult() {
                return false;
            }

            @Override
            public boolean isLikeRightMult() {
                return false;
            }

            @Override
            public boolean isCommutative() {
                return true;
            }

            @Override
            public boolean isAssociative() {
                return false;
            }
        };
    }
}

