/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;

public final class WeightedVectorComparator
implements Comparator<WeightedVector>,
Serializable {
    private static final double DOUBLE_EQUALITY_ERROR = 1.0E-8;

    @Override
    public int compare(WeightedVector a, WeightedVector b) {
        double bWeight;
        if (a == b) {
            return 0;
        }
        double aWeight = a.getWeight();
        int r = Double.compare(aWeight, bWeight = b.getWeight());
        if (r != 0 && Math.abs(aWeight - bWeight) >= 1.0E-8) {
            return r;
        }
        double diff = a.minus(b).norm(1.0);
        if (diff < 1.0E-12) {
            return 0;
        }
        for (Vector.Element element : a.all()) {
            r = Double.compare(element.get(), b.get(element.index()));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }
}

