/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.stream.Stream;

public final class FileUtils {
    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V findAdjacentFiles(Path directory, boolean dotFilesSkipped, Function<Stream<Path>, V> consumer) {
        try (Stream<Path> paths = Files.walk(directory, 1, new FileVisitOption[0]);){
            Stream<Path> filteredPaths2 = paths.filter(path -> {
                boolean hiddenFile;
                if (path.equals(directory)) {
                    return false;
                }
                boolean bl = hiddenFile = dotFilesSkipped && path.getFileName().toString().startsWith(".");
                return !hiddenFile;
            });
            V v = consumer.apply(filteredPaths2);
            return v;
        }
        catch (IOException error) {
            String message = String.format("failed walking directory: `%s`", directory);
            throw new UncheckedIOException(message, error);
        }
    }
}

