/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.thrift.transport;

import java.nio.ByteBuffer;
import org.apache.kyuubi.shaded.thrift.TByteArrayOutputStream;
import org.apache.kyuubi.shaded.thrift.TConfiguration;
import org.apache.kyuubi.shaded.thrift.transport.TEndpointTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;

public class TMemoryTransport
extends TEndpointTransport {
    private final ByteBuffer inputBuffer;
    private final TByteArrayOutputStream outputBuffer;

    public TMemoryTransport(byte[] input) throws TTransportException {
        super(new TConfiguration());
        this.inputBuffer = ByteBuffer.wrap(input);
        this.outputBuffer = new TByteArrayOutputStream(1024);
        this.updateKnownMessageSize(input.length);
    }

    public TMemoryTransport(TConfiguration config, byte[] input) throws TTransportException {
        super(config);
        this.inputBuffer = ByteBuffer.wrap(input);
        this.outputBuffer = new TByteArrayOutputStream(1024);
        this.updateKnownMessageSize(input.length);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        this.checkReadBytesAvailable(len);
        int remaining = this.inputBuffer.remaining();
        if (remaining < len) {
            throw new TTransportException(4, "There's only " + remaining + "bytes, but it asks for " + len);
        }
        this.inputBuffer.get(buf, off, len);
        return len;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.outputBuffer.write(buf, off, len);
    }

    public TByteArrayOutputStream getOutput() {
        return this.outputBuffer;
    }
}

