/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.etcd;

import com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClient$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceDiscovery;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$ServiceNode$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering$Long$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\u0011\rc\u0001B/_\u0001-D\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\u0006{\u0002!\tA \u0004\u0007\u0003\u000b\u0001\u0001)a\u0002\t\u0015\u0005U1A!f\u0001\n\u0003\t9\u0002\u0003\u0006\u00020\r\u0011\t\u0012)A\u0005\u00033A!\"!\r\u0004\u0005+\u0007I\u0011AA\u001a\u0011)\tYd\u0001B\tB\u0003%\u0011Q\u0007\u0005\u0007{\u000e!\t!!\u0010\t\u0013\u0005\u001d3!!A\u0005\u0002\u0005%\u0003\"CA(\u0007E\u0005I\u0011AA)\u0011%\t9gAI\u0001\n\u0003\tI\u0007C\u0005\u0002n\r\t\t\u0011\"\u0011\u0002p!I\u0011qP\u0002\u0002\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003\u0013\u001b\u0011\u0011!C\u0001\u0003\u0017C\u0011\"a&\u0004\u0003\u0003%\t%!'\t\u0013\u0005\u001d6!!A\u0005\u0002\u0005%\u0006\"CAZ\u0007\u0005\u0005I\u0011IA[\u0011%\t9lAA\u0001\n\u0003\nI\fC\u0005\u0002<\u000e\t\t\u0011\"\u0011\u0002>\u001eI\u0011\u0011\u0019\u0001\u0002\u0002#\u0005\u00111\u0019\u0004\n\u0003\u000b\u0001\u0011\u0011!E\u0001\u0003\u000bDa!`\u000b\u0005\u0002\u0005M\u0007\"CA\\+\u0005\u0005IQIA]\u0011%\t).FA\u0001\n\u0003\u000b9\u000eC\u0005\u0002^V\t\t\u0011\"!\u0002`\"Q\u0011\r\u0001a\u0001\u0002\u0004%\t!!=\t\u0017\t\u0015\u0001\u00011AA\u0002\u0013\u0005!q\u0001\u0005\f\u0005#\u0001\u0001\u0019!A!B\u0013\t\u0019\u0010C\u0006\u0003\u001c\u0001\u0001\r\u00111A\u0005\u0002\tu\u0001b\u0003B\u0013\u0001\u0001\u0007\t\u0019!C\u0001\u0005OA1Ba\u000b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003 !Y!q\u0006\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0019\u0011-\u0011I\u0004\u0001a\u0001\u0002\u0004%\tAa\u000f\t\u0017\t}\u0002\u00011A\u0001B\u0003&!1\u0007\u0005\f\u0005\u0007\u0002\u0001\u0019!a\u0001\n\u0003\u0011)\u0005C\u0006\u0003N\u0001\u0001\r\u00111A\u0005\u0002\t=\u0003b\u0003B*\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u000fB1Ba\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003Z!Y!1\f\u0001A\u0002\u0003\u0007I\u0011\u0001B/\u0011-\u0011\t\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u0010\t\u0017\t\u0015\u0004\u00011AA\u0002\u0013\u0005\u00111\u0007\u0005\f\u0005O\u0002\u0001\u0019!a\u0001\n\u0003\u0011I\u0007C\u0006\u0003n\u0001\u0001\r\u0011!Q!\n\u0005U\u0002b\u0002B9\u0001\u0011%!1\u000f\u0005\b\u0005k\u0002A\u0011\tB<\u0011\u001d\u0011I\b\u0001C!\u0005oBqAa\u001f\u0001\t\u0003\u0012i\bC\u0005\u0003\n\u0002\t\n\u0011\"\u0001\u0003\f\"9!q\u0012\u0001\u0005B\tE\u0005b\u0002BQ\u0001\u0011\u0005#1\u0015\u0005\b\u0005W\u0003A\u0011\tBW\u0011\u001d\u0011\u0019\r\u0001C!\u0005\u000bDqA!3\u0001\t\u0003\u0012Y\rC\u0004\u0003P\u0002!\tE!5\t\u0013\te\u0007!%A\u0005\u0002\t-\u0005b\u0002Bn\u0001\u0011\u0005#Q\u001c\u0005\b\u0005S\u0004A\u0011\tBv\u0011\u001d\u0019\u0019\u0002\u0001C!\u0007+Aqaa\b\u0001\t\u0003\u001a\t\u0003C\u0004\u0004*\u0001!\tea\u000b\t\u0013\r\u0015\u0003!%A\u0005\u0002\r\u001d\u0003\"CB&\u0001E\u0005I\u0011\u0001BF\u0011\u001d\u0019i\u0005\u0001C!\u0007\u001fB\u0011b!\u0019\u0001#\u0003%\taa\u0019\t\u0013\r\u001d\u0004!%A\u0005\u0002\t-\u0005bBB5\u0001\u0011\u0005#q\u000f\u0005\b\u0007W\u0002A\u0011IB7\u0011\u001d\u0019\t\b\u0001C!\u0007gB\u0011b!!\u0001#\u0003%\taa\u0019\t\u0013\r\r\u0005!%A\u0005\u0002\t-\u0005bBBC\u0001\u0011\u00053q\u0011\u0005\n\u0007g\u0003\u0011\u0013!C\u0001\u0005\u0017Cqa!.\u0001\t\u0003\u001a9\fC\u0005\u0004@\u0002\t\n\u0011\"\u0001\u0004B\"91Q\u0019\u0001\u0005\n\r\u001d\u0007\"CBo\u0001E\u0005I\u0011BB2\u0011%\u0019y\u000eAI\u0001\n\u0013\u0011Y\tC\u0005\u0004b\u0002\t\n\u0011\"\u0003\u0004d\u001a11q\u001d\u0001\u0001\u0007SD!ba\u001fP\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\u0011\to\u0014B\u0001B\u0003%!1\u001d\u0005\u0007{>#\taa@\t\u000f\u0011\u001dq\n\"\u0011\u0005\n!9A1D(\u0005B\u0011u\u0001b\u0002C\u0015\u001f\u0012\u0005#qO\u0004\b\tWq\u0006\u0012\u0001C\u0017\r\u0019if\f#\u0001\u00050!1Qp\u0016C\u0001\tcA\u0011\u0002b\rX\u0005\u0004%i!a\r\t\u0011\u0011Ur\u000b)A\u0007\u0003kA!\u0002b\u000eX\u0005\u0004%)A\u0018C\u001d\u0011!!\te\u0016Q\u0001\u000e\u0011m\"aE#uG\u0012$\u0015n]2pm\u0016\u0014\u0018p\u00117jK:$(BA0a\u0003\u0011)Go\u00193\u000b\u0005\u0005\u0014\u0017AB2mS\u0016tGO\u0003\u0002dI\u0006\u0011\u0001.\u0019\u0006\u0003K\u001a\faa[=vk\nL'BA4i\u0003\u0019\t\u0007/Y2iK*\t\u0011.A\u0002pe\u001e\u001c\u0001aE\u0002\u0001YJ\u0004\"!\u001c9\u000e\u00039T\u0011a\\\u0001\u0006g\u000e\fG.Y\u0005\u0003c:\u0014a!\u00118z%\u00164\u0007CA:u\u001b\u0005\u0001\u0017BA;a\u0005=!\u0015n]2pm\u0016\u0014\u0018p\u00117jK:$\u0018\u0001B2p]\u001a\u0004\"\u0001_>\u000e\u0003eT!A\u001f3\u0002\r\r|gNZ5h\u0013\ta\u0018P\u0001\u0006LsV,(-[\"p]\u001a\fa\u0001P5oSRtDcA@\u0002\u0004A\u0019\u0011\u0011\u0001\u0001\u000e\u0003yCQA\u001e\u0002A\u0002]\u00141bU3sm&\u001cWMT8eKN11\u0001\\A\u0005\u0003\u001f\u00012!\\A\u0006\u0013\r\tiA\u001c\u0002\b!J|G-^2u!\ri\u0017\u0011C\u0005\u0004\u0003'q'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00029bi\",\"!!\u0007\u0011\t\u0005m\u0011\u0011\u0006\b\u0005\u0003;\t)\u0003E\u0002\u0002 9l!!!\t\u000b\u0007\u0005\r\".\u0001\u0004=e>|GOP\u0005\u0004\u0003Oq\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"AB*ue&twMC\u0002\u0002(9\fQ\u0001]1uQ\u0002\nQ\u0001\\3bg\u0016,\"!!\u000e\u0011\u00075\f9$C\u0002\u0002:9\u0014A\u0001T8oO\u00061A.Z1tK\u0002\"b!a\u0010\u0002D\u0005\u0015\u0003cAA!\u00075\t\u0001\u0001C\u0004\u0002\u0016!\u0001\r!!\u0007\t\u000f\u0005E\u0002\u00021\u0001\u00026\u0005!1m\u001c9z)\u0019\ty$a\u0013\u0002N!I\u0011QC\u0005\u0011\u0002\u0003\u0007\u0011\u0011\u0004\u0005\n\u0003cI\u0001\u0013!a\u0001\u0003k\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002T)\"\u0011\u0011DA+W\t\t9\u0006\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA1]\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00141\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003WRC!!\u000e\u0002V\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001d\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005!A.\u00198h\u0015\t\tY(\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003k\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a!\u0011\u00075\f))C\u0002\u0002\b:\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!$\u0002\u0014B\u0019Q.a$\n\u0007\u0005EeNA\u0002B]fD\u0011\"!&\u000f\u0003\u0003\u0005\r!a!\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\n\u0005\u0004\u0002\u001e\u0006\r\u0016QR\u0007\u0003\u0003?S1!!)o\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\u000byJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAV\u0003c\u00032!\\AW\u0013\r\tyK\u001c\u0002\b\u0005>|G.Z1o\u0011%\t)\nEA\u0001\u0002\u0004\ti)\u0001\u0005iCND7i\u001c3f)\t\t\u0019)\u0001\u0005u_N#(/\u001b8h)\t\t\t(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\u000by\fC\u0005\u0002\u0016N\t\t\u00111\u0001\u0002\u000e\u0006Y1+\u001a:wS\u000e,gj\u001c3f!\r\t\t%F\n\u0006+\u0005\u001d\u0017q\u0002\t\u000b\u0003\u0013\fy-!\u0007\u00026\u0005}RBAAf\u0015\r\tiM\\\u0001\beVtG/[7f\u0013\u0011\t\t.a3\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002D\u0006)\u0011\r\u001d9msR1\u0011qHAm\u00037Dq!!\u0006\u0019\u0001\u0004\tI\u0002C\u0004\u00022a\u0001\r!!\u000e\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011]Aw!\u0015i\u00171]At\u0013\r\t)O\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f5\fI/!\u0007\u00026%\u0019\u00111\u001e8\u0003\rQ+\b\u000f\\33\u0011%\ty/GA\u0001\u0002\u0004\ty$A\u0002yIA*\"!a=\u0011\t\u0005U(\u0011A\u0007\u0003\u0003oTA!!?\u0002|\u0006)!.\u001a;dI*\u0019q,!@\u000b\u0005\u0005}\u0018AA5p\u0013\u0011\u0011\u0019!a>\u0003\r\rc\u0017.\u001a8u\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0005\u0005\u0013\u0011y\u0001E\u0002n\u0005\u0017I1A!\u0004o\u0005\u0011)f.\u001b;\t\u0013\u0005U5$!AA\u0002\u0005M\u0018aB2mS\u0016tG\u000f\t\u0015\u00049\tU\u0001cA7\u0003\u0018%\u0019!\u0011\u00048\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001b\u001b<DY&,g\u000e^\u000b\u0003\u0005?\u0001B!!>\u0003\"%!!1EA|\u0005\tYe+\u0001\u0007lm\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0003\n\t%\u0002\"CAK=\u0005\u0005\t\u0019\u0001B\u0010\u0003%Ygo\u00117jK:$\b\u0005K\u0002 \u0005+\t!\u0002\\8dW\u000ec\u0017.\u001a8u+\t\u0011\u0019\u0004\u0005\u0003\u0002v\nU\u0012\u0002\u0002B\u001c\u0003o\u0014A\u0001T8dW\u0006qAn\\2l\u00072LWM\u001c;`I\u0015\fH\u0003\u0002B\u0005\u0005{A\u0011\"!&\"\u0003\u0003\u0005\rAa\r\u0002\u00171|7m[\"mS\u0016tG\u000f\t\u0015\u0004E\tU\u0011a\u00037fCN,7\t\\5f]R,\"Aa\u0012\u0011\t\u0005U(\u0011J\u0005\u0005\u0005\u0017\n9PA\u0003MK\u0006\u001cX-A\bmK\u0006\u001cXm\u00117jK:$x\fJ3r)\u0011\u0011IA!\u0015\t\u0013\u0005UE%!AA\u0002\t\u001d\u0013\u0001\u00047fCN,7\t\\5f]R\u0004\u0003fA\u0013\u0003\u0016\u0005Y1/\u001a:wS\u000e,gj\u001c3f+\t\ty$A\btKJ4\u0018nY3O_\u0012,w\fJ3r)\u0011\u0011IAa\u0018\t\u0013\u0005Uu%!AA\u0002\u0005}\u0012\u0001D:feZL7-\u001a(pI\u0016\u0004\u0003f\u0001\u0015\u0003\u0016\u0005AA.Z1tKR#F*\u0001\u0007mK\u0006\u001cX\r\u0016+M?\u0012*\u0017\u000f\u0006\u0003\u0003\n\t-\u0004\"CAKU\u0005\u0005\t\u0019AA\u001b\u0003%aW-Y:f)Rc\u0005\u0005K\u0002,\u0005+\t1BY;jY\u0012\u001cE.[3oiR\u0011\u00111_\u0001\rGJ,\u0017\r^3DY&,g\u000e\u001e\u000b\u0003\u0005\u0013\t1b\u00197pg\u0016\u001cE.[3oi\u000611M]3bi\u0016$\u0002\"!\u0007\u0003\u0000\t\u0005%Q\u0011\u0005\b\u0003+y\u0003\u0019AA\r\u0011\u001d\u0011\u0019i\fa\u0001\u00033\tA!\\8eK\"I!qQ\u0018\u0011\u0002\u0003\u0007\u00111V\u0001\rGJ,\u0017\r^3QCJ,g\u000e^\u0001\u0011GJ,\u0017\r^3%I\u00164\u0017-\u001e7uIM*\"A!$+\t\u0005-\u0016QK\u0001\bO\u0016$H)\u0019;b)\u0011\u0011\u0019Ja(\u0011\u000b5\u0014)J!'\n\u0007\t]eNA\u0003BeJ\f\u0017\u0010E\u0002n\u00057K1A!(o\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005U\u0011\u00071\u0001\u0002\u001a\u000591/\u001a;ECR\fGCBAV\u0005K\u00139\u000bC\u0004\u0002\u0016I\u0002\r!!\u0007\t\u000f\t%&\u00071\u0001\u0003\u0014\u0006!A-\u0019;b\u0003-9W\r^\"iS2$'/\u001a8\u0015\t\t=&\u0011\u0019\t\u0007\u0005c\u0013Y,!\u0007\u000f\t\tM&q\u0017\b\u0005\u0003?\u0011),C\u0001p\u0013\r\u0011IL\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iLa0\u0003\t1K7\u000f\u001e\u0006\u0004\u0005ss\u0007bBA\u000bg\u0001\u0007\u0011\u0011D\u0001\u000ba\u0006$\b.\u0012=jgR\u001cH\u0003BAV\u0005\u000fDq!!\u00065\u0001\u0004\tI\"A\u0007qCRDgj\u001c8Fq&\u001cHo\u001d\u000b\u0005\u0003W\u0013i\rC\u0004\u0002\u0016U\u0002\r!!\u0007\u0002\r\u0011,G.\u001a;f)\u0019\u0011IAa5\u0003V\"9\u0011Q\u0003\u001cA\u0002\u0005e\u0001\"\u0003BlmA\u0005\t\u0019AAV\u00039!W\r\\3uK\u000eC\u0017\u000e\u001c3sK:\f\u0001\u0003Z3mKR,G\u0005Z3gCVdG\u000f\n\u001a\u0002\u00195|g.\u001b;peN#\u0018\r^3\u0015\t\t%!q\u001c\u0005\b\u0005CD\u0004\u0019\u0001Br\u0003A\u0019XM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018\u0010E\u0002t\u0005KL1Aa:a\u0005A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u00180A\u0006uef<\u0016\u000e\u001e5M_\u000e\\W\u0003\u0002Bw\u0005k$bAa<\u0004\f\r=A\u0003\u0002By\u0007\u0003\u0001BAa=\u0003v2\u0001Aa\u0002B|s\t\u0007!\u0011 \u0002\u0002)F!!1`AG!\ri'Q`\u0005\u0004\u0005\u007ft'a\u0002(pi\"Lgn\u001a\u0005\t\u0007\u0007ID\u00111\u0001\u0004\u0006\u0005\ta\rE\u0003n\u0007\u000f\u0011\t0C\u0002\u0004\n9\u0014\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0007\u001bI\u0004\u0019AA\r\u0003!awnY6QCRD\u0007bBB\ts\u0001\u0007\u0011QG\u0001\bi&lWm\\;u\u000359W\r^*feZ,'\u000fS8tiR!1qCB\u000e!\u0015i\u00171]B\r!\u001di\u0017\u0011^A\r\u0003\u0007Cqa!\b;\u0001\u0004\tI\"A\u0005oC6,7\u000f]1dK\u0006\u0001r-\u001a;F]\u001eLg.\u001a\"z%\u00164\u0017\n\u001a\u000b\u0007\u0007/\u0019\u0019c!\n\t\u000f\ru1\b1\u0001\u0002\u001a!91qE\u001eA\u0002\u0005e\u0011aC3oO&tWMU3g\u0013\u0012\f1cZ3u'\u0016\u0014h/[2f\u001d>$Wm]%oM>$\u0002b!\f\u0004:\rm2\u0011\t\t\u0007\u0005c\u001byca\r\n\t\rE\"q\u0018\u0002\u0004'\u0016\f\bcA:\u00046%\u00191q\u00071\u0003\u001fM+'O^5dK:{G-Z%oM>Dqa!\b=\u0001\u0004\tI\u0002C\u0005\u0004>q\u0002\n\u00111\u0001\u0004@\u000591/\u001b>f\u001fB$\b#B7\u0002d\u0006\r\u0005\"CB\"yA\u0005\t\u0019AAV\u0003\u0019\u0019\u0018\u000e\\3oi\u0006ir-\u001a;TKJ4\u0018nY3O_\u0012,7/\u00138g_\u0012\"WMZ1vYR$#'\u0006\u0002\u0004J)\"1qHA+\u0003u9W\r^*feZL7-\u001a(pI\u0016\u001c\u0018J\u001c4pI\u0011,g-Y;mi\u0012\u001a\u0014a\u0004:fO&\u001cH/\u001a:TKJ4\u0018nY3\u0015\u0019\t%1\u0011KB*\u0007+\u001a9f!\u0018\t\u000bY|\u0004\u0019A<\t\u000f\ruq\b1\u0001\u0002\u001a!9!\u0011] A\u0002\t\r\b\"CB-\u007fA\u0005\t\u0019AB.\u0003\u001d1XM]:j_:\u0004R!\\Ar\u00033A\u0011ba\u0018@!\u0003\u0005\r!a+\u0002\u0011\u0015DH/\u001a:oC2\f\u0011D]3hSN$XM]*feZL7-\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\r\u0016\u0005\u00077\n)&A\rsK\u001eL7\u000f^3s'\u0016\u0014h/[2fI\u0011,g-Y;mi\u0012*\u0014!\u00053fe\u0016<\u0017n\u001d;feN+'O^5dK\u0006)\u0002o\\:u\t\u0016\u0014XmZ5ti\u0016\u00148+\u001a:wS\u000e,G\u0003BAV\u0007_Bqa!\bD\u0001\u0004\tI\"A\fde\u0016\fG/Z!oI\u001e+GoU3sm&\u001cWMT8eKRa\u0011\u0011DB;\u0007o\u001aIh! \u0004\u0000!)a\u000f\u0012a\u0001o\"91Q\u0004#A\u0002\u0005e\u0001bBB>\t\u0002\u0007\u0011\u0011D\u0001\tS:\u001cH/\u00198dK\"I1\u0011\f#\u0011\u0002\u0003\u000711\f\u0005\n\u0007?\"\u0005\u0013!a\u0001\u0003W\u000b\u0011e\u0019:fCR,\u0017I\u001c3HKR\u001cVM\u001d<jG\u0016tu\u000eZ3%I\u00164\u0017-\u001e7uIQ\n\u0011e\u0019:fCR,\u0017I\u001c3HKR\u001cVM\u001d<jG\u0016tu\u000eZ3%I\u00164\u0017-\u001e7uIU\nqb\u001d;beR\u001cVm\u0019:fi:{G-\u001a\u000b\u000b\u0005\u0013\u0019Ii!$\u0004\u0012\u000eU\u0005bBBF\u000f\u0002\u0007\u0011\u0011D\u0001\u000bGJ,\u0017\r^3N_\u0012,\u0007bBBH\u000f\u0002\u0007\u0011\u0011D\u0001\tE\u0006\u001cX\rU1uQ\"911S$A\u0002\u0005e\u0011\u0001C5oSR$\u0015\r^1\t\u0013\r]u\t%AA\u0002\u0005-\u0016!D;tKB\u0013x\u000e^3di&|g\u000eK\u0002H\u00077\u0003Ba!(\u000406\u00111q\u0014\u0006\u0005\u0007C\u001b\u0019+A\u0006b]:|G/\u0019;j_:\u001c(\u0002BBS\u0007O\u000baaY8n[>t'\u0002BBU\u0007W\u000baaZ8pO2,'BABW\u0003\r\u0019w.\\\u0005\u0005\u0007c\u001byJA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\f\u0011d\u001d;beR\u001cVm\u0019:fi:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005yq-\u001a;B]\u0012Len\u0019:f[\u0016tG\u000f\u0006\u0004\u0002\u0004\u000ee61\u0018\u0005\b\u0003+I\u0005\u0019AA\r\u0011%\u0019i,\u0013I\u0001\u0002\u0004\t\u0019)A\u0003eK2$\u0018-A\rhKR\fe\u000eZ%oGJ,W.\u001a8uI\u0011,g-Y;mi\u0012\u0012TCABbU\u0011\t\u0019)!\u0016\u0002)\r\u0014X-\u0019;f!\u0016\u00148/[:uK:$hj\u001c3f)9\tyd!3\u0004L\u000e57qZBi\u0007'DQA^&A\u0002]Dqa!\bL\u0001\u0004\tI\u0002C\u0004\u0004|-\u0003\r!!\u0007\t\u0013\re3\n%AA\u0002\rm\u0003\"CB0\u0017B\u0005\t\u0019AAV\u0011%\u0019)n\u0013I\u0001\u0002\u0004\u00199.\u0001\u0006biR\u0014\u0018NY;uKN\u0004\u0002\"a\u0007\u0004Z\u0006e\u0011\u0011D\u0005\u0005\u00077\fiCA\u0002NCB\fad\u0019:fCR,\u0007+\u001a:tSN$XM\u001c;O_\u0012,G\u0005Z3gCVdG\u000f\n\u001b\u0002=\r\u0014X-\u0019;f!\u0016\u00148/[:uK:$hj\u001c3fI\u0011,g-Y;mi\u0012*\u0014AH2sK\u0006$X\rU3sg&\u001cH/\u001a8u\u001d>$W\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019)O\u000b\u0003\u0004X\u0006U#!\u0005#f%\u0016<\u0017n\u001d;fe^\u000bGo\u00195feN)qja;\u0004rB!\u00111OBw\u0013\u0011\u0019y/!\u001e\u0003\r=\u0013'.Z2u!\u0011\u0019\u0019p!?\u000f\t\u0005U8Q_\u0005\u0005\u0007o\f90A\u0003XCR\u001c\u0007.\u0003\u0003\u0004|\u000eu(\u0001\u0003'jgR,g.\u001a:\u000b\t\r]\u0018q\u001f\u000b\u0007\t\u0003!\u0019\u0001\"\u0002\u0011\u0007\u0005\u0005s\nC\u0004\u0004|I\u0003\r!!\u0007\t\u000f\t\u0005(\u000b1\u0001\u0003d\u00061qN\u001c(fqR$BA!\u0003\u0005\f!9AQB*A\u0002\u0011=\u0011!D<bi\u000eD'+Z:q_:\u001cX\r\u0005\u0003\u0005\u0012\u0011]QB\u0001C\n\u0015\u0011!)\"a>\u0002\u000b]\fGo\u00195\n\t\u0011eA1\u0003\u0002\u000e/\u0006$8\r\u001b*fgB|gn]3\u0002\u000f=tWI\u001d:peR!!\u0011\u0002C\u0010\u0011\u001d!\t\u0003\u0016a\u0001\tG\t\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\tEFQE\u0005\u0005\tO\u0011yLA\u0005UQJ|w/\u00192mK\u0006YqN\\\"p[BdW\r^3e\u0003M)Eo\u00193ESN\u001cwN^3ss\u000ec\u0017.\u001a8u!\r\t\taV\n\u0003/2$\"\u0001\"\f\u0002!1+\u0015iU#`\u001dVcEj\u0018,B\u0019V+\u0015!\u0005'F\u0003N+uLT+M\u0019~3\u0016\tT+FA\u0005\u0001BjT\"L?B\u000bE\u000bS0T+\u001a3\u0015\nW\u000b\u0003\twy!\u0001\"\u0010\"\u0005\u0011}\u0012!B\u0018m_\u000e\\\u0017!\u0005'P\u0007.{\u0006+\u0011+I?N+fIR%YA\u0001")
public class EtcdDiscoveryClient
implements DiscoveryClient {
    private volatile EtcdDiscoveryClient$ServiceNode$ ServiceNode$module;
    private final KyuubiConf conf;
    private volatile Client client;
    private volatile KV kvClient;
    private volatile Lock lockClient;
    private volatile Lease leaseClient;
    private volatile ServiceNode serviceNode;
    private volatile long leaseTTL;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    public EtcdDiscoveryClient$ServiceNode$ ServiceNode() {
        if (this.ServiceNode$module == null) {
            this.ServiceNode$lzycompute$1();
        }
        return this.ServiceNode$module;
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Client client() {
        return this.client;
    }

    public void client_$eq(Client x$1) {
        this.client = x$1;
    }

    public KV kvClient() {
        return this.kvClient;
    }

    public void kvClient_$eq(KV x$1) {
        this.kvClient = x$1;
    }

    public Lock lockClient() {
        return this.lockClient;
    }

    public void lockClient_$eq(Lock x$1) {
        this.lockClient = x$1;
    }

    public Lease leaseClient() {
        return this.leaseClient;
    }

    public void leaseClient_$eq(Lease x$1) {
        this.leaseClient = x$1;
    }

    public ServiceNode serviceNode() {
        return this.serviceNode;
    }

    public void serviceNode_$eq(ServiceNode x$1) {
        this.serviceNode = x$1;
    }

    public long leaseTTL() {
        return this.leaseTTL;
    }

    public void leaseTTL_$eq(long x$1) {
        this.leaseTTL = x$1;
    }

    private Client buildClient() {
        String[] endpoints = this.conf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES()).split(",");
        boolean sslEnabled = BoxesRunTime.unboxToBoolean(this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_ENABLED()));
        if (!sslEnabled) {
            return Client.builder().endpoints(endpoints).build();
        }
        String caPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).append(" is not defined").toString());
        });
        String crtPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_CRT_PATH().key()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_CRT_PATH().key()).append(" is not defined").toString());
        });
        String keyPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_KEY_PATH().key()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_KEY_PATH().key()).append(" is not defined").toString());
        });
        SslContext context = GrpcSslContexts.forClient().trustManager(new File(caPath)).keyManager(new File(crtPath), new File(keyPath)).build();
        return Client.builder().endpoints(endpoints).sslContext(context).build();
    }

    @Override
    public void createClient() {
        this.client_$eq(this.buildClient());
        this.kvClient_$eq(this.client().getKVClient());
        this.lockClient_$eq(this.client().getLockClient());
        this.leaseClient_$eq(this.client().getLeaseClient());
        this.leaseTTL_$eq(BoxesRunTime.unboxToLong(this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_LEASE_TIMEOUT())) / 1000L);
    }

    @Override
    public void closeClient() {
        if (this.client() != null) {
            this.client().close();
            return;
        }
    }

    @Override
    public String create(String path, String mode, boolean createParent) {
        String string = mode;
        if (!"PERSISTENT".equals(string)) {
            throw new KyuubiException(new StringBuilder(36).append("Create mode ").append(string).append(" is not support in etcd!").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        PutResponse cfr_ignored_0 = (PutResponse)this.kvClient().put(ByteSequence.from((byte[])path.getBytes()), ByteSequence.from((byte[])path.getBytes())).get();
        return path;
    }

    @Override
    public boolean create$default$3() {
        return true;
    }

    @Override
    public byte[] getData(String path) {
        GetResponse response = (GetResponse)this.kvClient().get(ByteSequence.from((byte[])path.getBytes())).get();
        if (response.getKvs().isEmpty()) {
            throw new KyuubiException(new StringBuilder(42).append("Key[").append(path).append("] not exists in ETCD, please check it.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return ((KeyValue)response.getKvs().get(0)).getValue().getBytes();
    }

    @Override
    public boolean setData(String path, byte[] data) {
        PutResponse response = (PutResponse)this.kvClient().put(ByteSequence.from((byte[])path.getBytes()), ByteSequence.from((byte[])data)).get();
        return response != null;
    }

    @Override
    public List<String> getChildren(String path) {
        java.util.List kvs = ((GetResponse)this.kvClient().get(ByteSequence.from((byte[])path.getBytes()), GetOption.newBuilder().isPrefix(true).build()).get()).getKvs();
        if (kvs.isEmpty()) {
            return List$.MODULE$.empty();
        }
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(kvs).asScala()).map((Function1<KeyValue, String> & Serializable & scala.Serializable)kv -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(kv.getKey().toString(StandardCharsets.UTF_8))).stripPrefix(path))).stripPrefix("/"), Buffer$.MODULE$.canBuildFrom())).filter((Function1<String, Object> & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean(EtcdDiscoveryClient.$anonfun$getChildren$2(key)))).toList();
    }

    @Override
    public boolean pathExists(String path) {
        return !this.pathNonExists(path);
    }

    @Override
    public boolean pathNonExists(String path) {
        return ((GetResponse)this.kvClient().get(ByteSequence.from((byte[])path.getBytes())).get()).getKvs().isEmpty();
    }

    @Override
    public void delete(String path, boolean deleteChildren) {
        this.kvClient().delete(ByteSequence.from((byte[])path.getBytes()), DeleteOption.newBuilder().isPrefix(deleteChildren).build()).get();
    }

    @Override
    public boolean delete$default$2() {
        return false;
    }

    @Override
    public void monitorState(ServiceDiscovery serviceDiscovery) {
    }

    @Override
    public <T> T tryWithLock(String lockPath, long timeout, Function0<T> f) {
        T t;
        long leaseTime = timeout / 1000L + 3L;
        long leaseId = ((LeaseGrantResponse)this.leaseClient().grant(leaseTime).get()).getID();
        try {
            try {
                this.lockClient().lock(ByteSequence.from((byte[])lockPath.getBytes()), leaseId).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(timeout).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), e);
            }
            t = f.apply();
        }
        catch (Throwable throwable) {
            try {
                this.lockClient().unlock(ByteSequence.from((byte[])lockPath.getBytes())).get();
                this.leaseClient().revoke(leaseId).get();
            }
            catch (Exception e) {
                throw new KyuubiException(e.getMessage(), e.getCause());
            }
            throw throwable;
        }
        T t2 = t;
        try {
            this.lockClient().unlock(ByteSequence.from((byte[])lockPath.getBytes())).get();
            this.leaseClient().revoke(leaseId).get();
        }
        catch (Exception e) {
            throw new KyuubiException(e.getMessage(), e.getCause());
        }
        return t2;
    }

    @Override
    public Option<Tuple2<String, Object>> getServerHost(String namespace) {
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(namespace, new Some<Object>(BoxesRunTime.boxToInteger(1)), true);
        Some<Seq<ServiceNodeInfo>> some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
            return new Some<Tuple2<String, Object>>(new Tuple2<String, Integer>(sn.host(), BoxesRunTime.boxToInteger(sn.port())));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Tuple2<String, Object>> getEngineByRefId(String namespace, String engineRefId) {
        String x$12 = namespace;
        boolean x$2 = true;
        Option<Object> x$3 = this.getServiceNodesInfo$default$2();
        return this.getServiceNodesInfo(x$12, x$3, x$2).find((Function1<ServiceNodeInfo, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(EtcdDiscoveryClient.$anonfun$getEngineByRefId$1(engineRefId, x$1))).map((Function1<ServiceNodeInfo, Tuple2> & Serializable & scala.Serializable)data -> new Tuple2<String, Integer>(data.host(), BoxesRunTime.boxToInteger(data.port())));
    }

    @Override
    public Seq<ServiceNodeInfo> getServiceNodesInfo(String namespace, Option<Object> sizeOpt, boolean silent) {
        Seq<Nothing$> seq;
        try {
            List<String> hosts = this.getChildren(DiscoveryPaths$.MODULE$.makePath(null, namespace, Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            int size = BoxesRunTime.unboxToInt(sizeOpt.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> hosts.size()));
            seq = ((List)hosts.takeRight(size)).map((Function1<String, ServiceNodeInfo> & Serializable & scala.Serializable)p -> {
                String path = DiscoveryPaths$.MODULE$.makePath(namespace, (String)p, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                String instance = new String(this.getData(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = DiscoveryClient$.MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2<String, Integer> tuple22 = new Tuple2<String, Integer>(host, BoxesRunTime.boxToInteger(port));
                String host2 = tuple22._1();
                int port2 = tuple22._2$mcI$sp();
                GenMap attributes = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).map((Function1<String, String[]> & Serializable & scala.Serializable)x$4 -> x$4.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1<String[], Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(EtcdDiscoveryClient.$anonfun$getServiceNodesInfo$4(x$5))))).map((Function1<String[], Tuple2> & Serializable & scala.Serializable)kv -> new Tuple2<Object, Object>(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])kv)).head(), new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])kv)).last()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Option<String> version = attributes.get("version");
                Option<String> engineRefId = attributes.get("refId");
                String engineIdStr = (String)attributes.get("kyuubi.engine.id").map((Function1<String, String> & Serializable & scala.Serializable)x$6 -> new StringBuilder(11).append(" engine id:").append((String)x$6).toString()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
                this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(engineIdStr).append(" and version:").append(version.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).append(" ").append("under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, version, engineRefId, (Map<String, String>)attributes);
            }, List$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            if (silent) {
                seq = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Failed to get service node info", exception);
                seq = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return seq;
    }

    @Override
    public Option<Object> getServiceNodesInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public boolean getServiceNodesInfo$default$3() {
        return false;
    }

    @Override
    public void registerService(KyuubiConf conf, String namespace, ServiceDiscovery serviceDiscovery, Option<String> version, boolean external) {
        String instance = serviceDiscovery.fe().connectionUrl();
        DeRegisterWatcher watcher = new DeRegisterWatcher(this, instance, serviceDiscovery);
        this.serviceNode_$eq(this.createPersistentNode(conf, namespace, instance, version, external, serviceDiscovery.fe().attributes()));
        this.client().getWatchClient().watch(ByteSequence.from((byte[])this.serviceNode().path().getBytes()), (Watch.Listener)watcher);
        if (this.pathNonExists(this.serviceNode().path())) {
            throw new KyuubiException(new StringBuilder(61).append("Unable to create keyValue for this Kyuubi ").append("instance[").append(instance).append("] on ETCD.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    @Override
    public Option<String> registerService$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean registerService$default$5() {
        return false;
    }

    @Override
    public void deregisterService() {
        if (this.serviceNode() != null) {
            if (this.serviceNode().lease() != EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE()) {
                this.client().getLeaseClient().revoke(this.serviceNode().lease());
                this.delete(this.serviceNode().path(), this.delete$default$2());
            }
            this.serviceNode_$eq(null);
            return;
        }
    }

    @Override
    public boolean postDeregisterService(String namespace) {
        if (namespace != null) {
            this.delete(DiscoveryPaths$.MODULE$.makePath(null, namespace, Predef$.MODULE$.wrapRefArray((Object[])new String[0])), true);
            return true;
        }
        return false;
    }

    @Override
    public String createAndGetServiceNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        return this.createPersistentNode(conf, namespace, instance, version, external, this.createPersistentNode$default$6()).path();
    }

    @Override
    public Option<String> createAndGetServiceNode$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean createAndGetServiceNode$default$5() {
        return false;
    }

    @Override
    @VisibleForTesting
    public void startSecretNode(String createMode, String basePath, String initData, boolean useProtection) {
        this.client().getKVClient().put(ByteSequence.from((byte[])basePath.getBytes()), ByteSequence.from((byte[])initData.getBytes())).get();
    }

    @Override
    public boolean startSecretNode$default$4() {
        return false;
    }

    @Override
    public int getAndIncrement(String path, int delta) {
        String lockPath = new StringBuilder(13).append(path).append("_tmp_for_lock").toString();
        return BoxesRunTime.unboxToInt(this.tryWithLock(lockPath, 60000L, (JFunction0$mcI$sp & scala.Serializable)() -> {
            Serializable serializable;
            if (this.pathNonExists(path)) {
                this.create(path, "PERSISTENT", this.create$default$3());
                serializable = BoxesRunTime.boxToBoolean(this.setData(path, String.valueOf(0).getBytes()));
            } else {
                serializable = BoxedUnit.UNIT;
            }
            int s = new StringOps(Predef$.MODULE$.augmentString(new String(this.getData(path)))).toInt();
            this.setData(path, String.valueOf(s + delta).getBytes());
            return s;
        }));
    }

    @Override
    public int getAndIncrement$default$2() {
        return 1;
    }

    private ServiceNode createPersistentNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external, Map<String, String> attributes) {
        String ns = DiscoveryPaths$.MODULE$.makePath(null, namespace, Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.create(ns, "PERSISTENT", this.create$default$3());
        String session = (String)((Option)((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID()))).map((Function1<String, String> & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
        String extraInfo = ((TraversableOnce)attributes.map((Function1<Tuple2, String> & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(";", ";", "");
        String pathPrefix = DiscoveryPaths$.MODULE$.makePath(namespace, new StringBuilder(29).append("serverUri=").append(instance).append(";version=").append(version.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(new StringOps(Predef$.MODULE$.augmentString(extraInfo)).stripSuffix(";")).append(";").append(session).append("sequence=").toString(), Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String znode = instance;
        LongRef leaseId = LongRef.create(EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE());
        ObjectRef<Object> realPath = ObjectRef.create(null);
        long timeout = BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.tryWithLock(new StringBuilder(5).append(ns).append("/lock").toString(), timeout, (Function0<PutResponse> & Serializable & scala.Serializable)() -> {
            List instances = this.getChildren(pathPrefix).map((Function1<String, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong(EtcdDiscoveryClient.$anonfun$createPersistentNode$6(pathPrefix, x$7)), List$.MODULE$.canBuildFrom());
            long sequence = instances.isEmpty() ? 0L : BoxesRunTime.unboxToLong(instances.max(Ordering$Long$.MODULE$)) + 1L;
            realPath$1.elem = new StringBuilder(0).append(pathPrefix).append(new StringOps(Predef$.MODULE$.augmentString("%010d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(sequence)}))).toString();
            if (external) {
                return (PutResponse)this.client().getKVClient().put(ByteSequence.from((byte[])((String)realPath$1.elem).getBytes()), ByteSequence.from((byte[])znode.getBytes())).get();
            }
            leaseId$1.elem = ((LeaseGrantResponse)this.client().getLeaseClient().grant(this.leaseTTL()).get()).getID();
            this.client().getLeaseClient().keepAlive(leaseId$1.elem, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(null){

                public void onNext(LeaseKeepAliveResponse v) {
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
            return (PutResponse)this.client().getKVClient().put(ByteSequence.from((byte[])((String)realPath$1.elem).getBytes()), ByteSequence.from((byte[])znode.getBytes()), PutOption.newBuilder().withLeaseId(leaseId$1.elem).build()).get();
        });
        return new ServiceNode(this, (String)realPath.elem, leaseId.elem);
    }

    private Option<String> createPersistentNode$default$4() {
        return None$.MODULE$;
    }

    private boolean createPersistentNode$default$5() {
        return false;
    }

    private Map<String, String> createPersistentNode$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void ServiceNode$lzycompute$1() {
        EtcdDiscoveryClient etcdDiscoveryClient = this;
        synchronized (etcdDiscoveryClient) {
            if (this.ServiceNode$module == null) {
                this.ServiceNode$module = new EtcdDiscoveryClient$ServiceNode$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getChildren$2(String key) {
        return new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() && !key.startsWith("lock");
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$1) {
        return x$1.engineRefId().exists((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.equals(engineRefId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNodesInfo$4(String[] x$5) {
        return x$5.length == 2;
    }

    public static final /* synthetic */ long $anonfun$createPersistentNode$6(String pathPrefix$1, String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(x$7)).stripPrefix(pathPrefix$1))).toLong();
    }

    public EtcdDiscoveryClient(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$(this);
    }

    public class DeRegisterWatcher
    implements Watch.Listener {
        private final String instance;
        private final ServiceDiscovery serviceDiscovery;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        public void onNext(WatchResponse watchResponse) {
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(watchResponse.getEvents()).asScala()).filter((Function1<WatchEvent, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(DeRegisterWatcher.$anonfun$onNext$1(x$8)))).foreach((Function1<WatchEvent, Object> & Serializable & scala.Serializable)x$9 -> {
                DeRegisterWatcher.$anonfun$onNext$2(this, x$9);
                return BoxedUnit.UNIT;
            });
        }

        public void onError(Throwable throwable) {
            throw new KyuubiException(throwable.getMessage(), throwable.getCause());
        }

        public void onCompleted() {
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$onNext$1(WatchEvent x$8) {
            WatchEvent.EventType eventType = x$8.getEventType();
            WatchEvent.EventType eventType2 = WatchEvent.EventType.DELETE;
            return !(eventType != null ? !eventType.equals(eventType2) : eventType2 != null);
        }

        public static final /* synthetic */ void $anonfun$onNext$2(DeRegisterWatcher $this, WatchEvent x$9) {
            $this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(123).append("This Kyuubi instance ").append($this.instance).append(" is now de-registered from").append(" ETCD. The server will be shut down after the last client session completes.").toString());
            ThreadUtils$.MODULE$.runInNewThread("deregister-watcher-thread", false, (JFunction0$mcV$sp & scala.Serializable)() -> $this.serviceDiscovery.stopGracefully($this.serviceDiscovery.stopGracefully$default$1()));
        }

        public DeRegisterWatcher(EtcdDiscoveryClient $outer, String instance, ServiceDiscovery serviceDiscovery) {
            this.instance = instance;
            this.serviceDiscovery = serviceDiscovery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class ServiceNode
    implements Product,
    scala.Serializable {
        private final String path;
        private final long lease;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        public String path() {
            return this.path;
        }

        public long lease() {
            return this.lease;
        }

        public ServiceNode copy(String path, long lease) {
            return new ServiceNode(this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer(), path, lease);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.lease();
        }

        @Override
        public String productPrefix() {
            return "ServiceNode";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this.lease());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServiceNode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, Statics.anyHash(this.path()));
            n = Statics.mix(n, Statics.longHash(this.lease()));
            return Statics.finalizeHash(n, 2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ServiceNode)) return false;
            if (((ServiceNode)object).org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() != this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ServiceNode serviceNode = (ServiceNode)x$1;
            String string = this.path();
            String string2 = serviceNode.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.lease() != serviceNode.lease()) return false;
            if (!serviceNode.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() {
            return this.$outer;
        }

        public ServiceNode(EtcdDiscoveryClient $outer, String path, long lease) {
            this.path = path;
            this.lease = lease;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

